/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.spring.cloud.config.aws.kms;

import de.zalando.spring.cloud.config.aws.kms.KmsTextEncryptorOptions;
import de.zalando.spring.cloud.config.aws.kms.OutputMode;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class EncryptedToken {
    private static final Pattern ENCRYPTED_STRING = Pattern.compile("^(?>\\((?<context>.*)\\)|\\[(?<options>.*)]){0,2}(?<cipher>.*)$");
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Function<String, String> BASE64_DECODE_VALUE = v -> new String(BASE64_DECODER.decode((String)v));
    private static final Function<String[], String> FIRST = arr -> arr[0];
    private static final Function<String[], String> SECOND = arr -> ((String[])arr).length > 1 ? arr[1] : "";
    private static final String PAIR_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private final ByteBuffer cipherBytes;
    private final Map<String, String> encryptionContext;
    private final KmsTextEncryptorOptions options;

    private EncryptedToken(ByteBuffer cipherBytes, Map<String, String> encryptionContext, KmsTextEncryptorOptions options) {
        this.cipherBytes = cipherBytes;
        this.encryptionContext = encryptionContext;
        this.options = options;
    }

    ByteBuffer getCipherBytes() {
        return this.cipherBytes;
    }

    Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    KmsTextEncryptorOptions getOptions() {
        return this.options;
    }

    static EncryptedToken parse(String s) {
        Assert.hasText((String)s, (String)"Encrypted string must not be blank");
        Matcher matcher = ENCRYPTED_STRING.matcher(s);
        Assert.isTrue((boolean)matcher.matches(), (String)("Malformed encrypted string '" + s + "'"));
        String contextString = matcher.group("context");
        String optionsString = matcher.group("options");
        String cipherString = matcher.group("cipher");
        return new EncryptedToken(EncryptedToken.parseCipher(cipherString), EncryptedToken.parseContext(contextString), EncryptedToken.parseOptions(optionsString));
    }

    private static ByteBuffer parseCipher(String valueString) {
        return ByteBuffer.wrap(BASE64_DECODER.decode(valueString.getBytes()));
    }

    private static KmsTextEncryptorOptions parseOptions(String optionsString) {
        Map<String, String> optionsMap = EncryptedToken.parseKeyValueMap(optionsString);
        OutputMode output = OutputMode.valueOf(Optional.ofNullable(optionsMap.get("output")).map(String::toUpperCase).orElse(OutputMode.PLAIN.name()));
        return new KmsTextEncryptorOptions(output);
    }

    private static Map<String, String> parseContext(String contextString) {
        return EncryptedToken.parseKeyValueMap(contextString, BASE64_DECODE_VALUE);
    }

    private static Map<String, String> parseKeyValueMap(String kvString) {
        return EncryptedToken.parseKeyValueMap(kvString, Function.identity());
    }

    private static Map<String, String> parseKeyValueMap(String kvString, Function<String, String> valueMapper) {
        return Stream.of(Optional.ofNullable(kvString).map(StringUtils::trimAllWhitespace).filter(StringUtils::hasText).map(s -> s.split(PAIR_SEPARATOR)).orElse(new String[0])).map(StringUtils::trimAllWhitespace).map(pair -> pair.split(KEY_VALUE_SEPARATOR, 2)).collect(Collectors.toMap(FIRST.andThen(StringUtils::trimAllWhitespace), SECOND.andThen(StringUtils::trimAllWhitespace).andThen(valueMapper)));
    }
}

