/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.spring.cloud.config.aws.kms;

import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.EncryptRequest;
import de.zalando.spring.cloud.config.aws.kms.EncryptedToken;
import de.zalando.spring.cloud.config.aws.kms.KmsTextEncryptorOptions;
import de.zalando.spring.cloud.config.aws.kms.OutputMode;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.Assert;

public class KmsTextEncryptor
implements TextEncryptor {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final String EMPTY_STRING = "";
    private final AWSKMS kms;
    private final String kmsKeyId;

    public KmsTextEncryptor(AWSKMS kms, String kmsKeyId) {
        Assert.notNull((Object)kms, (String)"KMS client must not be null");
        this.kms = kms;
        this.kmsKeyId = kmsKeyId;
    }

    public String encrypt(String text) {
        Assert.hasText((String)this.kmsKeyId, (String)"kmsKeyId must not be blank");
        if (text == null || text.isEmpty()) {
            return EMPTY_STRING;
        }
        EncryptRequest encryptRequest = new EncryptRequest().withKeyId(this.kmsKeyId).withPlaintext(ByteBuffer.wrap(text.getBytes()));
        ByteBuffer encryptedBytes = this.kms.encrypt(encryptRequest).getCiphertextBlob();
        return KmsTextEncryptor.extractString(encryptedBytes, new KmsTextEncryptorOptions(OutputMode.BASE64));
    }

    public String decrypt(String encryptedText) {
        if (encryptedText == null || encryptedText.isEmpty()) {
            return EMPTY_STRING;
        }
        EncryptedToken token = EncryptedToken.parse(encryptedText);
        DecryptRequest decryptRequest = new DecryptRequest().withCiphertextBlob(token.getCipherBytes()).withEncryptionContext(token.getEncryptionContext());
        return KmsTextEncryptor.extractString(this.kms.decrypt(decryptRequest).getPlaintext(), token.getOptions());
    }

    private static String extractString(ByteBuffer bb, KmsTextEncryptorOptions options) {
        if (bb.hasRemaining()) {
            byte[] bytes = new byte[bb.remaining()];
            bb.get(bytes, bb.arrayOffset(), bb.remaining());
            switch (options.getOutputMode()) {
                case BASE64: {
                    return BASE64_ENCODER.encodeToString(bytes);
                }
            }
            return new String(bytes);
        }
        return EMPTY_STRING;
    }
}

