/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.spring.cloud.config.aws.kms;

import de.zalando.spring.cloud.config.aws.kms.OutputMode;
import java.util.Objects;

class KmsTextEncryptorOptions {
    private static final OutputMode DEFAULT_OUTPUT_MODE = OutputMode.PLAIN;
    private final OutputMode outputMode;
    private final String keyId;
    private final String encryptionAlgorithm;

    KmsTextEncryptorOptions(OutputMode outputMode, String keyId, String encryptionAlgorithm) {
        this.outputMode = outputMode == null ? DEFAULT_OUTPUT_MODE : outputMode;
        this.keyId = keyId;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    OutputMode getOutputMode() {
        return this.outputMode;
    }

    String getKeyId() {
        return this.keyId;
    }

    String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KmsTextEncryptorOptions that = (KmsTextEncryptorOptions)o;
        return this.outputMode == that.outputMode && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.encryptionAlgorithm, that.encryptionAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.outputMode, this.keyId, this.encryptionAlgorithm});
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private OutputMode outputMode;
        private String keyId;
        private String encryptionAlgorithm;

        private Builder() {
        }

        public Builder withOutputMode(OutputMode outputMode) {
            this.outputMode = outputMode;
            return this;
        }

        public Builder withKeyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder withEncryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        public KmsTextEncryptorOptions build() {
            return new KmsTextEncryptorOptions(this.outputMode, this.keyId, this.encryptionAlgorithm);
        }
    }
}

