/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.stups.oauth2.spring.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.stups.oauth2.spring.server.AbstractAuthenticationExtractor;

public class DefaultAuthenticationExtractor
extends AbstractAuthenticationExtractor {
    private final Logger logger = LoggerFactory.getLogger(DefaultAuthenticationExtractor.class);

    @Override
    protected Set<String> resolveScopes(Map<String, Object> map) {
        Set<String> scopes = this.getScopesWithPermissionTrueFromMap(map);
        scopes = this.validateUidScope(scopes, map);
        return scopes;
    }

    protected Set<String> getScopesWithPermissionTrueFromMap(Map<String, Object> map) {
        HashSet scopes = new HashSet();
        HashSet<String> permissions = new HashSet<String>();
        try {
            Object scopeValue = map.get("scope");
            if (scopeValue != null) {
                if (scopeValue instanceof Collection) {
                    scopes.addAll((Collection)scopeValue);
                } else {
                    this.logger.warn("scope-value is {}", (Object)scopeValue.getClass().getName());
                }
            }
            for (String scope : scopes) {
                Object permission = map.get(scope);
                if (permission == null || !Boolean.parseBoolean(permission.toString())) continue;
                permissions.add(scope);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to get 'scope' value from map", (Throwable)e);
        }
        return permissions;
    }
}

