/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.stups.oauth2.spring.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.stups.oauth2.spring.server.AbstractAuthenticationExtractor;

public class LaxAuthenticationExtractor
extends AbstractAuthenticationExtractor {
    private final Logger logger = LoggerFactory.getLogger(LaxAuthenticationExtractor.class);

    @Override
    protected Set<String> resolveScopes(Map<String, Object> map) {
        Set<String> scopes = this.getScopesFromMap(map);
        scopes = this.validateUidScope(scopes, map);
        return scopes;
    }

    protected Set<String> getScopesFromMap(Map<String, Object> map) {
        HashSet<String> scopes = new HashSet<String>();
        try {
            Object scopeValue = map.get("scope");
            if (scopeValue != null) {
                if (scopeValue instanceof Collection) {
                    scopes.addAll((Collection)scopeValue);
                } else {
                    this.logger.warn("scope-value is {}", (Object)scopeValue.getClass().getName());
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to get 'scope' value from map", (Throwable)e);
        }
        return scopes;
    }
}

