/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.stups.oauth2.spring.server;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.BaseOAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.zalando.stups.oauth2.spring.server.AuthenticationExtractor;
import org.zalando.stups.oauth2.spring.server.DefaultAuthenticationExtractor;
import org.zalando.stups.oauth2.spring.server.UppercaseOAuth2AccessToken;

public class TokenInfoResourceServerTokenServices
implements ResourceServerTokenServices {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String tokenInfoEndpointUrl;
    protected String clientId;
    private OAuth2RestOperations restTemplate;
    private final AuthenticationExtractor authenticationExtractor;

    public TokenInfoResourceServerTokenServices(String tokenInfoEndpointUrl, String clientId) {
        this(tokenInfoEndpointUrl, clientId, new DefaultAuthenticationExtractor());
    }

    public TokenInfoResourceServerTokenServices(String tokenInfoEndpointUrl, String clientId, AuthenticationExtractor authenticationExtractor) {
        this.tokenInfoEndpointUrl = tokenInfoEndpointUrl;
        this.clientId = clientId;
        this.authenticationExtractor = authenticationExtractor;
        BaseOAuth2ProtectedResourceDetails resource = new BaseOAuth2ProtectedResourceDetails();
        resource.setClientId(clientId);
        this.restTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resource);
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        Map<String, Object> map = this.getMap(this.tokenInfoEndpointUrl, accessToken);
        if (map.containsKey("error")) {
            this.logger.debug("userinfo returned error: " + map.get("error"));
            throw new InvalidTokenException(accessToken);
        }
        return this.authenticationExtractor.extractAuthentication(map, this.clientId);
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: read access token");
    }

    protected Map<String, Object> getMap(String tokenInfoEndpointUrl, String accessToken) {
        Map map;
        this.logger.info("Getting token info from: " + tokenInfoEndpointUrl);
        OAuth2RestOperations restTemplate = this.restTemplate;
        restTemplate.getOAuth2ClientContext().setAccessToken((OAuth2AccessToken)new UppercaseOAuth2AccessToken(accessToken));
        Map result = map = (Map)restTemplate.getForEntity(tokenInfoEndpointUrl, Map.class, new Object[0]).getBody();
        return result;
    }

    public AuthenticationExtractor getAuthenticationExtractor() {
        return this.authenticationExtractor;
    }
}

