/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.models.Swagger;
import io.swagger.v3.oas.models.servers.Server;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="224", severity=Severity.MUST, title="Follow Naming Convention for Hostnames")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/zalando/zally/ruleset/zalando/FunctionalNamingForHostnamesRule;", "", "()V", "audienceExtension", "", "description", "functionHostnameURLRegEx", "Lkotlin/text/Regex;", "functionalComponent", "functionalDomain", "mayFollow", "", "mustFollow", "shouldFollow", "checkHostnames", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "audiencesToCheck", "checkHostnamesInOpenAPIServers", "checkHostnamesInSwaggerHost", "isUrlValid", "", "url", "isUrlValid$zally_ruleset_zalando", "mayFollowFunctionalNaming", "mustFollowFunctionalNaming", "shouldFollowFunctionalNaming", "zally-ruleset-zalando"})
public final class FunctionalNamingForHostnamesRule {
    private final String audienceExtension = "x-audience";
    private final String description = "hostname has to follow the functional naming schema";
    private final List<String> mustFollow = CollectionsKt.listOf((Object[])new String[]{"external-public", "external-partner"});
    private final List<String> shouldFollow = CollectionsKt.listOf((Object[])new String[]{"company-internal", "business-unit-internal"});
    private final List<String> mayFollow = CollectionsKt.listOf((Object)"component-internal");
    private final String functionalDomain = "[a-z][a-z0-9]*";
    private final String functionalComponent = "[a-z][a-z0-9-]*";
    private final Regex functionHostnameURLRegEx;

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> mustFollowFunctionalNaming(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.checkHostnames(context, this.mustFollow);
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> shouldFollowFunctionalNaming(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.checkHostnames(context, this.shouldFollow);
    }

    @Check(severity=Severity.MAY)
    @NotNull
    public final List<Violation> mayFollowFunctionalNaming(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.checkHostnames(context, this.mayFollow);
    }

    public final boolean isUrlValid$zally_ruleset_zalando(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return this.functionHostnameURLRegEx.matches((CharSequence)url);
    }

    private final List<Violation> checkHostnames(Context context, List<String> audiencesToCheck) {
        Object object = context.getApi().getInfo();
        return !CollectionsKt.contains((Iterable)audiencesToCheck, object != null && (object = object.getExtensions()) != null ? object.get(this.audienceExtension) : null) ? CollectionsKt.emptyList() : (context.getSwagger() != null ? this.checkHostnamesInSwaggerHost(context) : this.checkHostnamesInOpenAPIServers(context));
    }

    private final List<Violation> checkHostnamesInOpenAPIServers(Context context) {
        List list = context.getApi().getServers();
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<Server, Boolean>(this){
            final /* synthetic */ FunctionalNamingForHostnamesRule this$0;

            public final boolean invoke(Server it) {
                Server server = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)server, (String)"it");
                String string = server.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.url");
                return this.this$0.isUrlValid$zally_ruleset_zalando(string);
            }
            {
                this.this$0 = functionalNamingForHostnamesRule;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Server, Violation>(this, context){
            final /* synthetic */ FunctionalNamingForHostnamesRule this$0;
            final /* synthetic */ Context $context;

            @NotNull
            public final Violation invoke(Server it) {
                String string = FunctionalNamingForHostnamesRule.access$getDescription$p(this.this$0);
                Server server = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)server, (String)"it");
                String string2 = server.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.url");
                return this.$context.violation(string, (Object)string2);
            }
            {
                this.this$0 = functionalNamingForHostnamesRule;
                this.$context = context;
                super(1);
            }
        })));
    }

    private final List<Violation> checkHostnamesInSwaggerHost(Context context) {
        Swagger swagger = context.getSwagger();
        if (swagger == null) {
            Intrinsics.throwNpe();
        }
        String string = swagger.getHost();
        boolean bl = false;
        boolean bl2 = false;
        String host = string;
        boolean bl3 = false;
        return host == null || this.isUrlValid$zally_ruleset_zalando(host) ? CollectionsKt.emptyList() : context.violations(this.description, JsonPointerExtensionsKt.toJsonPointer((String)"/host"));
    }

    public FunctionalNamingForHostnamesRule() {
        Regex regex;
        String string = "(https://)?" + this.functionalDomain + '-' + this.functionalComponent + "\\.zalandoapis\\.com.*";
        FunctionalNamingForHostnamesRule functionalNamingForHostnamesRule = this;
        boolean bl = false;
        functionalNamingForHostnamesRule.functionHostnameURLRegEx = regex = new Regex(string);
    }

    public static final /* synthetic */ String access$getDescription$p(FunctionalNamingForHostnamesRule $this) {
        return $this.description;
    }
}

