/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="172", severity=Severity.SHOULD, title="Prefer standard media type names")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u00160\u0006*\u00020\u0014H\u0002J0\u0010\u0015\u001a$\u0012 \u0012\u001e\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u00160\u0006*\u0004\u0018\u00010\u0019H\u0002J\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0006*\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/zalando/zally/ruleset/zalando/MediaTypesRule;", "", "()V", "description", "", "standardMediaTypes", "", "versionedMediaType", "Lkotlin/text/Regex;", "isStandardJsonMediaType", "", "mediaType", "isVersionedMediaType", "validate", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "apiResponses", "", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "Lio/swagger/v3/oas/models/OpenAPI;", "mediaTypes", "Lkotlin/Pair;", "Lio/swagger/v3/oas/models/media/MediaType;", "kotlin.jvm.PlatformType", "Lio/swagger/v3/oas/models/media/Content;", "requestBodies", "Lio/swagger/v3/oas/models/parameters/RequestBody;", "zally-ruleset-zalando"})
public final class MediaTypesRule {
    private final Regex versionedMediaType;
    private final String description = "Custom media types should only be used for versioning";
    private final List<String> standardMediaTypes;

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        String type;
        Pair $type_$_$;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Iterable $this$filterNot$iv = this.mediaTypes(context.getApi());
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            $type_$_$ = (Pair)element$iv$iv;
            boolean bl = false;
            type = (String)$type_$_$.component1();
            if (this.isStandardJsonMediaType(type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            $type_$_$ = (Pair)element$iv$iv;
            boolean bl = false;
            type = (String)$type_$_$.component1();
            if (this.isVersionedMediaType(type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $$_$_value;
            $type_$_$ = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MediaType value = (MediaType)$$_$_value.component2();
            Violation violation = context.violation(this.description, (Object)value);
            collection.add(violation);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isStandardJsonMediaType(@NotNull String mediaType) {
        Intrinsics.checkParameterIsNotNull((Object)mediaType, (String)"mediaType");
        return this.standardMediaTypes.contains(mediaType);
    }

    public final boolean isVersionedMediaType(@NotNull String mediaType) {
        Intrinsics.checkParameterIsNotNull((Object)mediaType, (String)"mediaType");
        return this.versionedMediaType.matches((CharSequence)mediaType);
    }

    private final List<Pair<String, MediaType>> mediaTypes(@NotNull OpenAPI $receiver) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Object object;
        Content it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.requestBodies($receiver);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RequestBody requestBody = (RequestBody)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getContent();
            collection.add(object);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Content)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.mediaTypes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = this.apiResponses($receiver);
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ApiResponse)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Content content = it.getContent();
            object.add(content);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = (Iterable)object;
        $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Content)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.mediaTypes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        object = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
    }

    /*
     * WARNING - void declaration
     */
    private final List<RequestBody> requestBodies(@NotNull OpenAPI $receiver) {
        Iterable iterable;
        Iterable iterable2;
        Collection collection;
        Object object;
        Object object2 = $receiver.getComponents();
        Iterable iterable3 = object2 != null && (object2 = object2.getRequestBodies()) != null ? object2.values() : null;
        boolean bl = false;
        Collection collection2 = iterable3;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        if ((object = $receiver.getPaths()) != null && (object = object.values()) != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            iterable3 = (Iterable)object;
            collection = collection2;
            boolean $i$f$flatMap = false;
            void var4_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                PathItem path = (PathItem)element$iv$iv;
                boolean bl2 = false;
                Object object3 = path;
                if (object3 != null && (object3 = object3.readOperations()) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object3;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable4 = $this$mapNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        RequestBody requestBody;
                        Object element$iv$iv$iv;
                        Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                        boolean bl3 = false;
                        Operation op = (Operation)element$iv$iv2;
                        boolean bl4 = false;
                        Operation operation = op;
                        if ((operation != null ? operation.getRequestBody() : null) == null) continue;
                        requestBody = requestBody;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        RequestBody it$iv$iv = requestBody;
                        boolean bl7 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = null;
                }
                List list2 = list;
                boolean bl8 = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            iterable2 = (List)destination$iv$iv;
            collection2 = collection;
            iterable = iterable2;
        } else {
            iterable = null;
        }
        iterable3 = iterable;
        collection = collection2;
        bl = false;
        Iterable iterable5 = iterable3;
        if (iterable5 == null) {
            iterable5 = CollectionsKt.emptyList();
        }
        iterable2 = iterable5;
        return CollectionsKt.plus((Collection)collection, (Iterable)iterable2);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ApiResponse> apiResponses(@NotNull OpenAPI $receiver) {
        Iterable iterable;
        Iterable iterable2;
        Collection collection;
        Object object;
        Object object2 = $receiver.getComponents();
        Iterable iterable3 = object2 != null && (object2 = object2.getResponses()) != null ? object2.values() : null;
        boolean bl = false;
        Collection collection2 = iterable3;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        if ((object = $receiver.getPaths()) != null && (object = object.values()) != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            iterable3 = (Iterable)object;
            collection = collection2;
            boolean $i$f$flatMap = false;
            void var4_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                PathItem path = (PathItem)element$iv$iv;
                boolean bl2 = false;
                Object object3 = path;
                if (object3 != null && (object3 = object3.readOperations()) != null) {
                    void $this$flatMapTo$iv$iv2;
                    Iterable $this$flatMap$iv2 = (Iterable)object3;
                    boolean $i$f$flatMap2 = false;
                    Iterable iterable4 = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                        Operation op = (Operation)element$iv$iv2;
                        boolean bl3 = false;
                        Operation operation = op;
                        Collection collection3 = operation != null && (operation = operation.getResponses()) != null ? operation.values() : null;
                        boolean bl4 = false;
                        Collection collection4 = collection3;
                        if (collection4 == null) {
                            collection4 = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = collection4;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = null;
                }
                List list2 = list;
                boolean bl5 = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            iterable2 = (List)destination$iv$iv;
            collection2 = collection;
            iterable = iterable2;
        } else {
            iterable = null;
        }
        iterable3 = iterable;
        collection = collection2;
        bl = false;
        Iterable iterable5 = iterable3;
        if (iterable5 == null) {
            iterable5 = CollectionsKt.emptyList();
        }
        iterable2 = iterable5;
        return CollectionsKt.plus((Collection)collection, (Iterable)iterable2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, MediaType>> mediaTypes(@Nullable Content $receiver) {
        List list;
        Content content = $receiver;
        if (content != null) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = (Map)content;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var7_7.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to(it.getKey(), it.getValue());
                collection.add(pair);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list2 = list;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    public MediaTypesRule() {
        Regex regex;
        String string = "^\\w+/[-+.\\w]+;(v|version)=\\d+$";
        MediaTypesRule mediaTypesRule = this;
        boolean bl = false;
        mediaTypesRule.versionedMediaType = regex = new Regex(string);
        this.description = "Custom media types should only be used for versioning";
        this.standardMediaTypes = CollectionsKt.listOf((Object[])new String[]{"application/json", "application/problem+json", "application/json-patch+json", "application/merge-patch+json"});
    }
}

