/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="105", severity=Severity.MUST, title="Secure All Endpoints With Scopes")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\"\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0002JF\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u001a0\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000fH\u0002JB\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001e2\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u001a0\u00062\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000fH\u0002J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0006*\u0004\u0018\u00010!H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/zalando/zally/ruleset/zalando/SecureAllEndpointsWithScopesRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "pathWhitelist", "", "Lkotlin/text/Regex;", "scopeRegex", "checkDefinedScopeFormats", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkOperationsAreScoped", "defined", "", "", "", "api", "Lio/swagger/v3/oas/models/OpenAPI;", "pathFilter", "", "entry", "", "Lio/swagger/v3/oas/models/PathItem;", "requested", "Lkotlin/Pair;", "op", "Lio/swagger/v3/oas/models/Operation;", "undefined", "Ljava/util/SortedSet;", "allFlows", "Lio/swagger/v3/oas/models/security/OAuthFlow;", "Lio/swagger/v3/oas/models/security/SecurityScheme;", "zally-ruleset-zalando"})
public final class SecureAllEndpointsWithScopesRule {
    private final Regex scopeRegex;
    private final List<Regex> pathWhitelist;

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkDefinedScopeFormats(@NotNull Context context) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        SecurityScheme it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getApi().getComponents();
        Collection collection = object != null && (object = object.getSecuritySchemes()) != null ? object.values() : null;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = collection2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SecurityScheme)element$iv$iv;
            boolean bl2 = false;
            SecurityScheme securityScheme = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)securityScheme, (String)"it");
            if (!(securityScheme.getType() == SecurityScheme.Type.OAUTH2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SecurityScheme)element$iv$iv;
            boolean bl3 = false;
            list$iv$iv = this.allFlows(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String scope;
            Iterable $this$filterNotTo$iv$iv;
            OAuthFlow flow = (OAuthFlow)element$iv$iv;
            boolean bl4 = false;
            Map map = (Map)flow.getScopes();
            boolean bl5 = false;
            Map map2 = map;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Iterable $this$filterNot$iv = map2.keySet();
            boolean $i$f$filterNot = false;
            Iterable iterable2 = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                scope = (String)element$iv$iv2;
                boolean bl6 = false;
                String string = scope;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scope");
                if (this.scopeRegex.matches((CharSequence)string)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                scope = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv2;
                boolean bl7 = false;
                String string = "scope '" + scope + "' does not match regex '" + this.scopeRegex + '\'';
                Scopes scopes = flow.getScopes();
                Intrinsics.checkExpressionValueIsNotNull((Object)scopes, (String)"flow.scopes");
                Violation violation = context.violation(string, (Object)scopes);
                collection3.add(violation);
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkOperationsAreScoped(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Map<String, Set<String>> defined = this.defined(context.getApi());
        return Context.DefaultImpls.validateOperations$default((Context)context, (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends PathItem>, Boolean>(this){

            public final boolean invoke(@NotNull Map.Entry<String, ? extends PathItem> p1) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                return SecureAllEndpointsWithScopesRule.access$pathFilter((SecureAllEndpointsWithScopesRule)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SecureAllEndpointsWithScopesRule.class);
            }

            public final String getName() {
                return "pathFilter";
            }

            public final String getSignature() {
                return "pathFilter(Ljava/util/Map$Entry;)Z";
            }
        }), null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context, defined){
            final /* synthetic */ SecureAllEndpointsWithScopesRule this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Map $defined;

            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> $$_$_op) {
                List list;
                Operation op;
                Intrinsics.checkParameterIsNotNull($$_$_op, (String)"<name for destructuring parameter 0>");
                Operation operation = $$_$_op;
                boolean bl = false;
                Operation operation2 = op = operation.getValue();
                if (operation2 != null) {
                    operation = operation2;
                    bl = false;
                    boolean bl2 = false;
                    Operation it = operation;
                    boolean bl3 = false;
                    List requested = SecureAllEndpointsWithScopesRule.access$requested(this.this$0, this.$context.getApi(), op, this.$defined);
                    SortedSet undefined = SecureAllEndpointsWithScopesRule.access$undefined(this.this$0, requested, this.$defined);
                    if (requested.isEmpty()) {
                        List list2 = op.getSecurity();
                        if (list2 == null) {
                            list2 = op;
                        }
                        list = this.$context.violations("Endpoint not secured by OAuth2 scope(s)", (Object)list2);
                    } else {
                        Collection collection = undefined;
                        boolean bl4 = false;
                        if (!collection.isEmpty()) {
                            String string = "Endpoint secured by undefined OAuth2 scope(s): " + CollectionsKt.joinToString$default((Iterable)undefined, null, null, null, (int)0, null, null, (int)63, null);
                            List list3 = op.getSecurity();
                            if (list3 == null) {
                                list3 = op;
                            }
                            list = this.$context.violations(string, (Object)list3);
                        } else {
                            list = CollectionsKt.emptyList();
                        }
                    }
                } else {
                    list = null;
                }
                operation = list;
                bl = false;
                Object object = operation;
                if (object == null) {
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
            {
                this.this$0 = secureAllEndpointsWithScopesRule;
                this.$context = context;
                this.$defined = map;
                super(1);
            }
        }), (int)2, null);
    }

    private final boolean pathFilter(Map.Entry<String, ? extends PathItem> entry) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.pathWhitelist;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.containsMatchIn((CharSequence)entry.getKey())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final List<OAuthFlow> allFlows(@Nullable SecurityScheme $receiver) {
        SecurityScheme securityScheme;
        SecurityScheme securityScheme2;
        SecurityScheme securityScheme3;
        SecurityScheme securityScheme4 = $receiver;
        return CollectionsKt.listOfNotNull((Object[])new OAuthFlow[]{securityScheme4 != null && (securityScheme4 = securityScheme4.getFlows()) != null ? securityScheme4.getImplicit() : null, (securityScheme3 = $receiver) != null && (securityScheme3 = securityScheme3.getFlows()) != null ? securityScheme3.getPassword() : null, (securityScheme2 = $receiver) != null && (securityScheme2 = securityScheme2.getFlows()) != null ? securityScheme2.getClientCredentials() : null, (securityScheme = $receiver) != null && (securityScheme = securityScheme.getFlows()) != null ? securityScheme.getAuthorizationCode() : null});
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Set<String>> defined(OpenAPI api) {
        void $this$mapValuesTo$iv$iv;
        Components components = api.getComponents();
        Map map = components != null ? components.getSecuritySchemes() : null;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map $this$filterValues$iv = map2;
        boolean $i$f$filterValues = false;
        Map result$iv = new LinkedHashMap();
        Map map3 = $this$filterValues$iv;
        boolean bl2 = false;
        for (Map.Entry entry$iv : map3.entrySet()) {
            SecurityScheme scheme = (SecurityScheme)entry$iv.getValue();
            boolean bl3 = false;
            SecurityScheme securityScheme = scheme;
            Intrinsics.checkExpressionValueIsNotNull((Object)securityScheme, (String)"scheme");
            if (!(securityScheme.getType() == SecurityScheme.Type.OAUTH2)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$mapValues$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$flatMapTo$iv$iv;
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl4 = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map5 = map4;
            boolean bl5 = false;
            Iterable $this$flatMap$iv = this.allFlows((SecurityScheme)it.getValue());
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                OAuthFlow it2 = (OAuthFlow)element$iv$iv;
                boolean bl6 = false;
                Scopes scopes = it2.getScopes();
                Set set = scopes != null ? scopes.keySet() : null;
                boolean bl7 = false;
                Set set2 = set;
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                Iterable list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            map5.put(k2, set);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> requested(OpenAPI api, Operation op, Map<String, ? extends Set<String>> defined) {
        void $this$flatMapTo$iv$iv;
        Object object;
        Object object2 = op;
        if (object2 == null || (object2 = object2.getSecurity()) == null) {
            object2 = object = api.getSecurity();
        }
        if (object2 == null) {
            object = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = (Iterable)object;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            SecurityRequirement requirement = (SecurityRequirement)element$iv$iv;
            boolean bl = false;
            SecurityRequirement securityRequirement = requirement;
            Intrinsics.checkExpressionValueIsNotNull((Object)securityRequirement, (String)"requirement");
            Map $this$filterKeys$iv = (Map)securityRequirement;
            boolean $i$f$filterKeys = false;
            Map result$iv = new LinkedHashMap();
            Map map = $this$filterKeys$iv;
            boolean bl2 = false;
            for (Map.Entry entry$iv : map.entrySet()) {
                String name = (String)entry$iv.getKey();
                boolean bl3 = false;
                if (!defined.containsKey(name)) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map $this$flatMap$iv2 = result$iv;
            boolean $i$f$flatMap2 = false;
            result$iv = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            Iterator iterator = $this$flatMapTo$iv$iv2;
            boolean bl4 = false;
            Iterator iterator2 = iterator.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                List scopes;
                Map.Entry element$iv$iv2;
                Map.Entry $name_scopes = element$iv$iv2 = iterator2.next();
                boolean bl5 = false;
                Map.Entry entry = $name_scopes;
                boolean bl6 = false;
                String name = (String)entry.getKey();
                entry = $name_scopes;
                bl6 = false;
                List list = scopes = (List)entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"scopes");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl7 = false;
                    Pair pair = TuplesKt.to((Object)name, (Object)it);
                    collection.add(pair);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final SortedSet<String> undefined(List<Pair<String, String>> requested, Map<String, ? extends Set<String>> defined) {
        void $this$mapTo$iv$iv;
        Pair $name_scope;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = requested;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            $name_scope = (Pair)element$iv$iv;
            boolean bl = false;
            String name = (String)$name_scope.component1();
            String scope = (String)$name_scope.component2();
            Set set = defined.get(name);
            boolean bl2 = false;
            Set set2 = set;
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            if (set2.contains(scope)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            $name_scope = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = (String)it.getFirst() + ':' + (String)it.getSecond();
            collection.add(string);
        }
        return CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    public SecureAllEndpointsWithScopesRule(@NotNull Config rulesConfig) {
        Collection<Regex> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)rulesConfig, (String)"rulesConfig");
        String string = rulesConfig.getString(SecureAllEndpointsWithScopesRule.class.getSimpleName() + ".scope_regex");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rulesConfig.getString(\n \u2026e}.scope_regex\"\n        )");
        this.scopeRegex = new Regex(string);
        List list = rulesConfig.getStringList(SecureAllEndpointsWithScopesRule.class.getSimpleName() + ".path_whitelist");
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"rulesConfig.getStringLis\u2026me}.path_whitelist\"\n    )");
        Iterable iterable = list;
        SecureAllEndpointsWithScopesRule secureAllEndpointsWithScopesRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void var11_12;
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            boolean bl2 = false;
            Regex regex = new Regex((String)var11_12);
            collection.add(regex);
        }
        collection = (List)destination$iv$iv;
        secureAllEndpointsWithScopesRule.pathWhitelist = collection;
    }

    public static final /* synthetic */ boolean access$pathFilter(SecureAllEndpointsWithScopesRule $this, Map.Entry entry) {
        return $this.pathFilter(entry);
    }

    public static final /* synthetic */ List access$requested(SecureAllEndpointsWithScopesRule $this, OpenAPI api, Operation op, Map defined) {
        return $this.requested(api, op, defined);
    }

    public static final /* synthetic */ SortedSet access$undefined(SecureAllEndpointsWithScopesRule $this, List requested, Map defined) {
        return $this.undefined(requested, defined);
    }
}

