/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.Resources;
import com.typesafe.config.Config;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.core.JsonSchemaValidator;
import org.zalando.zally.core.ObjectTreeReader;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="101", severity=Severity.MUST, title="Provide API Specification using OpenAPI")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/zalando/zally/ruleset/zalando/UseOpenApiRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "jsonSchemaValidators", "", "Lorg/zalando/zally/ruleset/zalando/UseOpenApiRule$OpenApiVersion;", "Lorg/zalando/zally/core/JsonSchemaValidator;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkIfTheFormatIsYAML", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "getSchemaValidators", "config", "validateSchema", "", "spec", "Lcom/fasterxml/jackson/databind/JsonNode;", "OpenApiVersion", "zally-ruleset-zalando"})
public final class UseOpenApiRule {
    private final Logger log;
    private final Map<OpenApiVersion, JsonSchemaValidator> jsonSchemaValidators;

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validateSchema(@NotNull JsonNode spec) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        OpenApiVersion version = spec.get("swagger") != null ? OpenApiVersion.SWAGGER : OpenApiVersion.OPENAPI3;
        JsonSchemaValidator jsonSchemaValidator = this.jsonSchemaValidators.get((Object)version);
        List list = jsonSchemaValidator != null ? jsonSchemaValidator.validate(spec) : null;
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            Violation violation = (Violation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string2 = version.name();
            StringBuilder stringBuilder = new StringBuilder().append("Does not match ");
            boolean bl3 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            JsonPointer jsonPointer = it.getPointer();
            String string4 = stringBuilder.append(string).append(" schema: ").append(it.getDescription()).toString();
            Violation violation2 = new Violation(string4, jsonPointer);
            collection.add(violation2);
        }
        return (List)destination$iv$iv;
    }

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkIfTheFormatIsYAML(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = context.getSource();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String cleanedUpSource = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return StringsKt.startsWith$default((String)cleanedUpSource, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)cleanedUpSource, (String)"}", (boolean)false, (int)2, null) ? context.violation("must use YAML format", JsonPointerExtensionsKt.getEMPTY_JSON_POINTER()) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<OpenApiVersion, JsonSchemaValidator> getSchemaValidators(Config config) {
        void $this$mapTo$iv$iv;
        URL url;
        String string;
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        OpenApiVersion[] openApiVersionArray;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"http://json-schema.org/draft-04/schema", (Object)Resources.getResource((String)"schemas/json-schema.json")), TuplesKt.to((Object)"http://swagger.io/v2/schema.json", (Object)OpenApiVersion.SWAGGER.getResource()), TuplesKt.to((Object)"http://openapis.org/v3/schema.json", (Object)OpenApiVersion.OPENAPI3.getResource()), TuplesKt.to((Object)"https://spec.openapis.org/oas/3.0/schema/2019-04-02", (Object)OpenApiVersion.OPENAPI3.getResource())});
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        OpenApiVersion[] destination$iv$iv = (OpenApiVersion[])new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $$_$_url;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            openApiVersionArray = destination$iv$iv;
            boolean bl2 = false;
            object4 = it$iv$iv.getKey();
            object3 = (Map.Entry)element$iv$iv$iv;
            object2 = object4;
            object = openApiVersionArray;
            bl = false;
            string = $$_$_url;
            boolean bl3 = false;
            url = (URL)string.getValue();
            String string2 = url.toString();
            object.put(object2, string2);
        }
        OpenApiVersion[] defaultSchemaRedirects = destination$iv$iv;
        ObjectTreeReader reader = new ObjectTreeReader();
        OpenApiVersion[] $this$map$iv = OpenApiVersion.values();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair;
            void url2;
            void version;
            openApiVersionArray = item$iv$iv;
            object = destination$iv$iv2;
            boolean bl4 = false;
            object4 = version.name();
            object3 = new StringBuilder().append("schema_urls.");
            bl = false;
            Object object5 = object4;
            if (object5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object5).toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            String configPath = ((StringBuilder)object3).append(string).toString();
            url = config.hasPath(configPath) ? TuplesKt.to((Object)new URL(config.getString(configPath)), (Object)MapsKt.emptyMap()) : TuplesKt.to((Object)version.getResource(), (Object)defaultSchemaRedirects);
            object4 = (URL)url.component1();
            Map schemaRedirects = (Map)url.component2();
            try {
                JsonNode jsonNode = reader.read((URL)url2);
                boolean bl5 = false;
                boolean bl6 = false;
                JsonNode $receiver = jsonNode;
                boolean bl7 = false;
                JsonNode jsonNode2 = $receiver;
                if (jsonNode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                }
                ObjectNode cfr_ignored_0 = (ObjectNode)jsonNode2;
                ((ObjectNode)$receiver).remove("id");
                JsonNode schema = jsonNode;
                pair = TuplesKt.to((Object)version, (Object)new JsonSchemaValidator(schema, schemaRedirects));
            }
            catch (Exception e) {
                this.log.error("Unable to load schema: " + url2, (Throwable)e);
                throw (Throwable)e;
            }
            object2 = pair;
            object.add(object2);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv2));
    }

    public UseOpenApiRule(@NotNull Config rulesConfig) {
        Intrinsics.checkParameterIsNotNull((Object)rulesConfig, (String)"rulesConfig");
        this.log = LoggerFactory.getLogger(UseOpenApiRule.class);
        Config config = rulesConfig.getConfig(this.getClass().getSimpleName());
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"rulesConfig.getConfig(javaClass.simpleName)");
        this.jsonSchemaValidators = this.getSchemaValidators(config);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/zalando/zally/ruleset/zalando/UseOpenApiRule$OpenApiVersion;", "", "(Ljava/lang/String;I)V", "resource", "Ljava/net/URL;", "getResource", "()Ljava/net/URL;", "resource$delegate", "Lkotlin/Lazy;", "SWAGGER", "OPENAPI3", "zally-ruleset-zalando"})
    private static final class OpenApiVersion
    extends Enum<OpenApiVersion> {
        public static final /* enum */ OpenApiVersion SWAGGER;
        public static final /* enum */ OpenApiVersion OPENAPI3;
        private static final /* synthetic */ OpenApiVersion[] $VALUES;
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final Lazy resource$delegate = LazyKt.lazy((Function0)((Function0)new Function0<URL>(this){
            final /* synthetic */ OpenApiVersion this$0;

            public final URL invoke() {
                String string = this.this$0.name();
                StringBuilder stringBuilder = new StringBuilder().append("schemas/");
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                return Resources.getResource((String)stringBuilder.append(string4).append("-schema.json").toString());
            }
            {
                this.this$0 = openApiVersion;
                super(0);
            }
        }));

        static {
            OpenApiVersion[] openApiVersionArray = new OpenApiVersion[2];
            OpenApiVersion[] openApiVersionArray2 = openApiVersionArray;
            openApiVersionArray[0] = SWAGGER = new OpenApiVersion();
            openApiVersionArray[1] = OPENAPI3 = new OpenApiVersion();
            $VALUES = openApiVersionArray;
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(OpenApiVersion.class), "resource", "getResource()Ljava/net/URL;"))};
        }

        @NotNull
        public final URL getResource() {
            Lazy lazy = this.resource$delegate;
            OpenApiVersion openApiVersion = this;
            KProperty kProperty = $$delegatedProperties[0];
            boolean bl = false;
            return (URL)lazy.getValue();
        }

        public static OpenApiVersion[] values() {
            return (OpenApiVersion[])$VALUES.clone();
        }

        public static OpenApiVersion valueOf(String string) {
            return Enum.valueOf(OpenApiVersion.class, string);
        }
    }
}

