/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.fasterxml.jackson.core.JsonPointer;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="219", severity=Severity.MUST, title="Provide API Audience")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/zalando/zally/ruleset/zalando/ApiAudienceRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "extensionName", "", "extensionPointer", "Lcom/fasterxml/jackson/core/JsonPointer;", "invalidApiAudienceDesc", "noApiAudienceDesc", "validAudiences", "", "kotlin.jvm.PlatformType", "validate", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class ApiAudienceRule {
    @NotNull
    private final Set<String> validAudiences;
    @NotNull
    private final String noApiAudienceDesc;
    @NotNull
    private final String invalidApiAudienceDesc;
    @NotNull
    private final String extensionName;
    @NotNull
    private final JsonPointer extensionPointer;

    public ApiAudienceRule(@NotNull Config rulesConfig) {
        Intrinsics.checkNotNullParameter((Object)rulesConfig, (String)"rulesConfig");
        List list = rulesConfig.getStringList(this.getClass().getSimpleName() + ".audiences");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rulesConfig.getStringLis\u2026s.simpleName}.audiences\")");
        this.validAudiences = CollectionsKt.toSet((Iterable)list);
        this.noApiAudienceDesc = "API Audience must be provided";
        this.invalidApiAudienceDesc = "API Audience doesn't match " + this.validAudiences;
        this.extensionName = "x-audience";
        this.extensionPointer = JsonPointerExtensionsKt.toJsonPointer((String)("/info/" + this.extensionName));
    }

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation validate(@NotNull Context context) {
        Object audience;
        Object var3_3;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApi().getInfo();
        Object v1 = var3_3 = (audience = object != null && (object = object.getExtensions()) != null ? object.get(this.extensionName) : null);
        return (v1 == null ? true : !(v1 instanceof String)) ? context.violation(this.noApiAudienceDesc, this.extensionPointer) : (!this.validAudiences.contains(var3_3) ? context.violation(this.invalidApiAudienceDesc, this.extensionPointer) : null);
    }
}

