/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.info.Info;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="218", severity=Severity.MUST, title="Contain API Meta Information")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/zalando/zally/ruleset/zalando/ApiMetaInformationRule;", "", "()V", "versionRegex", "Lkotlin/text/Regex;", "checkContactEmail", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkContactName", "checkContactUrl", "checkInfoDescription", "checkInfoTitle", "checkInfoVersion", "zally-ruleset-zalando"})
public final class ApiMetaInformationRule {
    @NotNull
    private final Regex versionRegex = new Regex("^\\d+.\\d+(.\\d+)?");

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkInfoTitle(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Info info = context.getApi().getInfo();
        CharSequence charSequence = info != null ? info.getTitle() : null;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? context.violation("Title has to be provided", JsonPointerExtensionsKt.toJsonPointer((String)"/info/title")) : null;
    }

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkInfoDescription(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Info info = context.getApi().getInfo();
        CharSequence charSequence = info != null ? info.getDescription() : null;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? context.violation("Description has to be provided", JsonPointerExtensionsKt.toJsonPointer((String)"/info/description")) : null;
    }

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkInfoVersion(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Info info = context.getApi().getInfo();
        String version = info != null ? info.getVersion() : null;
        return version == null || StringsKt.isBlank((CharSequence)version) ? context.violation("Version has to be provided", JsonPointerExtensionsKt.toJsonPointer((String)"/info/version")) : (!this.versionRegex.matches((CharSequence)version) ? context.violation("Version has to follow the Semver rules", JsonPointerExtensionsKt.toJsonPointer((String)"/info/version")) : null);
    }

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkContactName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Info info = context.getApi().getInfo();
        CharSequence charSequence = info != null && (info = info.getContact()) != null ? info.getName() : null;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? context.violation("Contact name has to be provided", JsonPointerExtensionsKt.toJsonPointer((String)"/info/contact/name")) : null;
    }

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkContactUrl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Info info = context.getApi().getInfo();
        CharSequence charSequence = info != null && (info = info.getContact()) != null ? info.getUrl() : null;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? context.violation("Contact URL has to be provided", JsonPointerExtensionsKt.toJsonPointer((String)"/info/contact/url")) : null;
    }

    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkContactEmail(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Info info = context.getApi().getInfo();
        CharSequence charSequence = info != null && (info = info.getContact()) != null ? info.getEmail() : null;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? context.violation("Contact e-mail has to be provided", JsonPointerExtensionsKt.toJsonPointer((String)"/info/contact/email")) : null;
    }
}

