/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="125", severity=Severity.SHOULD, title="Represent enumerations as strings")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/zalando/zally/ruleset/zalando/EnumValueTypeRule;", "", "()V", "description", "", "validate", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class EnumValueTypeRule {
    @NotNull
    private final String description;

    public EnumValueTypeRule() {
        this.description = "Enumeration value should have \"type = string\"";
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean bl;
        Object it;
        Object $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object $this$filter$iv = OpenApiUtilKt.getAllSchemas((OpenAPI)context.getApi());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            it = (Schema)t;
            bl = false;
            if (!OpenApiUtilKt.isExtensibleEnum((Schema)it)) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            it = (Schema)t;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getType(), (Object)"string"))) continue;
            destination$iv$iv.add(t);
        }
        Object $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (Schema)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(context.violation(this.description + ": " + it.getName(), it));
        }
        $this$map$iv = OpenApiUtilKt.getAllProperties((OpenAPI)context.getApi());
        collection = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!OpenApiUtilKt.isExtensibleEnum((Schema)((Schema)it.getValue()))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)((Schema)it.getValue()).getType(), (Object)"string"))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            it = entry;
            Object object = destination$iv$iv;
            bl = false;
            object.add(context.violation(this.description + ": " + it.getKey(), it.getValue()));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }
}

