/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.swagger.models.Swagger;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;
import org.zalando.zally.ruleset.zalando.model.ApiAudience;
import org.zalando.zally.ruleset.zalando.model.UnsupportedAudienceException;
import org.zalando.zally.ruleset.zalando.model.ZallyOpenApiModelKt;

@Rule(ruleSet=ZalandoRuleSet.class, id="224", severity=Severity.MUST, title="Follow Naming Convention for Hostnames")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\n2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u001d\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b$J\u0018\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R0\u0010\u0007\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\n0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/zalando/zally/ruleset/zalando/FunctionalNamingForHostnamesRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "applicationId", "", "audienceExceptions", "", "kotlin.jvm.PlatformType", "", "getAudienceExceptions$annotations", "()V", "description", "functionHostnameURLRegEx", "Lkotlin/text/Regex;", "functionalComponent", "functionalDomain", "legacyHostnameURLRegEx", "mayFollow", "Lorg/zalando/zally/ruleset/zalando/model/ApiAudience;", "mustFollow", "organizationUnit", "shouldFollow", "checkHostnames", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "audiencesToCheck", "checkHostnamesInOpenAPIServers", "apiAudience", "checkHostnamesInSwaggerHost", "isUrlInExceptionList", "", "url", "isUrlValid", "isUrlValid$zally_ruleset_zalando", "isValidLegacyUrl", "mayFollowFunctionalNaming", "mustFollowFunctionalNaming", "shouldFollowFunctionalNaming", "zally-ruleset-zalando"})
public final class FunctionalNamingForHostnamesRule {
    @NotNull
    private final String description;
    @NotNull
    private final List<ApiAudience> mustFollow;
    @NotNull
    private final List<ApiAudience> shouldFollow;
    @NotNull
    private final List<ApiAudience> mayFollow;
    @NotNull
    private final String functionalDomain;
    @NotNull
    private final String functionalComponent;
    @NotNull
    private final Regex functionHostnameURLRegEx;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String organizationUnit;
    @NotNull
    private final Regex legacyHostnameURLRegEx;
    @NotNull
    private final Map<String, List<String>> audienceExceptions;

    /*
     * WARNING - void declaration
     */
    public FunctionalNamingForHostnamesRule(@NotNull Config rulesConfig) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rulesConfig, (String)"rulesConfig");
        this.description = "hostname has to follow the functional naming schema";
        Object object = new ApiAudience[]{ApiAudience.EXTERNAL_PUBLIC, ApiAudience.EXTERNAL_PARTNER};
        this.mustFollow = CollectionsKt.listOf((Object[])object);
        object = new ApiAudience[]{ApiAudience.COMPANY_INTERNAL, ApiAudience.BUSINESS_UNIT_INTERNAL};
        this.shouldFollow = CollectionsKt.listOf((Object[])object);
        this.mayFollow = CollectionsKt.listOf((Object)((Object)ApiAudience.COMPONENT_INTERNAL));
        this.functionalDomain = "[a-z][a-z0-9]*";
        this.functionalComponent = "[a-z][a-z0-9-]*";
        this.functionHostnameURLRegEx = new Regex("(https://)?" + this.functionalDomain + "-" + this.functionalComponent + "\\.zalandoapis\\.com.*");
        this.applicationId = "[a-z][a-z0-9]*";
        this.organizationUnit = "[a-z][a-z0-9]*";
        this.legacyHostnameURLRegEx = new Regex("(https://)?" + this.applicationId + "\\." + this.organizationUnit + "\\.zalan\\.do.*");
        Set set = rulesConfig.getConfig(this.getClass().getSimpleName() + ".audience_exceptions").entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"rulesConfig.getConfig(\"$\u2026e_exceptions\").entrySet()");
        object = set;
        FunctionalNamingForHostnamesRule functionalNamingForHostnamesRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, config)");
            String key = (String)entry.getKey();
            ConfigValue config = (ConfigValue)entry.getValue();
            Object object2 = config.unwrapped();
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String?>");
            }
            collection.add(TuplesKt.to((Object)key, (Object)((List)object2)));
        }
        functionalNamingForHostnamesRule.audienceExceptions = MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static /* synthetic */ void getAudienceExceptions$annotations() {
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> mustFollowFunctionalNaming(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checkHostnames(context, this.mustFollow);
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> shouldFollowFunctionalNaming(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checkHostnames(context, this.shouldFollow);
    }

    @Check(severity=Severity.MAY)
    @NotNull
    public final List<Violation> mayFollowFunctionalNaming(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.checkHostnames(context, this.mayFollow);
    }

    public final boolean isUrlValid$zally_ruleset_zalando(@NotNull String url, @NotNull ApiAudience apiAudience) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)apiAudience), (String)"apiAudience");
        return this.functionHostnameURLRegEx.matches((CharSequence)url) || this.isValidLegacyUrl(url, apiAudience) || this.isUrlInExceptionList(url, apiAudience);
    }

    private final boolean isValidLegacyUrl(String url, ApiAudience apiAudience) {
        return apiAudience == ApiAudience.COMPONENT_INTERNAL && this.legacyHostnameURLRegEx.matches((CharSequence)url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUrlInExceptionList(String url, ApiAudience apiAudience) {
        if (apiAudience != ApiAudience.EXTERNAL_PARTNER) return false;
        List<String> list = this.audienceExceptions.get(apiAudience.getCode());
        if (list == null) return false;
        boolean bl = list.contains(url);
        if (!bl) return false;
        return true;
    }

    private final List<Violation> checkHostnames(Context context, List<? extends ApiAudience> audiencesToCheck) {
        ApiAudience apiAudience;
        try {
            Info info = context.getApi().getInfo();
            apiAudience = info != null ? ZallyOpenApiModelKt.apiAudience(info) : null;
        }
        catch (UnsupportedAudienceException e) {
            return CollectionsKt.emptyList();
        }
        ApiAudience apiAudience2 = apiAudience;
        return apiAudience2 == null || !audiencesToCheck.contains((Object)apiAudience2) ? CollectionsKt.emptyList() : (context.getSwagger() != null ? this.checkHostnamesInSwaggerHost(context, apiAudience2) : this.checkHostnamesInOpenAPIServers(context, apiAudience2));
    }

    private final List<Violation> checkHostnamesInOpenAPIServers(Context context, ApiAudience apiAudience) {
        List list = context.getApi().getServers();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Server, Boolean>(this, apiAudience){
            final /* synthetic */ FunctionalNamingForHostnamesRule this$0;
            final /* synthetic */ ApiAudience $apiAudience;
            {
                this.this$0 = $receiver;
                this.$apiAudience = $apiAudience;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Server it) {
                String string = it.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.url");
                return this.this$0.isUrlValid$zally_ruleset_zalando(string, this.$apiAudience);
            }
        })), (Function1)((Function1)new Function1<Server, Violation>(context, this){
            final /* synthetic */ Context $context;
            final /* synthetic */ FunctionalNamingForHostnamesRule this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Violation invoke(Server it) {
                String string = FunctionalNamingForHostnamesRule.access$getDescription$p(this.this$0);
                String string2 = it.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.url");
                return this.$context.violation(string, (Object)string2);
            }
        })));
    }

    private final List<Violation> checkHostnamesInSwaggerHost(Context context, ApiAudience apiAudience) {
        Swagger swagger = context.getSwagger();
        Intrinsics.checkNotNull((Object)swagger);
        String host = swagger.getHost();
        boolean bl = false;
        return host == null || this.isUrlValid$zally_ruleset_zalando(host, apiAudience) ? CollectionsKt.emptyList() : context.violations(this.description, JsonPointerExtensionsKt.toJsonPointer((String)"/host"));
    }

    public static final /* synthetic */ String access$getDescription$p(FunctionalNamingForHostnamesRule $this) {
        return $this.description;
    }
}

