/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="151", severity=Severity.MUST, title="Specify Success and Error Responses")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0002J.\u0010\u0011\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u00150\u00130\u00122\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/zalando/zally/ruleset/zalando/JsonProblemAsDefaultResponseRule;", "", "()V", "validContentTypes", "", "", "validRefs", "checkContainsDefaultResponse", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkDefaultResponseIsProblemJsonMediaType", "checkDefaultResponseIsProblemJsonSchema", "isProblemJsonSchema", "", "schema", "Lio/swagger/v3/oas/models/media/Schema;", "responsesPerOperation", "", "Lkotlin/Pair;", "Lio/swagger/v3/oas/models/Operation;", "", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "zally-ruleset-zalando"})
public final class JsonProblemAsDefaultResponseRule {
    @NotNull
    private final List<String> validRefs;
    @NotNull
    private final List<String> validContentTypes;

    public JsonProblemAsDefaultResponseRule() {
        Object[] objectArray = new String[]{"https://opensource.zalando.com/restful-api-guidelines/models/problem-1.0.1.yaml#/Problem", "https://opensource.zalando.com/restful-api-guidelines/problem-1.0.1.yaml#/Problem", "https://opensource.zalando.com/restful-api-guidelines/models/problem-1.0.0.yaml#/Problem", "https://opensource.zalando.com/restful-api-guidelines/problem-1.0.0.yaml#/Problem", "https://opensource.zalando.com/problem/schema.yaml#/Problem", "https://zalando.github.io/problem/schema.yaml#/Problem"};
        this.validRefs = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"application/json", "application/problem+json"};
        this.validContentTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkContainsDefaultResponse(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Pair it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$filterNot$iv = this.responsesPerOperation(context);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (((Map)it.getSecond()).keySet().contains("default")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(context.violation("operation should contain the default response", it.getFirst()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkDefaultResponseIsProblemJsonMediaType(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$filter$iv = this.responsesPerOperation(context);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!((Map)it.getSecond()).keySet().contains("default")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            Map map = (Map)((ApiResponse)MapsKt.getValue((Map)((Map)it.getSecond()), (Object)"default")).getContent();
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            list$iv$iv = map.entrySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$flatMapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            list$iv$iv = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String contentType = (String)list$iv$iv.getKey();
            if (this.validContentTypes.contains(contentType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            collection.add(context.violation("media-type application/problem+json should be used as default response", v));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkDefaultResponseIsProblemJsonSchema(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$filter$iv = this.responsesPerOperation(context);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!((Map)it.getSecond()).keySet().contains("default")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            Map map = (Map)((ApiResponse)MapsKt.getValue((Map)((Map)it.getSecond()), (Object)"default")).getContent();
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            list$iv$iv = map.entrySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            list$iv$iv = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String contentType = (String)list$iv$iv.getKey();
            if (!this.validContentTypes.contains(contentType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            MediaType mediaType = (MediaType)it.getValue();
            if (CollectionsKt.contains((Iterable)this.validRefs, mediaType != null && (mediaType = mediaType.getSchema()) != null ? mediaType.get$ref() : null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            MediaType mediaType = (MediaType)it.getValue();
            if (this.isProblemJsonSchema((Schema<?>)(mediaType != null ? mediaType.getSchema() : null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            collection.add(context.violation("problem+json should be used as default response", v));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Pair<Operation, Map<String, ApiResponse>>> responsesPerOperation(Context context) {
        void $this$flatMapTo$iv$iv;
        Paths paths = context.getApi().getPaths();
        Collection collection = paths != null ? paths.values() : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PathItem it = (PathItem)element$iv$iv;
            boolean bl = false;
            PathItem pathItem = it;
            List list = pathItem != null ? pathItem.readOperations() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable2 = list;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void operation;
                Operation operation2 = (Operation)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Map map = (Map)operation.getResponses();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                collection2.add(new Pair((Object)operation, (Object)map));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProblemJsonSchema(Schema<?> schema) {
        Schema<?> schema2 = schema;
        Map map = schema2 != null ? schema2.getProperties() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map props = map;
        Schema schema3 = (Schema)props.get("type");
        if (!Intrinsics.areEqual((Object)(schema3 != null ? schema3.getType() : null), (Object)"string")) return false;
        Schema schema4 = (Schema)props.get("type");
        if (!Intrinsics.areEqual((Object)(schema4 != null ? schema4.getFormat() : null), (Object)"uri")) {
            Schema schema5 = (Schema)props.get("type");
            if (!Intrinsics.areEqual((Object)(schema5 != null ? schema5.getFormat() : null), (Object)"uri-reference")) return false;
        }
        Schema schema6 = (Schema)props.get("title");
        if (!Intrinsics.areEqual((Object)(schema6 != null ? schema6.getType() : null), (Object)"string")) return false;
        Schema schema7 = (Schema)props.get("status");
        if (!Intrinsics.areEqual((Object)(schema7 != null ? schema7.getType() : null), (Object)"integer")) return false;
        Schema schema8 = (Schema)props.get("status");
        if (!Intrinsics.areEqual((Object)(schema8 != null ? schema8.getFormat() : null), (Object)"int32")) return false;
        Schema schema9 = (Schema)props.get("detail");
        if (!Intrinsics.areEqual((Object)(schema9 != null ? schema9.getType() : null), (Object)"string")) return false;
        Schema schema10 = (Schema)props.get("instance");
        if (!Intrinsics.areEqual((Object)(schema10 != null ? schema10.getType() : null), (Object)"string")) return false;
        Schema schema11 = (Schema)props.get("instance");
        if (Intrinsics.areEqual((Object)(schema11 != null ? schema11.getFormat() : null), (Object)"uri")) return true;
        Schema schema12 = (Schema)props.get("instance");
        if (!Intrinsics.areEqual((Object)(schema12 != null ? schema12.getFormat() : null), (Object)"uri-reference")) return false;
        return true;
    }
}

