/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.CaseChecker;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="129", severity=Severity.MUST, title="Lowercase words with hyphens")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/zalando/zally/ruleset/zalando/KebabCaseInPathSegmentsRule;", "", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "checker", "Lorg/zalando/zally/core/CaseChecker;", "description", "", "lowerCaseHyphenSeparatedRegex", "Lkotlin/text/Regex;", "getLowerCaseHyphenSeparatedRegex$zally_ruleset_zalando", "()Lkotlin/text/Regex;", "checkKebabCaseInPathSegments", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class KebabCaseInPathSegmentsRule {
    @NotNull
    private final CaseChecker checker;
    @NotNull
    private final String description;
    @NotNull
    private final Regex lowerCaseHyphenSeparatedRegex;

    public KebabCaseInPathSegmentsRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.checker = CaseChecker.Companion.load(config);
        this.description = "Use lowercase separate words with hyphens for path segments";
        this.lowerCaseHyphenSeparatedRegex = new Regex("^[a-z-]+$");
    }

    @NotNull
    public final Regex getLowerCaseHyphenSeparatedRegex$zally_ruleset_zalando() {
        return this.lowerCaseHyphenSeparatedRegex;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkKebabCaseInPathSegments(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$map$iv = this.checker.checkPathSegments(context);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Violation violation = (Violation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Violation(this.description, it.getPointer()));
        }
        return (List)destination$iv$iv;
    }
}

