/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.util.PatternUtil;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="147", severity=Severity.SHOULD, title="Limit number of Sub-resources level")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/zalando/zally/ruleset/zalando/LimitNumberOfSubResourcesRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "description", "", "subResourcesLimit", "", "checkNumberOfSubResources", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class LimitNumberOfSubResourcesRule {
    private final int subResourcesLimit;
    @NotNull
    private final String description;

    public LimitNumberOfSubResourcesRule(@NotNull Config rulesConfig) {
        Intrinsics.checkNotNullParameter((Object)rulesConfig, (String)"rulesConfig");
        this.subResourcesLimit = rulesConfig.getConfig(this.getClass().getSimpleName()).getInt("subresources_limit");
        this.description = "Number of sub-resources should not exceed " + this.subResourcesLimit;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkNumberOfSubResources(@NotNull Context context) {
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        Map.Entry entry;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map map = (Map)context.getApi().getPaths();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Iterable $this$map$iv = map.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv2;
            entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String path = (String)entry.getKey();
            PathItem pathObj = (PathItem)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            String[] stringArray = new String[]{"/"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(((CharSequence)it).length() > 0 && !PatternUtil.INSTANCE.isPathVariable(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            PathItem pathItem = pathObj;
            Integer n = ((List)destination$iv$iv2).size() - 1;
            collection.add(new Pair((Object)n, (Object)pathItem));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            entry = (Pair)element$iv$iv;
            boolean bl = false;
            int numberOfSubResources = ((Number)entry.component1()).intValue();
            if (!(numberOfSubResources > this.subResourcesLimit)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            entry = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            PathItem pathObj = (PathItem)entry.component2();
            Intrinsics.checkNotNullExpressionValue((Object)pathObj, (String)"pathObj");
            collection.add(context.violation(this.description, (Object)pathObj));
        }
        return (List)destination$iv$iv;
    }
}

