/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="172", severity=Severity.SHOULD, title="Prefer standard media type names")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\u001a0\n*\u00020\u0018H\u0002J0\u0010\u0019\u001a$\u0012 \u0012\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001b0\u001b0\u001a0\n*\u0004\u0018\u00010\u001cH\u0002J\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\n*\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u0006 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/zalando/zally/ruleset/zalando/MediaTypesRule;", "", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "description", "", "standardMediaTypes", "", "kotlin.jvm.PlatformType", "", "versionedMediaType", "Lkotlin/text/Regex;", "isStandardJsonMediaType", "", "mediaType", "isVersionedMediaType", "validate", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "apiResponses", "", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "Lio/swagger/v3/oas/models/OpenAPI;", "mediaTypes", "Lkotlin/Pair;", "Lio/swagger/v3/oas/models/media/MediaType;", "Lio/swagger/v3/oas/models/media/Content;", "requestBodies", "Lio/swagger/v3/oas/models/parameters/RequestBody;", "zally-ruleset-zalando"})
public final class MediaTypesRule {
    @NotNull
    private final Regex versionedMediaType;
    @NotNull
    private final String description;
    private final List<String> standardMediaTypes;

    public MediaTypesRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.versionedMediaType = new Regex("^\\w+/[-+.\\w]+;(v|version)=\\d+$");
        this.description = "Custom media types should only be used for versioning";
        this.standardMediaTypes = config.getStringList(this.getClass().getSimpleName() + ".standard_media_types");
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        String type;
        Pair pair;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$filterNot$iv = this.mediaTypes(context.getApi());
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            type = (String)pair.component1();
            if (this.isStandardJsonMediaType(type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            type = (String)pair.component1();
            if (this.isVersionedMediaType(type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MediaType value = (MediaType)pair.component2();
            collection.add(context.violation(this.description, (Object)value));
        }
        return (List)destination$iv$iv;
    }

    public final boolean isStandardJsonMediaType(@NotNull String mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        return this.standardMediaTypes.contains(mediaType);
    }

    public final boolean isVersionedMediaType(@NotNull String mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        return this.versionedMediaType.matches((CharSequence)mediaType);
    }

    private final List<Pair<String, MediaType>> mediaTypes(OpenAPI $this$mediaTypes) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Content it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.requestBodies($this$mediaTypes);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RequestBody requestBody = (RequestBody)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContent());
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Content)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.mediaTypes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = this.apiResponses($this$mediaTypes);
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ApiResponse)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getContent());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Content)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.mediaTypes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<RequestBody> requestBodies(OpenAPI $this$requestBodies) {
        List list;
        List list2;
        Object object;
        Collection collection;
        Object object2 = $this$requestBodies.getComponents();
        if ((object2 != null && (object2 = object2.getRequestBodies()) != null ? object2.values() : (collection = null)) == null) {
            collection = CollectionsKt.emptyList();
        }
        if ((object = $this$requestBodies.getPaths()) != null && (object = object.values()) != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = (Iterable)object;
            Collection collection2 = collection;
            boolean $i$f$flatMap = false;
            void var4_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list3;
                List list4;
                List list5;
                PathItem path = (PathItem)element$iv$iv;
                boolean bl = false;
                Object object3 = path;
                if (object3 != null && (object3 = (list5 = object3.readOperations())) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"readOperations()");
                    Iterable $this$mapNotNull$iv = list5;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        RequestBody it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        Operation op = (Operation)element$iv$iv2;
                        boolean bl3 = false;
                        Operation operation = op;
                        if ((operation != null ? operation.getRequestBody() : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl4 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    list4 = (List)destination$iv$iv2;
                } else {
                    list4 = list3 = null;
                }
                if (list4 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            collection = collection2;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ApiResponse> apiResponses(OpenAPI $this$apiResponses) {
        List list;
        List list2;
        Object object;
        Collection collection;
        Object object2 = $this$apiResponses.getComponents();
        if ((object2 != null && (object2 = object2.getResponses()) != null ? object2.values() : (collection = null)) == null) {
            collection = CollectionsKt.emptyList();
        }
        if ((object = $this$apiResponses.getPaths()) != null && (object = object.values()) != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = (Iterable)object;
            Collection collection2 = collection;
            boolean $i$f$flatMap = false;
            void var4_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list3;
                List list4;
                List list5;
                PathItem path = (PathItem)element$iv$iv;
                boolean bl = false;
                Object object3 = path;
                if (object3 != null && (object3 = (list5 = object3.readOperations())) != null) {
                    void $this$flatMapTo$iv$iv2;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"readOperations()");
                    Iterable $this$flatMap$iv2 = list5;
                    boolean $i$f$flatMap2 = false;
                    Iterable iterable2 = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                        Collection collection3;
                        Operation op = (Operation)element$iv$iv2;
                        boolean bl2 = false;
                        Operation operation = op;
                        if ((operation != null && (operation = operation.getResponses()) != null ? operation.values() : (collection3 = null)) == null) {
                            collection3 = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = collection3;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    list4 = (List)destination$iv$iv2;
                } else {
                    list4 = list3 = null;
                }
                if (list4 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            collection = collection2;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, MediaType>> mediaTypes(Content $this$mediaTypes) {
        List list;
        List list2;
        if ($this$mediaTypes != null) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = (Map)$this$mediaTypes;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getKey(), it.getValue()));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

