/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="115", severity=Severity.MUST, title="Do Not Use URI Versioning")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/zalando/zally/ruleset/zalando/NoVersionInUriRule;", "", "()V", "description", "", "versionRegex", "Lkotlin/text/Regex;", "checkServerURLs", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "violatingPaths", "", "Lio/swagger/v3/oas/models/PathItem;", "api", "Lio/swagger/v3/oas/models/OpenAPI;", "violatingServers", "Lio/swagger/v3/oas/models/servers/Server;", "zally-ruleset-zalando"})
public final class NoVersionInUriRule {
    @NotNull
    private final String description;
    @NotNull
    private final Regex versionRegex = new Regex("(.*)v[0-9]+(.*)");

    public NoVersionInUriRule() {
        this.description = "URL contains version number";
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkServerURLs(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$map$iv = CollectionsKt.plus(this.violatingServers(context.getApi()), (Iterable)this.violatingPaths(context.getApi()));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(context.violation(this.description, (Object)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Server> violatingServers(OpenAPI api) {
        void $this$filterTo$iv$iv;
        List list = api.getServers();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            String string;
            Server it = (Server)element$iv$iv;
            boolean bl2 = false;
            Object object = it;
            if (object != null && (object = (string = object.getUrl())) != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"url");
                CharSequence charSequence = string;
                bl = this.versionRegex.matches(charSequence);
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PathItem> violatingPaths(OpenAPI api) {
        void $this$mapTo$iv$iv;
        Map.Entry entry;
        Iterable $this$filterTo$iv$iv;
        Map map = (Map)api.getPaths();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Iterable $this$filter$iv = map.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String path = (String)entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            CharSequence charSequence = path;
            if (!this.versionRegex.matches(charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PathItem pathEntry = (PathItem)entry.getValue();
            collection.add(pathEntry);
        }
        return (List)destination$iv$iv;
    }
}

