/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.core.util.OpenApiUtilKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="104", severity=Severity.MUST, title="Secure Endpoints")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\n"}, d2={"Lorg/zalando/zally/ruleset/zalando/SecureAllEndpointsRule;", "", "()V", "checkHasNoInvalidSecuritySchemes", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkHasValidSecuritySchemes", "checkUsedScopesAreSpecified", "zally-ruleset-zalando"})
public final class SecureAllEndpointsRule {
    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @Nullable
    public final Violation checkHasValidSecuritySchemes(@NotNull Context context) {
        List valid;
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApi().getComponents();
        if (object != null && (object = object.getSecuritySchemes()) != null && (object = object.values()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SecurityScheme it = (SecurityScheme)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!(OpenApiUtilKt.isOAuth2((SecurityScheme)it) || OpenApiUtilKt.isBearer((SecurityScheme)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return (valid = list).isEmpty() ? context.violation("API must be secured by OAuth2 or Bearer Authentication", JsonPointerExtensionsKt.toJsonPointer((String)"/components/securitySchemes")) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkHasNoInvalidSecuritySchemes(@NotNull Context context) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApi().getComponents();
        if (object != null && (object = object.getSecuritySchemes()) != null && (object = object.values()) != null) {
            void $this$mapTo$iv$iv;
            SecurityScheme it;
            Iterable $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = (Iterable)object;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (SecurityScheme)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (OpenApiUtilKt.isOAuth2((SecurityScheme)it) || OpenApiUtilKt.isBearer((SecurityScheme)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (SecurityScheme)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(context.violation("API must be secured by OAuth2 or Bearer Authentication", (Object)it));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkUsedScopesAreSpecified(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        String group;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable list$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$flatMap$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv2;
        Object object;
        Object scheme;
        void $this$flatMapTo$iv$iv2;
        void $this$flatMap$iv3;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Set set;
        SecurityScheme scheme2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Set set2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.isOpenAPI3()) {
            return CollectionsKt.emptyList();
        }
        Object object2 = context.getApi().getComponents();
        if ((object2 != null && (object2 = object2.getSecuritySchemes()) != null ? object2.entrySet() : (set2 = null)) == null) {
            set2 = SetsKt.emptySet();
        }
        Iterable $this$map$iv2 = set2;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator iterator = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            String group2 = (String)iterator.getKey();
            scheme2 = (SecurityScheme)iterator.getValue();
            collection.add(TuplesKt.to((Object)group2, (Object)scheme2));
        }
        Map specifiedSchemes = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        Object object3 = context.getApi().getComponents();
        if ((object3 != null && (object3 = object3.getSecuritySchemes()) != null ? object3.entrySet() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        Iterable $i$f$map22 = set;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Map.Entry bl = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            scheme2 = (SecurityScheme)bl.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)scheme2, (String)"scheme");
            if (!OpenApiUtilKt.isOAuth2((SecurityScheme)scheme2)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv3;
        boolean $i$f$flatMap22 = false;
        $this$filterTo$iv$iv2 = $this$flatMap$iv3;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$flatMapTo$iv$iv3;
            Map.Entry bl = (Map.Entry)element$iv$iv;
            boolean bl3 = false;
            String group3 = (String)bl.getKey();
            scheme = (SecurityScheme)bl.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)scheme, (String)"scheme");
            Iterable $this$flatMap$iv4 = OpenApiUtilKt.allFlows((SecurityScheme)scheme);
            boolean $i$f$flatMap4 = false;
            Iterable iterable2 = $this$flatMap$iv4;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv3) {
                void $this$mapTo$iv$iv3;
                void $this$map$iv3;
                OAuthFlow flow = (OAuthFlow)element$iv$iv2;
                boolean bl4 = false;
                Scopes scopes = flow.getScopes();
                Set set3 = scopes != null ? scopes.keySet() : null;
                if (set3 == null) {
                    set3 = SetsKt.emptySet();
                }
                Iterable iterable3 = set3;
                boolean $i$f$map3 = false;
                void var26_69 = $this$map$iv3;
                Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                    void scope;
                    object = (String)item$iv$iv2;
                    Collection collection2 = destination$iv$iv5;
                    boolean bl5 = false;
                    collection2.add(TuplesKt.to((Object)group3, (Object)scope));
                }
                Iterable list$iv$iv2 = (List)destination$iv$iv5;
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv2);
            }
            Iterable list$iv$iv3 = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv3);
        }
        Set specifiedScopes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Paths paths = context.getApi().getPaths();
        Collection collection3 = paths != null ? paths.values() : null;
        if (collection3 == null) {
            collection3 = CollectionsKt.emptyList();
        }
        Iterable $i$f$flatMap22 = collection3;
        boolean $i$f$flatMap = false;
        destination$iv$iv3 = $this$flatMap$iv2;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$flatMapTo3 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv4;
            PathItem it = (PathItem)element$iv$iv;
            boolean bl = false;
            PathItem pathItem = it;
            List list = pathItem != null ? pathItem.readOperations() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            scheme = list;
            boolean $i$f$flatMap3 = false;
            void $i$f$flatMap4 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo4 = false;
            for (Object element$iv$iv3 : $this$flatMapTo$iv$iv4) {
                Operation it2 = (Operation)element$iv$iv3;
                boolean bl6 = false;
                List list2 = it2.getSecurity();
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv4 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv6, (Iterable)list$iv$iv4);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv6;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv6 = new ArrayList();
        $i$f$flatMapTo3 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SecurityRequirement secReq = (SecurityRequirement)element$iv$iv;
            boolean bl = false;
            Set set4 = secReq.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"secReq.keys");
            $this$flatMap$iv = set4;
            boolean $i$f$flatMap5 = false;
            Iterable $this$flatMapTo$iv$iv4 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo5 = false;
            for (Object element$iv$iv3 : $this$flatMapTo$iv$iv4) {
                void $this$mapTo$iv$iv4;
                void $this$map$iv4;
                String group4 = (String)element$iv$iv3;
                boolean bl7 = false;
                List list = (List)secReq.get((Object)group4);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable bl4 = list;
                boolean $i$f$map = false;
                void $i$f$map3 = $this$map$iv4;
                Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                    void scope;
                    Object item$iv$iv2;
                    item$iv$iv2 = (String)item$iv$iv;
                    object = destination$iv$iv7;
                    boolean bl8 = false;
                    object.add(TuplesKt.to((Object)group4, (Object)scope));
                }
                list$iv$iv = (List)destination$iv$iv7;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv5 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv6, (Iterable)list$iv$iv5);
        }
        List usedScopes = (List)destination$iv$iv6;
        $this$flatMap$iv2 = usedScopes;
        boolean $i$f$filter2 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair list$iv$iv5 = (Pair)element$iv$iv;
            boolean bl = false;
            group = (String)list$iv$iv5.component1();
            SecurityScheme securityScheme = (SecurityScheme)specifiedSchemes.get(group);
            if (!(securityScheme != null ? OpenApiUtilKt.isOAuth2((SecurityScheme)securityScheme) : false)) continue;
            destination$iv$iv6.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv6;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (specifiedScopes.contains(it)) continue;
            destination$iv$iv6.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv6;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv6;
            boolean bl = false;
            group = (String)pair.component1();
            String scope = (String)pair.component2();
            String string = "The scope '" + group + "/" + scope + "' is not specified in security definition";
            Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"scope");
            collection.add(context.violation(string, (Object)scope));
        }
        return (List)destination$iv$iv6;
    }
}

