/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="110", severity=Severity.MUST, title="Response As JSON Object")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/zalando/zally/ruleset/zalando/SuccessResponseAsJsonObjectRule;", "", "()V", "description", "", "checkJSONObjectIsUsedAsSuccessResponseType", "", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "isSuccess", "", "codeString", "zally-ruleset-zalando"})
public final class SuccessResponseAsJsonObjectRule {
    @NotNull
    private final String description;

    public SuccessResponseAsJsonObjectRule() {
        this.description = "Always return JSON objects as top-level data structures to support extensibility";
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkJSONObjectIsUsedAsSuccessResponseType(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Schema schema;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$flatMap$iv;
        Object object;
        PathItem it;
        Iterable $this$flatMapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map map = (Map)context.getApi().getPaths();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Iterable $this$flatMap$iv2 = map.values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (PathItem)element$iv$iv;
            boolean bl = false;
            PathItem pathItem = it;
            List list = pathItem != null ? pathItem.readOperations() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            object = list;
            boolean $i$f$flatMap2 = false;
            void var13_19 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Operation it2 = (Operation)element$iv$iv2;
                boolean bl2 = false;
                Map map2 = (Map)it2.getResponses();
                if (map2 == null) {
                    map2 = MapsKt.emptyMap();
                }
                Map map3 = map2;
                boolean $i$f$filter = false;
                void var22_31 = $this$filter$iv;
                Map destination$iv$iv3 = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv3;
                    Map.Entry entry = element$iv$iv3 = iterator.next();
                    boolean bl3 = false;
                    String resCode = (String)entry.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)resCode, (String)"resCode");
                    if (!this.isSuccess(resCode)) continue;
                    destination$iv$iv3.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
                }
                Iterable list$iv$iv2 = destination$iv$iv3.values();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            it = (ApiResponse)element$iv$iv;
            boolean bl = false;
            PathItem pathItem = it;
            Map map4 = (Map)(pathItem != null ? pathItem.getContent() : null);
            if (map4 == null) {
                map4 = MapsKt.emptyMap();
            }
            $this$flatMap$iv = map4.entrySet();
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv2;
                boolean bl4 = false;
                String mediaType = (String)entry.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"mediaType");
                if (!StringsKt.contains$default((CharSequence)mediaType, (CharSequence)"json", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Schema it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            Map.Entry it3 = (Map.Entry)element$iv$iv;
            boolean bl5 = false;
            MediaType mediaType = (MediaType)it3.getValue();
            if ((mediaType != null ? mediaType.getSchema() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$filterNot = false;
        $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            schema = (Schema)element$iv$iv;
            boolean bl = false;
            object = schema.getType();
            if (object == null || object.length() == 0 || Intrinsics.areEqual((Object)"object", (Object)schema.getType())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            schema = (Schema)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(context.violation(this.description, (Object)schema));
        }
        return (List)destination$iv$iv2;
    }

    private final boolean isSuccess(String codeString) {
        IntRange intRange = new IntRange(200, 299);
        Integer n = StringsKt.toIntOrNull((String)codeString);
        return n != null && intRange.contains(n.intValue());
    }
}

