/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.fasterxml.jackson.core.JsonPointer;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="153", severity=Severity.MUST, title="Use 429 With Header For Rate Limits")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/zalando/zally/ruleset/zalando/Use429HeaderForRateLimitRule;", "", "()V", "description", "", "xRateLimitHeaders", "", "checkHeadersForRateLimiting", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "violatingResponse", "", "entry", "", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "zally-ruleset-zalando"})
public final class Use429HeaderForRateLimitRule {
    @NotNull
    private final String description;
    @NotNull
    private final List<String> xRateLimitHeaders;

    public Use429HeaderForRateLimitRule() {
        this.description = "Response has to contain rate limit information via headers";
        Object[] objectArray = new String[]{"X-RateLimit-Limit", "X-RateLimit-Remaining", "X-RateLimit-Reset"};
        this.xRateLimitHeaders = CollectionsKt.listOf((Object[])objectArray);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkHeadersForRateLimiting(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context){
            final /* synthetic */ Use429HeaderForRateLimitRule this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> entry) {
                List list;
                List list2;
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                Operation operation = entry.getValue();
                Operation operation2 = operation;
                if (operation2 != null && (operation2 = operation2.getResponses()) != null) {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    Map.Entry<K, V> element$iv$iv;
                    void $this$filterTo$iv$iv;
                    Map $this$filter$iv;
                    Operation operation3 = operation2;
                    Use429HeaderForRateLimitRule use429HeaderForRateLimitRule = this.this$0;
                    Context context = this.$context;
                    Operation responses = operation3;
                    boolean bl = false;
                    Map map = (Map)responses;
                    boolean $i$f$filter = false;
                    void var10_10 = $this$filter$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> it = element$iv$iv = iterator.next();
                        boolean bl2 = false;
                        if (!Use429HeaderForRateLimitRule.access$violatingResponse(use429HeaderForRateLimitRule, it)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    $this$filter$iv = destination$iv$iv;
                    boolean $i$f$flatMap = false;
                    $this$filterTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> entry2 = element$iv$iv = iterator.next();
                        boolean bl3 = false;
                        String status = (String)entry2.getKey();
                        String string = Use429HeaderForRateLimitRule.access$getDescription$p(use429HeaderForRateLimitRule);
                        JsonPointer jsonPointer = context.getJsonPointer((Object)responses);
                        Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                        Iterable list$iv$iv = context.violations(string, JsonPointerExtensionsKt.plus((JsonPointer)jsonPointer, (JsonPointer)JsonPointerExtensionsKt.toEscapedJsonPointer((String)status)));
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = list = null;
                }
                if (list2 == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        }), (int)3, null);
    }

    private final boolean violatingResponse(Map.Entry<String, ? extends ApiResponse> entry) {
        ApiResponse apiResponse = entry.getValue();
        Map map = apiResponse != null ? apiResponse.getHeaders() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Set headers = map.keySet();
        return Intrinsics.areEqual((Object)"429", (Object)entry.getKey()) && !headers.contains("Retry-After") && !headers.containsAll((Collection)this.xRateLimitHeaders);
    }

    public static final /* synthetic */ boolean access$violatingResponse(Use429HeaderForRateLimitRule $this, Map.Entry entry) {
        return $this.violatingResponse(entry);
    }

    public static final /* synthetic */ String access$getDescription$p(Use429HeaderForRateLimitRule $this) {
        return $this.description;
    }
}

