/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.JsonPointerExtensionsKt;
import org.zalando.zally.core.JsonSchemaValidator;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.UseProblemJsonRule;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="176", severity=Severity.MUST, title="Use Problem JSON")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/zalando/zally/ruleset/zalando/UseProblemJsonRule;", "", "()V", "description", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "problemDetailsObjectMediaType", "problemSchemaValidator", "Lorg/zalando/zally/core/JsonSchemaValidator;", "getProblemSchemaValidator", "()Lorg/zalando/zally/core/JsonSchemaValidator;", "problemSchemaValidator$delegate", "testForProblemSchema", "", "Lkotlin/Pair;", "Lorg/zalando/zally/rule/api/Violation;", "response", "Lio/swagger/v3/oas/models/responses/ApiResponse;", "isOpenAPI3", "", "validate", "context", "Lorg/zalando/zally/rule/api/Context;", "zally-ruleset-zalando"})
public final class UseProblemJsonRule {
    @NotNull
    private final String problemDetailsObjectMediaType;
    @NotNull
    private final String description;
    @NotNull
    private final Lazy objectMapper$delegate = LazyKt.lazy((Function0)objectMapper.2.INSTANCE);
    @NotNull
    private final Lazy problemSchemaValidator$delegate = LazyKt.lazy((Function0)problemSchemaValidator.2.INSTANCE);

    public UseProblemJsonRule() {
        this.problemDetailsObjectMediaType = "application/problem+json";
        this.description = "Operations should return problem JSON when any problem occurs during processing whether caused by client or server.";
    }

    private final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    private final JsonSchemaValidator getProblemSchemaValidator() {
        Lazy lazy = this.problemSchemaValidator$delegate;
        return (JsonSchemaValidator)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> validate(@NotNull Context context) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map map = (Map)context.getApi().getPaths();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map $this$flatMap$iv = map;
        boolean $i$f$flatMap = false;
        Map map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            PathItem pathItem;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            PathItem pathItem2 = pathItem = (PathItem)entry.getValue();
            List list = pathItem2 != null ? pathItem2.readOperations() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = list;
            boolean $i$f$flatMap2 = false;
            void var14_14 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$flatMapTo$iv$iv3;
                Iterable $this$flatMap$iv3;
                Pair pair;
                Pair element$iv$iv3;
                void $this$filterTo$iv$iv;
                Map $this$filter$iv;
                Operation op = (Operation)element$iv$iv2;
                boolean bl2 = false;
                Map map3 = (Map)op.getResponses();
                if (map3 == null) {
                    map3 = MapsKt.emptyMap();
                }
                Map map4 = map3;
                boolean $i$f$filter = false;
                void var23_23 = $this$filter$iv;
                Object destination$iv$iv3 = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    pair = element$iv$iv3 = iterator2.next();
                    boolean bl3 = false;
                    String code = (String)pair.getKey();
                    IntRange intRange = new IntRange(400, 599);
                    Intrinsics.checkNotNullExpressionValue((Object)code, (String)"code");
                    Integer n = StringsKt.toIntOrNull((String)code);
                    if (!(n != null && intRange.contains(n.intValue()) || Intrinsics.areEqual((Object)code, (Object)"default"))) continue;
                    destination$iv$iv3.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
                }
                $this$filter$iv = destination$iv$iv3;
                boolean $i$f$flatMap3 = false;
                $this$filterTo$iv$iv = $this$flatMap$iv3;
                destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo3 = false;
                iterator2 = $this$flatMapTo$iv$iv3.entrySet().iterator();
                while (iterator2.hasNext()) {
                    pair = element$iv$iv3 = iterator2.next();
                    boolean bl4 = false;
                    ApiResponse response = (ApiResponse)pair.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    Iterable list$iv$iv = this.testForProblemSchema(response, context.isOpenAPI3());
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv3 = (List)destination$iv$iv3;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv3 = $this$map$iv;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                    pair = (Pair)item$iv$iv;
                    Object object = destination$iv$iv3;
                    boolean bl5 = false;
                    Object schema = pair.component1();
                    Violation validation = (Violation)pair.component2();
                    Violation it = context.violation(this.description, schema);
                    boolean bl6 = false;
                    object.add(new Violation(it.getDescription() + " " + validation.getDescription(), JsonPointerExtensionsKt.plus((JsonPointer)it.getPointer(), (JsonPointer)validation.getPointer())));
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Object, Violation>> testForProblemSchema(ApiResponse response, boolean isOpenAPI3) {
        List list;
        Content content = response.getContent();
        if (content != null) {
            void $this$flatMapTo$iv$iv;
            Map $this$flatMap$iv = (Map)content;
            boolean $i$f$flatMap = false;
            Map map = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                String type = (String)entry.getKey();
                MediaType mediaType = (MediaType)entry.getValue();
                if (isOpenAPI3) {
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
                    if (!StringsKt.startsWith$default((String)type, (String)this.problemDetailsObjectMediaType, (boolean)false, (int)2, null)) {
                        Violation message = new Violation("Media type have to be 'application/problem+json'", JsonPointerExtensionsKt.getEMPTY_JSON_POINTER());
                        return CollectionsKt.listOf((Object)new Pair((Object)mediaType, (Object)message));
                    }
                }
                JsonNode node = (JsonNode)this.getObjectMapper().convertValue((Object)mediaType.getSchema(), JsonNode.class);
                JsonSchemaValidator jsonSchemaValidator = this.getProblemSchemaValidator();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                List result = jsonSchemaValidator.validate(node);
                Iterable $this$map$iv = result;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Violation violation = (Violation)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(new Pair((Object)mediaType.getSchema(), (Object)it));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

