/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zally.ruleset.zalando;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;
import org.zalando.zally.ruleset.zalando.UseStandardHttpStatusCodesRule;
import org.zalando.zally.ruleset.zalando.ZalandoRuleSet;

@Rule(ruleSet=ZalandoRuleSet.class, id="150", severity=Severity.MUST, title="Use Standard HTTP Status Codes")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R2\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u001c\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/zalando/zally/ruleset/zalando/UseStandardHttpStatusCodesRule;", "", "rulesConfig", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "standardResponseCodes", "", "", "kotlin.jvm.PlatformType", "", "wellUnderstoodResponseCode", "", "wellUnderstoodResponseCodesAndVerbs", "", "checkIfOnlyStandardizedResponseCodesAreUsed", "Lorg/zalando/zally/rule/api/Violation;", "context", "Lorg/zalando/zally/rule/api/Context;", "checkIfOnlyWellUnderstoodResponseCodesAreUsed", "checkThatNoContentResponseHasNoContentDefined", "checkWellUnderstoodResponseCodesUsage", "isAllowed", "", "method", "Lio/swagger/v3/oas/models/PathItem$HttpMethod;", "statusCode", "Messages", "zally-ruleset-zalando"})
public final class UseStandardHttpStatusCodesRule {
    @NotNull
    public static final Messages Messages = new Messages(null);
    @NotNull
    private final Map<String, List<String>> wellUnderstoodResponseCodesAndVerbs;
    @NotNull
    private final Set<String> wellUnderstoodResponseCode;
    private final List<String> standardResponseCodes;

    /*
     * WARNING - void declaration
     */
    public UseStandardHttpStatusCodesRule(@NotNull Config rulesConfig) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rulesConfig, (String)"rulesConfig");
        Set set = rulesConfig.getConfig(this.getClass().getSimpleName() + ".well_understood").entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"rulesConfig\n        .get\u2026ood\")\n        .entrySet()");
        Iterable iterable = set;
        UseStandardHttpStatusCodesRule useStandardHttpStatusCodesRule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, config)");
            String key = (String)entry.getKey();
            ConfigValue config = (ConfigValue)entry.getValue();
            Object object = config.unwrapped();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            }
            collection.add(TuplesKt.to((Object)key, (Object)((List)object)));
        }
        useStandardHttpStatusCodesRule.wellUnderstoodResponseCodesAndVerbs = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.wellUnderstoodResponseCode = this.wellUnderstoodResponseCodesAndVerbs.keySet();
        this.standardResponseCodes = rulesConfig.getStringList(this.getClass().getSimpleName() + ".standard");
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkWellUnderstoodResponseCodesUsage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validatePaths$default((Context)context, null, (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends PathItem>, List<? extends Violation>>(this, context){
            final /* synthetic */ UseStandardHttpStatusCodesRule this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<String, ? extends PathItem> entry) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                PathItem pathItem;
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                String pathName = entry.getKey();
                PathItem pathItem2 = pathItem = entry.getValue();
                Map<K, V> map = pathItem2 != null ? pathItem2.readOperationsMap() : null;
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                Map<K, V> map2 = map;
                UseStandardHttpStatusCodesRule useStandardHttpStatusCodesRule = this.this$0;
                Context context = this.$context;
                boolean $i$f$flatMap = false;
                void var8_8 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Map $this$filterKeys$iv;
                    Operation operation;
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> entry2 = element$iv$iv = iterator.next();
                    boolean bl = false;
                    PathItem.HttpMethod method = (PathItem.HttpMethod)entry2.getKey();
                    Operation operation2 = operation = (Operation)entry2.getValue();
                    Map map3 = (Map)(operation2 != null ? operation2.getResponses() : null);
                    if (map3 == null) {
                        map3 = MapsKt.emptyMap();
                    }
                    Map map4 = map3;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String status = (String)entry$iv.getKey();
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                        Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                        if (!(!UseStandardHttpStatusCodesRule.access$isAllowed(useStandardHttpStatusCodesRule, method, status))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    $this$filterKeys$iv = result$iv;
                    boolean $i$f$map = false;
                    result$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator<Map.Entry<K, V>> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> item$iv$iv;
                        Map.Entry<K, V> entry3 = item$iv$iv = iterator2.next();
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        String status = (String)entry3.getKey();
                        ApiResponse response = (ApiResponse)entry3.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                        String string = UseStandardHttpStatusCodesRule.Messages.wellUnderstoodViolationMessage(pathName, status, method.name());
                        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                        collection.add(context.violation(string, (Object)response));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }), (int)1, null);
    }

    @Check(severity=Severity.MUST)
    @NotNull
    public final List<Violation> checkIfOnlyStandardizedResponseCodesAreUsed(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context){
            final /* synthetic */ UseStandardHttpStatusCodesRule this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> entry) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map $this$filterKeys$iv;
                Operation operation;
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                Operation operation2 = operation = entry.getValue();
                Map map = (Map)(operation2 != null ? operation2.getResponses() : null);
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                Map map2 = map;
                UseStandardHttpStatusCodesRule useStandardHttpStatusCodesRule = this.this$0;
                boolean $i$f$filterKeys = false;
                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                    String status = (String)entry$iv.getKey();
                    boolean bl = false;
                    if (!(!UseStandardHttpStatusCodesRule.access$getStandardResponseCodes$p(useStandardHttpStatusCodesRule).contains(status))) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                $this$filterKeys$iv = result$iv;
                useStandardHttpStatusCodesRule = this.$context;
                boolean $i$f$map = false;
                result$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry2 = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String status = (String)entry2.getKey();
                    ApiResponse response = (ApiResponse)entry2.getValue();
                    String string = status + " is not a standardized response code";
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    collection.add(useStandardHttpStatusCodesRule.violation(string, response));
                }
                return (List)destination$iv$iv;
            }
        }), (int)3, null);
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkIfOnlyWellUnderstoodResponseCodesAreUsed(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateOperations$default((Context)context, null, null, (Function1)((Function1)new Function1<Map.Entry<? extends PathItem.HttpMethod, ? extends Operation>, List<? extends Violation>>(this, context){
            final /* synthetic */ UseStandardHttpStatusCodesRule this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<? extends PathItem.HttpMethod, ? extends Operation> entry) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map $this$filterKeys$iv;
                Operation operation;
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                Operation operation2 = operation = entry.getValue();
                Map map = (Map)(operation2 != null ? operation2.getResponses() : null);
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                Map map2 = map;
                UseStandardHttpStatusCodesRule useStandardHttpStatusCodesRule = this.this$0;
                boolean $i$f$filterKeys = false;
                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                    String status = (String)entry$iv.getKey();
                    boolean bl = false;
                    if (!(!UseStandardHttpStatusCodesRule.access$getWellUnderstoodResponseCode$p(useStandardHttpStatusCodesRule).contains(status))) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                $this$filterKeys$iv = result$iv;
                useStandardHttpStatusCodesRule = this.$context;
                boolean $i$f$map = false;
                result$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry2 = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String status = (String)entry2.getKey();
                    ApiResponse response = (ApiResponse)entry2.getValue();
                    String string = status + " is not a well-understood response code";
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    collection.add(useStandardHttpStatusCodesRule.violation(string, response));
                }
                return (List)destination$iv$iv;
            }
        }), (int)3, null);
    }

    @Check(severity=Severity.SHOULD)
    @NotNull
    public final List<Violation> checkThatNoContentResponseHasNoContentDefined(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Context.DefaultImpls.validateResponses$default((Context)context, null, (Function1)checkThatNoContentResponseHasNoContentDefined.1.INSTANCE, (Function1)checkThatNoContentResponseHasNoContentDefined.2.INSTANCE, (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends ApiResponse>, List<? extends Violation>>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final List<Violation> invoke(@NotNull Map.Entry<String, ? extends ApiResponse> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                String key = entry.getKey();
                ApiResponse response = entry.getValue();
                return response == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.$context.violation(UseStandardHttpStatusCodesRule.Messages.noContentViolationMessage(key), (Object)response));
            }
        }), (int)1, null);
    }

    private final boolean isAllowed(PathItem.HttpMethod method, String statusCode) {
        List allowedMethods;
        String string = statusCode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        List list = this.wellUnderstoodResponseCodesAndVerbs.get(string);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return (allowedMethods = list).contains(method.name()) || allowedMethods.contains("ALL");
    }

    public static final /* synthetic */ boolean access$isAllowed(UseStandardHttpStatusCodesRule $this, PathItem.HttpMethod method, String statusCode) {
        return $this.isAllowed(method, statusCode);
    }

    public static final /* synthetic */ List access$getStandardResponseCodes$p(UseStandardHttpStatusCodesRule $this) {
        return $this.standardResponseCodes;
    }

    public static final /* synthetic */ Set access$getWellUnderstoodResponseCode$p(UseStandardHttpStatusCodesRule $this) {
        return $this.wellUnderstoodResponseCode;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u001e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lorg/zalando/zally/ruleset/zalando/UseStandardHttpStatusCodesRule$Messages;", "", "()V", "noContentViolationMessage", "", "statusCode", "wellUnderstoodViolationMessage", "path", "status", "method", "zally-ruleset-zalando"})
    public static final class Messages {
        private Messages() {
        }

        @NotNull
        public final String wellUnderstoodViolationMessage(@NotNull String path, @NotNull String status, @NotNull String method) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            return "Path " + path + " should not use " + status + " status code for " + method + " operation";
        }

        @NotNull
        public final String noContentViolationMessage(@NotNull String statusCode) {
            Intrinsics.checkNotNullParameter((Object)statusCode, (String)"statusCode");
            return statusCode + " response should have no payload defined";
        }

        public /* synthetic */ Messages(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

