/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import org.fedorahosted.openprops.Properties;
import org.zanata.common.ContentState;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.ExtensionValue;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PropReader {
    private static final String ISO_8859_1 = "ISO-8859-1";
    public static final String PROP_CONTENT_TYPE = "text/plain";
    private static final String NEWLINE_REGEX = "(\r\n|\r|\n)";
    private final String charset;
    private final LocaleId sourceLocale;
    private final ContentState contentState;

    public PropReader(String charset, LocaleId sourceLocale, ContentState contentState) {
        this.charset = charset;
        this.sourceLocale = sourceLocale;
        this.contentState = contentState;
    }

    public PropReader() {
        this(ISO_8859_1, LocaleId.EN_US, ContentState.Approved);
    }

    public void extractTarget(TranslationsResource doc, InputStream in) throws IOException, RuntimeException {
        Properties props = this.loadProps(in);
        for (String key : props.keySet()) {
            this.addPropEntryToDoc(doc, props, key, this.contentState);
        }
    }

    private void addPropEntryToDoc(TranslationsResource doc, Properties props, String key, ContentState contentState) {
        String content = props.getProperty(key);
        if (content == null) {
            return;
        }
        TextFlowTarget textFlowTarget = new TextFlowTarget(key);
        textFlowTarget.setContents(new String[]{content});
        if (!content.isEmpty()) {
            textFlowTarget.setState(contentState);
        } else {
            textFlowTarget.setState(ContentState.New);
        }
        String comment = props.getComment(key);
        if (comment != null && comment.length() != 0) {
            SimpleComment simpleComment = new SimpleComment(comment);
            textFlowTarget.getExtensions(true).add((ExtensionValue)simpleComment);
        }
        doc.getTextFlowTargets().add(textFlowTarget);
    }

    public void extractTemplate(Resource doc, InputStream in) throws IOException, RuntimeException {
        List resources = doc.getTextFlows();
        Properties props = this.loadProps(in);
        int nonTranslatableCount = 0;
        for (String key : props.stringPropertyNames()) {
            String comment = null;
            String rawComment = props.getRawComment(key);
            if (rawComment != null && rawComment.length() != 0) {
                StringBuilder sb = new StringBuilder(rawComment.length());
                nonTranslatableCount = this.processCommentForNonTranslatable(nonTranslatableCount, rawComment, sb);
                comment = sb.toString();
            }
            if (nonTranslatableCount != 0) continue;
            String content = props.getProperty(key);
            String id = this.getID(key, content);
            TextFlow textFlow = new TextFlow(id, this.sourceLocale, new String[]{content});
            if (comment != null && comment.length() != 0) {
                SimpleComment simpleComment = new SimpleComment(comment);
                textFlow.getExtensions(true).add((ExtensionValue)simpleComment);
            }
            resources.add(textFlow);
        }
    }

    private int processCommentForNonTranslatable(int nonTranslatableCount, String comment, StringBuilder sb) throws InvalidPropertiesFormatException {
        String[] lines;
        int nonTranslatable = nonTranslatableCount;
        for (String line : lines = comment.split(NEWLINE_REGEX)) {
            int lineNonTranslatable = this.checkNonTranslatable(line);
            if ((nonTranslatable += lineNonTranslatable) < 0) {
                throw new InvalidPropertiesFormatException("Found '# END NON-TRANSLATABLE' without matching '# START NON-TRANSLATABLE'");
            }
            if (nonTranslatable != 0 || lineNonTranslatable != 0) continue;
            sb.append(Properties.cookCommentLine((String)line));
            sb.append('\n');
        }
        return nonTranslatable;
    }

    private int checkNonTranslatable(String line) {
        if (line.startsWith("# START NON-TRANSLATABLE")) {
            return 1;
        }
        if (line.startsWith("# END NON-TRANSLATABLE")) {
            return -1;
        }
        return 0;
    }

    private String getID(String key, String val) throws RuntimeException {
        if (key.length() > 255) {
            throw new RuntimeException("Zanata does not support property keys exceeding 255 characters");
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProps(InputStream in) throws IOException, RuntimeException {
        InputStreamReader reader = new InputStreamReader(in, this.charset);
        try {
            Properties props = new Properties();
            props.load((Reader)reader);
            Properties properties = props;
            return properties;
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

