/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.properties;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.fedorahosted.openprops.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.common.ContentState;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PropWriter {
    private static final Logger log = LoggerFactory.getLogger(PropWriter.class);

    private static void makeParentDirs(File f) {
        File parentFile = f.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
    }

    public static void write(Resource doc, File baseDir) throws IOException {
        PropWriter.write(doc, baseDir, false);
    }

    public static void writeUTF8(Resource doc, File baseDir) throws IOException {
        PropWriter.write(doc, baseDir, true);
    }

    private static void write(Resource doc, File baseDir, boolean utf8) throws IOException {
        File baseFile = new File(baseDir, doc.getName() + ".properties");
        PropWriter.makeParentDirs(baseFile);
        log.debug("Creating base file " + baseFile);
        Properties props = new Properties();
        for (TextFlow textFlow : doc.getTextFlows()) {
            List contents = textFlow.getContents();
            if (contents.size() != 1) {
                throw new RuntimeException("file format does not support plural forms: resId=" + textFlow.getId());
            }
            props.setProperty(textFlow.getId(), (String)textFlow.getContents().get(0));
            SimpleComment simpleComment = (SimpleComment)textFlow.getExtensions(true).findByType(SimpleComment.class);
            if (simpleComment == null || simpleComment.getValue() == null) continue;
            props.setComment(textFlow.getId(), simpleComment.getValue());
        }
        PropWriter.storeProps(props, baseFile, utf8);
    }

    public static void write(Resource srcDoc, TranslationsResource doc, File baseDir, String bundleName, String locale, boolean createSkeletons) throws IOException {
        PropWriter.write(srcDoc, doc, baseDir, bundleName, locale, false, createSkeletons);
    }

    public static void writeUTF8(Resource srcDoc, TranslationsResource doc, File baseDir, String bundleName, String locale, boolean createSkeletons) throws IOException {
        PropWriter.write(srcDoc, doc, baseDir, bundleName, locale, true, createSkeletons);
    }

    private static void write(Resource srcDoc, TranslationsResource doc, File baseDir, String bundleName, String locale, boolean utf8, boolean createSkeletons) throws IOException {
        Properties targetProp = new Properties();
        if (srcDoc == null) {
            for (TextFlowTarget target : doc.getTextFlowTargets()) {
                PropWriter.textFlowTargetToProperty(target.getResId(), target, targetProp, createSkeletons);
            }
        } else {
            HashMap<String, TextFlowTarget> targets = new HashMap<String, TextFlowTarget>();
            if (doc != null) {
                for (TextFlowTarget target : doc.getTextFlowTargets()) {
                    targets.put(target.getResId(), target);
                }
            }
            for (TextFlow textFlow : srcDoc.getTextFlows()) {
                TextFlowTarget target = (TextFlowTarget)targets.get(textFlow.getId());
                PropWriter.textFlowTargetToProperty(textFlow.getId(), target, targetProp, createSkeletons);
            }
        }
        File langFile = new File(baseDir, bundleName + "_" + locale + ".properties");
        PropWriter.makeParentDirs(langFile);
        log.debug("Creating target file " + langFile);
        PropWriter.storeProps(targetProp, langFile, utf8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProps(Properties props, File file, boolean utf8) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            if (utf8) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                props.store((Writer)writer, null);
            } else {
                props.store((OutputStream)out, null);
            }
        }
        finally {
            out.close();
        }
    }

    private static void textFlowTargetToProperty(String resId, TextFlowTarget target, Properties targetProp, boolean createSkeletons) {
        if (target == null || target.getState() != ContentState.Approved || target.getContents() == null || target.getContents().size() == 0) {
            if (createSkeletons) {
                targetProp.setProperty(resId, "");
            }
            return;
        }
        List contents = target.getContents();
        if (contents.size() != 1) {
            throw new RuntimeException("file format does not support plural forms: resId=" + resId);
        }
        targetProp.setProperty(target.getResId(), (String)contents.get(0));
        SimpleComment simpleComment = (SimpleComment)target.getExtensions(true).findByType(SimpleComment.class);
        if (simpleComment != null && simpleComment.getValue() != null) {
            targetProp.setComment(target.getResId(), simpleComment.getValue());
        }
    }
}

