/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.zanata:zanata-maven-plugin:3.9.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Zanata Maven Plugin", 0);
        this.append(sb, "Zanata client for managing projects, publishing source text and retrieving translations.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 13 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "glossary-delete".equals(this.goal)) {
            this.append(sb, "zanata:glossary-delete", 0);
            this.append(sb, "Delete glossary entry from Zanata.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allGlossary (Default: false)", 2);
                this.append(sb, "Delete entire glossaries", 3);
                this.append(sb, "Expression: ${zanata.allGlossary}", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Wildcard pattern to exclude files and directories. Usage -Dzanata.excludes='Pattern1,Pattern2,Pattern3'", 3);
                this.append(sb, "Expression: ${zanata.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "id", 2);
                this.append(sb, "id of glossary to delete", 3);
                this.append(sb, "Expression: ${zanata.id}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Wildcard pattern to include files and directories. This parameter is only needed for some project types, eg XLIFF, Properties. Usage -Dzanata.includes='src/myfile*.xml,**/*.xliff.xml'", 3);
                this.append(sb, "Expression: ${zanata.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Project slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectConfig (Default: ${basedir}/zanata.xml)", 2);
                this.append(sb, "Zanata project configuration file.", 3);
                this.append(sb, "Expression: ${zanata.projectConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Type of project ( 'properties' = Java .properties, 'podir' = publican-style gettext directories, 'utf8properties' = UTF-8 .properties files, 'gettext' = gettext PO files, 'file' = EXPERIMENTAL document files of various types). If 'file' is used, transDir must not be the same as or nested within srcDir, and vice versa.", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectVersion", 2);
                this.append(sb, "Project version slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.projectVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir", 2);
                this.append(sb, "Base directory for source-language files", 3);
                this.append(sb, "Expression: ${zanata.srcDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transDir", 2);
                this.append(sb, "Base directory for target-language files (translations)", 3);
                this.append(sb, "Expression: ${zanata.transDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "glossary-push".equals(this.goal)) {
            this.append(sb, "zanata:glossary-push", 0);
            this.append(sb, "Pushes glossary file into Zanata.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "batchSize (Default: 50)", 2);
                this.append(sb, "Batch size for large glossary file", 3);
                this.append(sb, "Expression: ${zanata.batchSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Wildcard pattern to exclude files and directories. Usage -Dzanata.excludes='Pattern1,Pattern2,Pattern3'", 3);
                this.append(sb, "Expression: ${zanata.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "glossaryFile", 2);
                this.append(sb, "Location path for the glossary file", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.glossaryFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Wildcard pattern to include files and directories. This parameter is only needed for some project types, eg XLIFF, Properties. Usage -Dzanata.includes='src/myfile*.xml,**/*.xliff.xml'", 3);
                this.append(sb, "Expression: ${zanata.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Project slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectConfig (Default: ${basedir}/zanata.xml)", 2);
                this.append(sb, "Zanata project configuration file.", 3);
                this.append(sb, "Expression: ${zanata.projectConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Type of project ( 'properties' = Java .properties, 'podir' = publican-style gettext directories, 'utf8properties' = UTF-8 .properties files, 'gettext' = gettext PO files, 'file' = EXPERIMENTAL document files of various types). If 'file' is used, transDir must not be the same as or nested within srcDir, and vice versa.", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectVersion", 2);
                this.append(sb, "Project version slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.projectVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceLang (Default: en-US)", 2);
                this.append(sb, "Source language of document", 3);
                this.append(sb, "Expression: ${zanata.sourceLang}", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir", 2);
                this.append(sb, "Base directory for source-language files", 3);
                this.append(sb, "Expression: ${zanata.srcDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transDir", 2);
                this.append(sb, "Base directory for target-language files (translations)", 3);
                this.append(sb, "Expression: ${zanata.transDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transLang", 2);
                this.append(sb, "Translation language of document. Not required for csv file", 3);
                this.append(sb, "Expression: ${zanata.transLang}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "zanata:help", 0);
            this.append(sb, "Display help information on zanata-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0zanata:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "init".equals(this.goal)) {
            this.append(sb, "zanata:init", 0);
            this.append(sb, "Initialize Zanata project configuration.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Wildcard pattern to exclude files and directories. Usage -Dzanata.excludes='Pattern1,Pattern2,Pattern3'", 3);
                this.append(sb, "Expression: ${zanata.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Wildcard pattern to include files and directories. This parameter is only needed for some project types, eg XLIFF, Properties. Usage -Dzanata.includes='src/myfile*.xml,**/*.xliff.xml'", 3);
                this.append(sb, "Expression: ${zanata.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Project slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectConfig (Default: ${basedir}/zanata.xml)", 2);
                this.append(sb, "Zanata project configuration file.", 3);
                this.append(sb, "Expression: ${zanata.projectConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Type of project ( 'properties' = Java .properties, 'podir' = publican-style gettext directories, 'utf8properties' = UTF-8 .properties files, 'gettext' = gettext PO files, 'file' = EXPERIMENTAL document files of various types). If 'file' is used, transDir must not be the same as or nested within srcDir, and vice versa.", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectVersion", 2);
                this.append(sb, "Project version slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.projectVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir", 2);
                this.append(sb, "Base directory for source-language files", 3);
                this.append(sb, "Expression: ${zanata.srcDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transDir", 2);
                this.append(sb, "Base directory for target-language files (translations)", 3);
                this.append(sb, "Expression: ${zanata.transDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "list-remote".equals(this.goal)) {
            this.append(sb, "zanata:list-remote", 0);
            this.append(sb, "Lists all remote documents in the configured Zanata project version.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Wildcard pattern to exclude files and directories. Usage -Dzanata.excludes='Pattern1,Pattern2,Pattern3'", 3);
                this.append(sb, "Expression: ${zanata.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Wildcard pattern to include files and directories. This parameter is only needed for some project types, eg XLIFF, Properties. Usage -Dzanata.includes='src/myfile*.xml,**/*.xliff.xml'", 3);
                this.append(sb, "Expression: ${zanata.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Project slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectConfig (Default: ${basedir}/zanata.xml)", 2);
                this.append(sb, "Zanata project configuration file.", 3);
                this.append(sb, "Expression: ${zanata.projectConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Type of project ( 'properties' = Java .properties, 'podir' = publican-style gettext directories, 'utf8properties' = UTF-8 .properties files, 'gettext' = gettext PO files, 'file' = EXPERIMENTAL document files of various types). If 'file' is used, transDir must not be the same as or nested within srcDir, and vice versa.", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectVersion", 2);
                this.append(sb, "Project version slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.projectVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir", 2);
                this.append(sb, "Base directory for source-language files", 3);
                this.append(sb, "Expression: ${zanata.srcDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transDir", 2);
                this.append(sb, "Base directory for target-language files (translations)", 3);
                this.append(sb, "Expression: ${zanata.transDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "pull".equals(this.goal)) {
            this.append(sb, "zanata:pull", 0);
            this.append(sb, "Pulls translated text from Zanata.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "continueAfterError (Default: false)", 2);
                this.append(sb, "When there is an error, whether try to workaround it and continue to next text flow or fail the process. i.e. when encounter a mismatch plural form, it will try to use singular form. Note: This option may not work on all circumstances.", 3);
                this.append(sb, "Expression: ${zanata.continueAfterError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "createSkeletons", 2);
                this.append(sb, "Whether to create skeleton entries for strings/files which have not been translated yet", 3);
                this.append(sb, "Expression: ${zanata.createSkeletons}", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun", 2);
                this.append(sb, "Dry run: don't change any data, on the server or on the filesystem.", 3);
                this.append(sb, "Expression: ${dryRun}", 3);
                this.append(sb, "", 0);
                this.append(sb, "enableModules", 2);
                this.append(sb, "Whether module processing should be enabled. This option is obsolete. Please use pull-module instead.", 3);
                this.append(sb, "Expression: ${zanata.enableModules}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encodeTabs (Default: true)", 2);
                this.append(sb, "Whether tabs should be encoded as \\t (true) or left as tabs (false).", 3);
                this.append(sb, "Expression: ${zanata.encodeTabs}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Wildcard pattern to exclude files and directories. Usage -Dzanata.excludes='Pattern1,Pattern2,Pattern3'", 3);
                this.append(sb, "Expression: ${zanata.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fromDoc", 2);
                this.append(sb, "Specifies a document from which to begin the push operation. Documents before this document (sorted alphabetically) will not be pushed. For multi-module projects, the full document path including module id is required. Use this option to resume a failed push operation.", 3);
                this.append(sb, "Expression: ${zanata.fromDoc}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeFuzzy (Default: false)", 2);
                this.append(sb, "Whether to include fuzzy translations in translation files when using project type 'file'. If this option is false, source text will be used for any string that does not have an approved translation.", 3);
                this.append(sb, "Expression: ${zanata.includeFuzzy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Wildcard pattern to include files and directories. This parameter is only needed for some project types, eg XLIFF, Properties. Usage -Dzanata.includes='src/myfile*.xml,**/*.xliff.xml'", 3);
                this.append(sb, "Expression: ${zanata.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "Locales to push to/pull from the server. By default all locales configured for the project will be pushed/pulled. Usage: -Dzanata.locales=locale1,locale2,locale3", 3);
                this.append(sb, "Expression: ${zanata.locales}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "minDocPercent (Default: 0)", 2);
                this.append(sb, "Accepts integer from 0 to 100. Only pull translation documents which are at least PERCENT % (message based) completed. Please note specifying this option may cause longer time to pull for a large project.", 3);
                this.append(sb, "Expression: ${zanata.minDocPercent}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectConfig (Default: ${basedir}/zanata.xml)", 2);
                this.append(sb, "Zanata project configuration file.", 3);
                this.append(sb, "Expression: ${zanata.projectConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Type of project ( 'properties' = Java .properties, 'podir' = publican-style gettext directories, 'utf8properties' = UTF-8 .properties files, 'gettext' = gettext PO files, 'file' = EXPERIMENTAL document files of various types). If 'file' is used, transDir must not be the same as or nested within srcDir, and vice versa.", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectVersion", 2);
                this.append(sb, "Project version slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.projectVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pullSrc", 2);
                this.append(sb, "Export source-language text from Zanata to local files, overwriting or erasing existing files (DANGER!). This option is deprecated, replaced by pullType.", 3);
                this.append(sb, "Expression: ${zanata.pullSrc}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pullType (Default: trans)", 2);
                this.append(sb, "Type of pull to perform from the server: 'source' pulls source documents only. 'trans' pulls translation documents only. 'both' pulls both source and translation documents.", 3);
                this.append(sb, "Expression: ${zanata.pullType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "purgeCache (Default: false)", 2);
                this.append(sb, "Whether to purge the cache before performing the pull operation. This means that all documents will be fetched from the server anew.", 3);
                this.append(sb, "Expression: ${zanata.purgeCache}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${zanata.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir", 2);
                this.append(sb, "Base directory for source-language files", 3);
                this.append(sb, "Expression: ${zanata.srcDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transDir", 2);
                this.append(sb, "Base directory for target-language files (translations)", 3);
                this.append(sb, "Expression: ${zanata.transDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useCache (Default: true)", 2);
                this.append(sb, "Whether to use an Entity cache when fetching documents. When using the cache, documents that have been retrieved previously and have not changed since then will not be retrieved again.", 3);
                this.append(sb, "Expression: ${zanata.useCache}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "pull-module".equals(this.goal)) {
            this.append(sb, "zanata:pull-module", 0);
            this.append(sb, "Pulls translated text from Zanata.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "continueAfterError (Default: false)", 2);
                this.append(sb, "When there is an error, whether try to workaround it and continue to next text flow or fail the process. i.e. when encounter a mismatch plural form, it will try to use singular form. Note: This option may not work on all circumstances.", 3);
                this.append(sb, "Expression: ${zanata.continueAfterError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "createSkeletons", 2);
                this.append(sb, "Whether to create skeleton entries for strings/files which have not been translated yet", 3);
                this.append(sb, "Expression: ${zanata.createSkeletons}", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun", 2);
                this.append(sb, "Dry run: don't change any data, on the server or on the filesystem.", 3);
                this.append(sb, "Expression: ${dryRun}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encodeTabs (Default: true)", 2);
                this.append(sb, "Whether tabs should be encoded as \\t (true) or left as tabs (false).", 3);
                this.append(sb, "Expression: ${zanata.encodeTabs}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Wildcard pattern to exclude files and directories. Usage -Dzanata.excludes='Pattern1,Pattern2,Pattern3'", 3);
                this.append(sb, "Expression: ${zanata.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fromDoc", 2);
                this.append(sb, "Specifies a document from which to begin the push operation. Documents before this document (sorted alphabetically) will not be pushed. For multi-module projects, the full document path including module id is required. Use this option to resume a failed push operation.", 3);
                this.append(sb, "Expression: ${zanata.fromDoc}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeFuzzy (Default: false)", 2);
                this.append(sb, "Whether to include fuzzy translations in translation files when using project type 'file'. If this option is false, source text will be used for any string that does not have an approved translation.", 3);
                this.append(sb, "Expression: ${zanata.includeFuzzy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Wildcard pattern to include files and directories. This parameter is only needed for some project types, eg XLIFF, Properties. Usage -Dzanata.includes='src/myfile*.xml,**/*.xliff.xml'", 3);
                this.append(sb, "Expression: ${zanata.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "Locales to push to/pull from the server. By default all locales configured for the project will be pushed/pulled. Usage: -Dzanata.locales=locale1,locale2,locale3", 3);
                this.append(sb, "Expression: ${zanata.locales}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "minDocPercent (Default: 0)", 2);
                this.append(sb, "Accepts integer from 0 to 100. Only pull translation documents which are at least PERCENT % (message based) completed. Please note specifying this option may cause longer time to pull for a large project.", 3);
                this.append(sb, "Expression: ${zanata.minDocPercent}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectConfig (Default: ${basedir}/zanata.xml)", 2);
                this.append(sb, "Zanata project configuration file.", 3);
                this.append(sb, "Expression: ${zanata.projectConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Type of project ( 'properties' = Java .properties, 'podir' = publican-style gettext directories, 'utf8properties' = UTF-8 .properties files, 'gettext' = gettext PO files, 'file' = EXPERIMENTAL document files of various types). If 'file' is used, transDir must not be the same as or nested within srcDir, and vice versa.", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectVersion", 2);
                this.append(sb, "Project version slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.projectVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pullSrc", 2);
                this.append(sb, "Export source-language text from Zanata to local files, overwriting or erasing existing files (DANGER!). This option is deprecated, replaced by pullType.", 3);
                this.append(sb, "Expression: ${zanata.pullSrc}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pullType (Default: trans)", 2);
                this.append(sb, "Type of pull to perform from the server: 'source' pulls source documents only. 'trans' pulls translation documents only. 'both' pulls both source and translation documents.", 3);
                this.append(sb, "Expression: ${zanata.pullType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "purgeCache (Default: false)", 2);
                this.append(sb, "Whether to purge the cache before performing the pull operation. This means that all documents will be fetched from the server anew.", 3);
                this.append(sb, "Expression: ${zanata.purgeCache}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${zanata.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir", 2);
                this.append(sb, "Base directory for source-language files", 3);
                this.append(sb, "Expression: ${zanata.srcDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transDir", 2);
                this.append(sb, "Base directory for target-language files (translations)", 3);
                this.append(sb, "Expression: ${zanata.transDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useCache (Default: true)", 2);
                this.append(sb, "Whether to use an Entity cache when fetching documents. When using the cache, documents that have been retrieved previously and have not changed since then will not be retrieved again.", 3);
                this.append(sb, "Expression: ${zanata.useCache}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "push".equals(this.goal)) {
            this.append(sb, "zanata:push", 0);
            this.append(sb, "Pushes source text to a Zanata project version so that it can be translated, and optionally push translated text as well. NB: Any documents which exist on the server but not locally will be deleted as obsolete.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "caseSensitive (Default: true)", 2);
                this.append(sb, "Case sensitive for includes and excludes options.", 3);
                this.append(sb, "Expression: ${zanata.caseSensitive}", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyTrans (Default: false)", 2);
                this.append(sb, "Whether the server should copy latest translations from equivalent messages/documents in the database", 3);
                this.append(sb, "Expression: ${zanata.copyTrans}", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultExcludes (Default: true)", 2);
                this.append(sb, "Add default excludes (.svn, .git, etc) to the exclude filters.", 3);
                this.append(sb, "Expression: ${zanata.defaultExcludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun", 2);
                this.append(sb, "Dry run: don't change any data, on the server or on the filesystem.", 3);
                this.append(sb, "Expression: ${dryRun}", 3);
                this.append(sb, "", 0);
                this.append(sb, "enableModules", 2);
                this.append(sb, "Whether module processing should be enabled. This option is obsolete. Please use push-module instead.", 3);
                this.append(sb, "Expression: ${zanata.enableModules}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeLocaleFilenames (Default: true)", 2);
                this.append(sb, "Exclude filenames which match locales configured for the project (other than the source locale). For instance, if project includes de and fr, then the files messages_de.properties and messages_fr.properties will not be treated as source files.\nNB: This parameter will be ignored for some project types which use different file naming conventions (eg podir, gettext).\n", 3);
                this.append(sb, "Expression: ${zanata.excludeLocaleFilenames}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Wildcard pattern to exclude files and directories. Usage -Dzanata.excludes='Pattern1,Pattern2,Pattern3'", 3);
                this.append(sb, "Expression: ${zanata.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileTypes (Default: txt,dtd,odt,fodt,odp,fodp,ods,fods,odg,fodg,odf,odb)", 2);
                this.append(sb, "File types to locate and transmit to the server when using project type 'file'.", 3);
                this.append(sb, "Expression: ${zanata.fileTypes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fromDoc", 2);
                this.append(sb, "Specifies a document from which to begin the push operation. Documents before this document (sorted alphabetically) will not be pushed. For multi-module projects, the full document path including module id is required. Use this option to resume a failed push operation.", 3);
                this.append(sb, "Expression: ${zanata.fromDoc}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Wildcard pattern to include files and directories. This parameter is only needed for some project types, eg XLIFF, Properties. Usage -Dzanata.includes='src/myfile*.xml,**/*.xliff.xml'", 3);
                this.append(sb, "Expression: ${zanata.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "Locales to push to/pull from the server. By default all locales configured for the project will be pushed/pulled. Usage: -Dzanata.locales=locale1,locale2,locale3", 3);
                this.append(sb, "Expression: ${zanata.locales}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxChunkSize (Default: 1048576)", 2);
                this.append(sb, "Maximum size, in bytes, of document chunks to transmit when using project type 'file'. Documents smaller than this size will be transmitted in a single request, larger documents will be sent over multiple requests. Usage -Dzanata.maxChunkSize=12345", 3);
                this.append(sb, "Expression: ${zanata.maxChunkSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "merge (Default: auto)", 2);
                this.append(sb, "Merge type: 'auto' (default) or 'import' (DANGER!).", 3);
                this.append(sb, "Expression: ${zanata.merge}", 3);
                this.append(sb, "", 0);
                this.append(sb, "myTrans (Default: false)", 2);
                this.append(sb, "Indicates if all uploaded translations were translated by you.", 3);
                this.append(sb, "Expression: ${zanata.myTrans}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectConfig (Default: ${basedir}/zanata.xml)", 2);
                this.append(sb, "Zanata project configuration file.", 3);
                this.append(sb, "Expression: ${zanata.projectConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Type of project ( 'properties' = Java .properties, 'podir' = publican-style gettext directories, 'utf8properties' = UTF-8 .properties files, 'gettext' = gettext PO files, 'file' = EXPERIMENTAL document files of various types). If 'file' is used, transDir must not be the same as or nested within srcDir, and vice versa.", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectVersion", 2);
                this.append(sb, "Project version slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.projectVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushTrans", 2);
                this.append(sb, "Push translations from local files to the server (merge or import: see mergeType). This option is deprecated, replaced by pushType.", 3);
                this.append(sb, "Expression: ${zanata.pushTrans}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushType (Default: source)", 2);
                this.append(sb, "Type of push to perform on the server: 'source' pushes source documents only. 'trans' pushes translation documents only. 'both' pushes both source and translation documents.", 3);
                this.append(sb, "Expression: ${zanata.pushType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${zanata.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceLang (Default: en-US)", 2);
                this.append(sb, "Language of source documents", 3);
                this.append(sb, "Expression: ${zanata.sourceLang}", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir", 2);
                this.append(sb, "Base directory for source-language files", 3);
                this.append(sb, "Expression: ${zanata.srcDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transDir", 2);
                this.append(sb, "Base directory for target-language files (translations)", 3);
                this.append(sb, "Expression: ${zanata.transDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSrcOrder (Default: false)", 2);
                this.append(sb, "Obsolete option, only for backwards compatibility", 3);
                this.append(sb, "Expression: ${zanata.useSrcOrder}", 3);
                this.append(sb, "", 0);
                this.append(sb, "validate (Default: content)", 2);
                this.append(sb, "Run validation check against file. Only applies to XLIFF project type. 'CONTENT' - content validation check (quick). 'XSD' - validation check against xliff 1.1 schema - http://www.oasis-open.org/committees/xliff/documents/xliff-core-1.1.xsd.", 3);
                this.append(sb, "Expression: ${zanata.validate}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "push-module".equals(this.goal)) {
            this.append(sb, "zanata:push-module", 0);
            this.append(sb, "Pushes source text to a Zanata project version so that it can be translated, and optionally push translated text as well. NB: Any documents which exist on the server but not locally will be deleted as obsolete. If deleteObsoleteModules is true, documents belonging to unknown/obsolete modules will be deleted as well.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "caseSensitive (Default: true)", 2);
                this.append(sb, "Case sensitive for includes and excludes options.", 3);
                this.append(sb, "Expression: ${zanata.caseSensitive}", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyTrans (Default: false)", 2);
                this.append(sb, "Whether the server should copy latest translations from equivalent messages/documents in the database", 3);
                this.append(sb, "Expression: ${zanata.copyTrans}", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultExcludes (Default: true)", 2);
                this.append(sb, "Add default excludes (.svn, .git, etc) to the exclude filters.", 3);
                this.append(sb, "Expression: ${zanata.defaultExcludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deleteObsoleteModules (Default: false)", 2);
                this.append(sb, "Remove modules that are found in the server but not locally.", 3);
                this.append(sb, "Expression: ${zanata.deleteObsoleteModules}", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun", 2);
                this.append(sb, "Dry run: don't change any data, on the server or on the filesystem.", 3);
                this.append(sb, "Expression: ${dryRun}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeLocaleFilenames (Default: true)", 2);
                this.append(sb, "Exclude filenames which match locales configured for the project (other than the source locale). For instance, if project includes de and fr, then the files messages_de.properties and messages_fr.properties will not be treated as source files.\nNB: This parameter will be ignored for some project types which use different file naming conventions (eg podir, gettext).\n", 3);
                this.append(sb, "Expression: ${zanata.excludeLocaleFilenames}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Wildcard pattern to exclude files and directories. Usage -Dzanata.excludes='Pattern1,Pattern2,Pattern3'", 3);
                this.append(sb, "Expression: ${zanata.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileTypes (Default: txt,dtd,odt,fodt,odp,fodp,ods,fods,odg,fodg,odf,odb)", 2);
                this.append(sb, "File types to locate and transmit to the server when using project type 'file'.", 3);
                this.append(sb, "Expression: ${zanata.fileTypes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fromDoc", 2);
                this.append(sb, "Specifies a document from which to begin the push operation. Documents before this document (sorted alphabetically) will not be pushed. For multi-module projects, the full document path including module id is required. Use this option to resume a failed push operation.", 3);
                this.append(sb, "Expression: ${zanata.fromDoc}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Wildcard pattern to include files and directories. This parameter is only needed for some project types, eg XLIFF, Properties. Usage -Dzanata.includes='src/myfile*.xml,**/*.xliff.xml'", 3);
                this.append(sb, "Expression: ${zanata.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "Locales to push to/pull from the server. By default all locales configured for the project will be pushed/pulled. Usage: -Dzanata.locales=locale1,locale2,locale3", 3);
                this.append(sb, "Expression: ${zanata.locales}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxChunkSize (Default: 1048576)", 2);
                this.append(sb, "Maximum size, in bytes, of document chunks to transmit when using project type 'file'. Documents smaller than this size will be transmitted in a single request, larger documents will be sent over multiple requests. Usage -Dzanata.maxChunkSize=12345", 3);
                this.append(sb, "Expression: ${zanata.maxChunkSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "merge (Default: auto)", 2);
                this.append(sb, "Merge type: 'auto' (default) or 'import' (DANGER!).", 3);
                this.append(sb, "Expression: ${zanata.merge}", 3);
                this.append(sb, "", 0);
                this.append(sb, "myTrans (Default: false)", 2);
                this.append(sb, "Indicates if all uploaded translations were translated by you.", 3);
                this.append(sb, "Expression: ${zanata.myTrans}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectConfig (Default: ${basedir}/zanata.xml)", 2);
                this.append(sb, "Zanata project configuration file.", 3);
                this.append(sb, "Expression: ${zanata.projectConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Type of project ( 'properties' = Java .properties, 'podir' = publican-style gettext directories, 'utf8properties' = UTF-8 .properties files, 'gettext' = gettext PO files, 'file' = EXPERIMENTAL document files of various types). If 'file' is used, transDir must not be the same as or nested within srcDir, and vice versa.", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectVersion", 2);
                this.append(sb, "Project version slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.projectVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushTrans", 2);
                this.append(sb, "Push translations from local files to the server (merge or import: see mergeType). This option is deprecated, replaced by pushType.", 3);
                this.append(sb, "Expression: ${zanata.pushTrans}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushType (Default: source)", 2);
                this.append(sb, "Type of push to perform on the server: 'source' pushes source documents only. 'trans' pushes translation documents only. 'both' pushes both source and translation documents.", 3);
                this.append(sb, "Expression: ${zanata.pushType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${zanata.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceLang (Default: en-US)", 2);
                this.append(sb, "Language of source documents", 3);
                this.append(sb, "Expression: ${zanata.sourceLang}", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir", 2);
                this.append(sb, "Base directory for source-language files", 3);
                this.append(sb, "Expression: ${zanata.srcDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transDir", 2);
                this.append(sb, "Base directory for target-language files (translations)", 3);
                this.append(sb, "Expression: ${zanata.transDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "validate (Default: content)", 2);
                this.append(sb, "Run validation check against file. Only applies to XLIFF project type. 'CONTENT' - content validation check (quick). 'XSD' - validation check against xliff 1.1 schema - http://www.oasis-open.org/committees/xliff/documents/xliff-core-1.1.xsd.", 3);
                this.append(sb, "Expression: ${zanata.validate}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "put-project".equals(this.goal)) {
            this.append(sb, "zanata:put-project", 0);
            this.append(sb, "Creates or updates a Zanata project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "defaultProjectType", 2);
                this.append(sb, "Default Project type. Versions under this project that do not specify a project type will use this default. Valid values are {utf8properties, properties, gettext, podir, xliff, xml, file}. See https://github.com/zanata/zanata/wiki/Project-Types", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.defaultProjectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectDesc", 2);
                this.append(sb, "Project description", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.projectDesc}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectName", 2);
                this.append(sb, "Project name", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.projectName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectSlug", 2);
                this.append(sb, "Project slug/ID", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.projectSlug}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceCheckoutUrl", 2);
                this.append(sb, "URL for original source in a machine-readable format, e.g. git@github.com:zanata/zanata.git", 3);
                this.append(sb, "Expression: ${zanata.sourceCheckoutUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceViewUrl", 2);
                this.append(sb, "URL for original source in a human-readable format, e.g. https://github.com/zanata/zanata", 3);
                this.append(sb, "Expression: ${zanata.sourceViewUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "put-user".equals(this.goal)) {
            this.append(sb, "zanata:put-user", 0);
            this.append(sb, "Creates or updates a Zanata user.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userDisabled", 2);
                this.append(sb, "Whether the account should be disabled", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.userDisabled}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userEmail", 2);
                this.append(sb, "Email address of the user", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.userEmail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userKey", 2);
                this.append(sb, "User's api key (empty for none)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.userKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userLangs", 2);
                this.append(sb, "Language teams for the user", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.userLangs}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userName", 2);
                this.append(sb, "Full name of the user", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.userName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userPasswordHash", 2);
                this.append(sb, "User password hash", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.userPasswordHash}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userRoles", 2);
                this.append(sb, "Security roles for the user", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.userRoles}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userUsername", 2);
                this.append(sb, "Login/username of the user", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.userUsername}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "put-version".equals(this.goal)) {
            this.append(sb, "zanata:put-version", 0);
            this.append(sb, "Creates or updates a Zanata project version.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Project type {utf8properties, properties, gettext, podir, xliff, xml, file} Leave blank to inherit default project type from parent project", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionProject", 2);
                this.append(sb, "ID of Zanata project", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.versionProject}", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionSlug", 2);
                this.append(sb, "Project version ID", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${zanata.versionSlug}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stats".equals(this.goal)) {
            this.append(sb, "zanata:stats", 0);
            this.append(sb, "Get translation statistics from Zanata.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "disableSSLCert (Default: false)", 2);
                this.append(sb, "Disable SSL certificate verification when connecting to Zanata host by https.", 3);
                this.append(sb, "Expression: ${zanata.disableSSLCert}", 3);
                this.append(sb, "", 0);
                this.append(sb, "documentId", 2);
                this.append(sb, "Document id to fetch statistics for.", 3);
                this.append(sb, "Expression: ${zanata.docId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Wildcard pattern to exclude files and directories. Usage -Dzanata.excludes='Pattern1,Pattern2,Pattern3'", 3);
                this.append(sb, "Expression: ${zanata.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "format (Default: console)", 2);
                this.append(sb, "Output format for the statistics. Valid options are: csv - For a csv format (via the console). console (default) - For regular console printing.", 3);
                this.append(sb, "Expression: ${zanata.format}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeDetails (Default: false)", 2);
                this.append(sb, "Include detailed statistics.", 3);
                this.append(sb, "Expression: ${zanata.details}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Wildcard pattern to include files and directories. This parameter is only needed for some project types, eg XLIFF, Properties. Usage -Dzanata.includes='src/myfile*.xml,**/*.xliff.xml'", 3);
                this.append(sb, "Expression: ${zanata.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeWordLevelStats (Default: false)", 2);
                this.append(sb, "Include word-level stats. By default, only message-level statistics will be fetched.", 3);
                this.append(sb, "Expression: ${zanata.word}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interactiveMode (Default: ${settings.interactiveMode})", 2);
                this.append(sb, "Interactive mode is enabled by default, but can be disabled using Maven's -B/--batch-mode option.", 3);
                this.append(sb, "", 0);
                this.append(sb, "key", 2);
                this.append(sb, "API key for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.key}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logHttp (Default: false)", 2);
                this.append(sb, "Enable HTTP message logging.", 3);
                this.append(sb, "Expression: ${zanata.logHttp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Project slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectConfig (Default: ${basedir}/zanata.xml)", 2);
                this.append(sb, "Zanata project configuration file.", 3);
                this.append(sb, "Expression: ${zanata.projectConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectType", 2);
                this.append(sb, "Type of project ( 'properties' = Java .properties, 'podir' = publican-style gettext directories, 'utf8properties' = UTF-8 .properties files, 'gettext' = gettext PO files, 'file' = EXPERIMENTAL document files of various types). If 'file' is used, transDir must not be the same as or nested within srcDir, and vice versa.", 3);
                this.append(sb, "Expression: ${zanata.projectType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectVersion", 2);
                this.append(sb, "Project version slug (id) within Zanata server.", 3);
                this.append(sb, "Expression: ${zanata.projectVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "srcDir", 2);
                this.append(sb, "Base directory for source-language files", 3);
                this.append(sb, "Expression: ${zanata.srcDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "transDir", 2);
                this.append(sb, "Base directory for target-language files (translations)", 3);
                this.append(sb, "Expression: ${zanata.transDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "Base URL for the server. Defaults to the value in zanata.xml (if present).", 3);
                this.append(sb, "Expression: ${zanata.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfig (Default: ${user.home}/.config/zanata.ini)", 2);
                this.append(sb, "Client configuration file for Zanata.", 3);
                this.append(sb, "Expression: ${zanata.userConfig}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username for accessing the REST API. Defaults to the value in zanata.ini.", 3);
                this.append(sb, "Expression: ${zanata.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List<String> lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

