/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.maven;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.annotations.Parameter;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.RawPushCommand;
import org.zanata.maven.AbstractPushPullMojo;

abstract class AbstractPushMojo
extends AbstractPushPullMojo<PushOptions>
implements PushOptions {
    @Parameter(property="zanata.sourceLang", defaultValue="en-US")
    private String sourceLang = "en-US";
    @Deprecated
    @Parameter(property="zanata.pushTrans")
    private String pushTrans;
    @Parameter(property="zanata.pushType", defaultValue="source")
    private String pushType = "source";
    @Parameter(property="zanata.copyTrans", defaultValue="false")
    private boolean copyTrans;
    @Parameter(property="zanata.merge", defaultValue="auto")
    private String merge = "auto";
    @Parameter(property="zanata.defaultExcludes", defaultValue="true")
    private boolean defaultExcludes = true;
    @Parameter(property="zanata.maxChunkSize", defaultValue="1048576")
    private int maxChunkSize = 0x100000;
    @Parameter(property="zanata.fileTypes")
    private String[] fileTypes = new String[0];
    @Parameter(property="zanata.listFileTypes")
    private boolean listFileTypes = false;
    @Parameter(property="zanata.caseSensitive", defaultValue="true")
    private boolean caseSensitive = true;
    @Parameter(property="zanata.excludeLocaleFilenames", defaultValue="true")
    private boolean excludeLocaleFilenames = true;
    @Parameter(property="zanata.validate", defaultValue="content")
    private String validate = "content";
    @Parameter(property="zanata.myTrans", defaultValue="false")
    private boolean myTrans = false;

    AbstractPushMojo() {
    }

    @Override
    public PushPullCommand<PushOptions> initCommand() {
        if ("file".equalsIgnoreCase(this.getProjectType())) {
            return new RawPushCommand((PushOptions)this);
        }
        return new PushCommand((PushOptions)this);
    }

    public String getSourceLang() {
        return this.sourceLang;
    }

    public PushPullType getPushType() {
        if (this.pushTrans != null) {
            return Boolean.parseBoolean(this.pushTrans) ? PushPullType.Both : PushPullType.Source;
        }
        return PushPullType.fromString((String)this.pushType);
    }

    public boolean getCopyTrans() {
        return this.copyTrans;
    }

    public String getMergeType() {
        return this.merge;
    }

    public boolean getDefaultExcludes() {
        return this.defaultExcludes;
    }

    public int getChunkSize() {
        return this.maxChunkSize;
    }

    public ImmutableList<String> getFileTypes() {
        return ImmutableList.copyOf((Object[])this.fileTypes);
    }

    public boolean getListFileTypes() {
        return this.listFileTypes;
    }

    public String getCommandName() {
        return "push";
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean getExcludeLocaleFilenames() {
        return this.excludeLocaleFilenames;
    }

    @Nonnull
    public String getValidate() {
        return this.validate;
    }

    public boolean isMyTrans() {
        return this.myTrans;
    }
}

