/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.maven;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import org.apache.maven.plugins.annotations.Parameter;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.RawPullCommand;
import org.zanata.maven.AbstractPushPullMojo;

abstract class AbstractPullMojo
extends AbstractPushPullMojo<PullOptions>
implements PullOptions {
    @Deprecated
    @Parameter(property="zanata.pullSrc")
    private String pullSrc;
    @Parameter(property="zanata.createSkeletons")
    private boolean createSkeletons;
    @Parameter(property="zanata.approvedOnly")
    private boolean approvedOnly;
    @Parameter(property="zanata.includeFuzzy", defaultValue="false")
    private boolean includeFuzzy = false;
    @Parameter(property="zanata.purgeCache", defaultValue="false")
    private boolean purgeCache;
    @Parameter(property="zanata.useCache", defaultValue="true")
    private boolean useCache;
    private File cacheDir;
    @Parameter(property="zanata.pullType", defaultValue="trans")
    private String pullType;
    @Parameter(property="zanata.encodeTabs", defaultValue="true")
    private boolean encodeTabs = true;
    @Parameter(property="zanata.continueAfterError", defaultValue="false")
    private boolean continueAfterError = false;
    @Parameter(property="zanata.minDocPercent", defaultValue="0")
    private int minDocPercent = 0;

    AbstractPullMojo() {
        Preconditions.checkArgument((this.minDocPercent >= 0 && this.minDocPercent <= 100 ? 1 : 0) != 0, (Object)"zanata.minDocPercent should be an integer from 0 to 100");
    }

    @Override
    public PushPullCommand<PullOptions> initCommand() {
        if ("file".equalsIgnoreCase(this.getProjectType())) {
            return new RawPullCommand((PullOptions)this);
        }
        return new PullCommand((PullOptions)this);
    }

    public boolean getCreateSkeletons() {
        return this.createSkeletons;
    }

    public boolean getApprovedOnly() {
        return this.approvedOnly;
    }

    public boolean getEncodeTabs() {
        return this.encodeTabs;
    }

    public boolean getIncludeFuzzy() {
        return this.includeFuzzy;
    }

    public boolean getPurgeCache() {
        return this.purgeCache;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public boolean isContinueAfterError() {
        return this.continueAfterError;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Injected by Maven")
    public PushPullType getPullType() {
        if (this.pullSrc != null) {
            return Boolean.parseBoolean(this.pullSrc) ? PushPullType.Both : PushPullType.Trans;
        }
        return PushPullType.fromString((String)this.pullType);
    }

    public String getCommandName() {
        return "pull";
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    public int getMinDocPercent() {
        return this.minDocPercent;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }
}

