/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.maven;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullOptions;
import org.zanata.client.config.LocaleList;
import org.zanata.maven.ConfigurableProjectMojo;

abstract class AbstractPushPullMojo<O extends PushPullOptions>
extends ConfigurableProjectMojo<O>
implements PushPullOptions {
    protected static final String PROJECT_TYPE_FILE = "file";
    private static final char MODULE_SEPARATOR = '/';
    private static final char MVN_MODULE_SEPARATOR = ':';
    private static final char MODULE_SUFFIX = '/';
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="dryRun")
    private boolean dryRun = false;
    @Parameter(property="zanata.skip")
    private boolean skip;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="zanata.fromDoc")
    private String fromDoc;
    @Parameter(property="zanata.locales")
    private String[] locales;
    private LocaleList effectiveLocales;

    @Override
    protected void runCommand() throws Exception {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping");
            return;
        }
        super.runCommand();
    }

    public boolean isRootModule() {
        return this.project.isExecutionRoot();
    }

    public String getCurrentModule() {
        return this.getCurrentModule(false);
    }

    public String getCurrentModule(boolean canonicalName) {
        if (this.project == null || !this.getEnableModules()) {
            return "";
        }
        if (canonicalName) {
            return this.toMavenModuleID(this.project);
        }
        return this.toModuleID(this.project);
    }

    public String getModuleSuffix() {
        return "/";
    }

    public String getDocNameRegex() {
        return "^([^/]+/[^/]+)/(.+)";
    }

    public ImmutableSet<String> getAllModules() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (MavenProject module : this.reactorProjects) {
            String modID = this.toModuleID(module);
            builder.add((Object)modID);
        }
        return builder.build();
    }

    private String toModuleID(MavenProject module) {
        return String.valueOf(module.getGroupId()) + '/' + module.getArtifactId();
    }

    private String toMavenModuleID(MavenProject module) {
        return String.valueOf(module.getGroupId()) + ':' + module.getArtifactId();
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public String getSrcDirParameterName() {
        return "srcDir";
    }

    public String getFromDoc() {
        return this.fromDoc;
    }

    public String buildFromDocArgument(String argValue) {
        return "-Dzanata.fromDoc=\"" + argValue + "\"";
    }

    @Override
    public LocaleList getLocaleMapList() {
        if (this.effectiveLocales == null) {
            this.effectiveLocales = PushPullCommand.getLocaleMapList((LocaleList)super.getLocaleMapList(), (String[])this.locales);
        }
        return this.effectiveLocales;
    }
}

