/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.maven;

import com.pyx4j.log4j.MavenLogAppender;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.config.CommandHook;

public abstract class ConfigurableMojo<O extends ConfigurableOptions>
extends AbstractMojo
implements ConfigurableOptions {
    private static final String BUG_URL = "https://zanata.atlassian.net/";
    @Parameter(property="zanata.userConfig", defaultValue="${user.home}/.config/zanata.ini")
    private File userConfig;
    @Parameter(property="zanata.url")
    private URL url;
    @Parameter(property="zanata.username")
    private String username;
    @Parameter(property="zanata.key")
    private String key;
    private List<CommandHook> commandHooks = new ArrayList<CommandHook>();
    @Parameter(defaultValue="${settings.interactiveMode}")
    private boolean interactiveMode = true;
    private boolean interactiveModeSet;
    @Parameter(property="zanata.logHttp", defaultValue="false")
    private boolean logHttp = false;
    @Parameter(property="zanata.disableSSLCert", defaultValue="false")
    private boolean disableSSLCert = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        try {
            try {
                this.getLog().info((CharSequence)"Please report Zanata bugs here: https://zanata.atlassian.net/");
                OptionsUtil.applyConfigFiles((ConfigurableOptions)this);
                this.runCommand();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Zanata mojo exception", e);
            }
        }
        finally {
            MavenLogAppender.endPluginLog((AbstractMojo)this);
        }
    }

    protected void runCommand() throws Exception {
        ConfigurableCommand<O> command = this.initCommand();
        String name = command.getName();
        this.getLog().info((CharSequence)("Zanata command: " + name));
        if (command.isDeprecated()) {
            String msg = command.getDeprecationMessage();
            if (msg != null) {
                this.getLog().warn((CharSequence)("Command \"" + name + "\" has been deprecated: " + msg));
            } else {
                this.getLog().warn((CharSequence)("Command \"" + name + "\" has been deprecated"));
            }
        }
        command.runWithActions();
    }

    public abstract ConfigurableCommand<O> initCommand();

    public boolean getDebug() {
        throw new UnsupportedOperationException();
    }

    public void setDebug(boolean debug) {
        this.getLog().info((CharSequence)"ignoring setDebug: use mvn -X to control debug logging");
    }

    public boolean getErrors() {
        throw new UnsupportedOperationException();
    }

    public void setErrors(boolean errors) {
        this.getLog().info((CharSequence)"ignoring setErrors: use mvn -e to control exception logging");
    }

    public boolean getHelp() {
        throw new UnsupportedOperationException();
    }

    public void setHelp(boolean help) {
        throw new UnsupportedOperationException();
    }

    public boolean getQuiet() {
        throw new UnsupportedOperationException();
    }

    public void setQuiet(boolean quiet) {
        this.getLog().info((CharSequence)"ignoring setQuiet: use mvn -q to set quiet logging mode");
    }

    public boolean isDebugSet() {
        return this.getLog().isDebugEnabled();
    }

    public boolean isErrorsSet() {
        return this.getLog().isErrorEnabled();
    }

    public boolean isQuietSet() {
        return !this.getLog().isInfoEnabled();
    }

    public boolean isInteractiveModeSet() {
        return this.interactiveModeSet;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public void setInteractiveMode(boolean interactiveMode) {
        this.interactiveModeSet = true;
        this.interactiveMode = interactiveMode;
    }

    public String getCommandDescription() {
        throw new UnsupportedOperationException();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setUserConfig(File userConfig) {
        this.userConfig = userConfig;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public File getUserConfig() {
        return this.userConfig;
    }

    public void setCommandHooks(List<CommandHook> commandHooks) {
        this.commandHooks = commandHooks;
    }

    public List<CommandHook> getCommandHooks() {
        return this.commandHooks;
    }

    public boolean getLogHttp() {
        return this.logHttp;
    }

    public void setLogHttp(boolean logHttp) {
        this.logHttp = logHttp;
    }

    public boolean isDisableSSLCert() {
        return this.disableSSLCert;
    }

    public void setDisableSSLCert(boolean disableSSLCert) {
        this.disableSSLCert = disableSSLCert;
    }

    public boolean isAuthRequired() {
        return true;
    }
}

