/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.maven;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.maven.ConfigurableMojo;

public abstract class ConfigurableProjectMojo<O extends ConfigurableOptions>
extends ConfigurableMojo<O>
implements ConfigurableProjectOptions {
    @Parameter(property="zanata.projectConfig", defaultValue="${basedir}/zanata.xml")
    private File projectConfig;
    @Parameter(property="zanata.project")
    private String project;
    @Parameter(property="zanata.projectVersion")
    private String projectVersion;
    @Parameter(property="zanata.projectType")
    private String projectType;
    private LocaleList localeMapList;
    @Parameter(property="zanata.srcDir")
    private File srcDir;
    @Parameter(property="zanata.transDir")
    private File transDir;
    @Parameter(property="zanata.includes")
    private String includes;
    @Parameter(property="zanata.excludes")
    private String excludes;
    private Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private List<FileMappingRule> rules;

    public File getProjectConfig() {
        return this.projectConfig;
    }

    public void setProjectConfig(File projectConfig) {
        this.projectConfig = projectConfig;
    }

    public String getProj() {
        return this.project;
    }

    public void setProj(String project) {
        this.project = project;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public File getSrcDir() {
        return this.srcDir;
    }

    public File getTransDir() {
        return this.transDir;
    }

    public LocaleList getLocaleMapList() {
        return this.localeMapList;
    }

    public void setLocaleMapList(LocaleList localeMapList) {
        this.localeMapList = localeMapList;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setTransDir(File transDir) {
        this.transDir = transDir;
    }

    public ImmutableList<String> getIncludes() {
        if (this.includes != null) {
            return ImmutableList.copyOf((Iterable)this.splitter.split((CharSequence)this.includes));
        }
        return ImmutableList.of();
    }

    public ImmutableList<String> getExcludes() {
        if (this.excludes != null) {
            return ImmutableList.copyOf((Iterable)this.splitter.split((CharSequence)this.excludes));
        }
        return ImmutableList.of();
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public void setFileMappingRules(List<FileMappingRule> rules) {
        this.rules = rules;
    }

    public List<FileMappingRule> getFileMappingRules() {
        if (this.rules == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.rules);
    }
}

