/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.db;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zapodot.junit.db.annotations.ConfigurationProperty;
import org.zapodot.junit.db.annotations.EmbeddedDatabase;
import org.zapodot.junit.db.annotations.EmbeddedDatabaseTest;
import org.zapodot.junit.db.common.CompatibilityMode;
import org.zapodot.junit.db.common.EmbeddedDatabaseCreator;
import org.zapodot.junit.db.common.Engine;
import org.zapodot.junit.db.internal.AbstractEmbeddedDatabaseCreatorBuilder;
import org.zapodot.junit.db.internal.InternalEmbeddedDatabaseCreator;

public class EmbeddedDatabaseExtension
implements EmbeddedDatabaseCreator,
BeforeEachCallback,
AfterEachCallback,
TestInstancePostProcessor,
ParameterResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedDatabaseExtension.class);
    private static final ExtensionContext.Namespace EMBEDDED_DB_EXT = ExtensionContext.Namespace.create((Object[])new Object[]{"org.zapodot.junit.db"});
    private static final String STORE_PROPERTY_DATABASE_CREATOR = "embeddedDatabaseCreator";
    private static final String TEST_INSTANCE = "testInstance";
    private final InternalEmbeddedDatabaseCreator embeddedDatabaseCreator;

    public EmbeddedDatabaseExtension() {
        this(null);
    }

    private EmbeddedDatabaseExtension(InternalEmbeddedDatabaseCreator embeddedDatabaseCreator) {
        this.embeddedDatabaseCreator = embeddedDatabaseCreator;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        InternalEmbeddedDatabaseCreator internalEmbeddedDatabaseCreator = (InternalEmbeddedDatabaseCreator)((Object)context.getStore(EMBEDDED_DB_EXT).get((Object)STORE_PROPERTY_DATABASE_CREATOR, InternalEmbeddedDatabaseCreator.class));
        if (internalEmbeddedDatabaseCreator != null) {
            internalEmbeddedDatabaseCreator.takeDownConnection();
        }
        context.getStore(EMBEDDED_DB_EXT).remove((Object)TEST_INSTANCE);
        context.getStore(EMBEDDED_DB_EXT).remove((Object)STORE_PROPERTY_DATABASE_CREATOR);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        InternalEmbeddedDatabaseCreator embeddedDatabaseCreatorFromConfiguration = Optional.ofNullable(this.embeddedDatabaseCreator).orElseGet(() -> Optional.ofNullable((InternalEmbeddedDatabaseCreator)((Object)((Object)context.getStore(EMBEDDED_DB_EXT).get((Object)STORE_PROPERTY_DATABASE_CREATOR, InternalEmbeddedDatabaseCreator.class)))).orElseGet(() -> EmbeddedDatabaseExtension.tryToCreateFromExtensionContext(context).orElse(null)));
        if (embeddedDatabaseCreatorFromConfiguration != null) {
            embeddedDatabaseCreatorFromConfiguration.setupConnection(embeddedDatabaseCreatorFromConfiguration.getPredefinedName() != null ? embeddedDatabaseCreatorFromConfiguration.getPredefinedName() : this.extractNameFromExtensionContext(context));
            this.tryToInjectDataSourceOrConnection(context.getStore(EMBEDDED_DB_EXT).get((Object)TEST_INSTANCE), (EmbeddedDatabaseCreator)embeddedDatabaseCreatorFromConfiguration);
            context.getStore(EMBEDDED_DB_EXT).put((Object)STORE_PROPERTY_DATABASE_CREATOR, (Object)embeddedDatabaseCreatorFromConfiguration);
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        EmbeddedDatabaseExtension.tryToCreateFromExtensionContext(context).ifPresent(dc -> context.getStore(EMBEDDED_DB_EXT).put((Object)STORE_PROPERTY_DATABASE_CREATOR, (Object)dc));
        context.getStore(EMBEDDED_DB_EXT).put((Object)TEST_INSTANCE, testInstance);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(EmbeddedDatabase.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        InternalEmbeddedDatabaseCreator databaseCreator = (InternalEmbeddedDatabaseCreator)((Object)extensionContext.getStore(EMBEDDED_DB_EXT).get((Object)STORE_PROPERTY_DATABASE_CREATOR, InternalEmbeddedDatabaseCreator.class));
        if (DataSource.class.isAssignableFrom(parameter.getType())) {
            return databaseCreator.getDataSource();
        }
        if (Connection.class.isAssignableFrom(parameter.getType())) {
            return databaseCreator.getConnection();
        }
        if (String.class.isAssignableFrom(parameter.getType())) {
            return databaseCreator.getConnectionJdbcUrl();
        }
        return null;
    }

    public Connection getConnection() {
        return this.embeddedDatabaseCreator.getConnection();
    }

    public DataSource getDataSource() {
        return this.embeddedDatabaseCreator.getDataSource();
    }

    public boolean isAutoCommit() {
        return this.embeddedDatabaseCreator.isAutoCommit();
    }

    public String getConnectionJdbcUrl() {
        return this.embeddedDatabaseCreator.getConnectionJdbcUrl();
    }

    private void tryToInjectDataSourceOrConnection(Object testInstance, EmbeddedDatabaseCreator embeddedDatabaseCreator) {
        this.findInjectCandidateFields(testInstance.getClass()).stream().forEach(field -> this.injectDataSourceOrConnection(testInstance, (Field)field, embeddedDatabaseCreator));
    }

    private List<Field> findInjectCandidateFields(Class type) {
        return AnnotationUtils.findAnnotatedFields((Class)type, EmbeddedDatabase.class, f -> DataSource.class.isAssignableFrom(f.getType()) || Connection.class.isAssignableFrom(f.getType()));
    }

    private void injectDataSourceOrConnection(Object testInstance, Field field, EmbeddedDatabaseCreator embeddedDatabaseCreator) {
        boolean accessibleOriginal = field.canAccess(testInstance);
        field.setAccessible(true);
        try {
            if (DataSource.class.isAssignableFrom(field.getType())) {
                LOGGER.debug("Will inject javax.sql.DataSource to field {}", (Object)field.getName());
                field.set(testInstance, embeddedDatabaseCreator.getDataSource());
            } else if (Connection.class.isAssignableFrom(field.getType())) {
                LOGGER.debug("Will inject java.sql.Connection to field {}", (Object)field.getName());
                field.set(testInstance, embeddedDatabaseCreator.getConnection());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Could not inject embedded DataSource/Connection to field", e);
        }
        finally {
            field.setAccessible(accessibleOriginal);
        }
    }

    private String extractNameFromExtensionContext(ExtensionContext extensionContext) {
        return extensionContext.getTestClass().map(Class::getSimpleName).orElse(extensionContext.getUniqueId());
    }

    private static Optional<InternalEmbeddedDatabaseCreator> tryToCreateFromExtensionContext(ExtensionContext extensionContext) {
        LOGGER.debug("Constructing DataSource configuration using annotations");
        Optional<EmbeddedDatabaseTest> dataSourceConfig = EmbeddedDatabaseExtension.findAnnotation(extensionContext.getElement(), EmbeddedDatabaseTest.class);
        if (!dataSourceConfig.isPresent()) {
            LOGGER.warn("No configuration found. There should be an @DataSourceConfig annotation on either the test class or the method");
            return Optional.empty();
        }
        EmbeddedDatabaseTest dataSourceConfigValue = dataSourceConfig.get();
        Builder builder = Engine.HSQLDB.equals((Object)dataSourceConfigValue.engine()) ? Builder.hsqldb() : Builder.h2();
        if (dataSourceConfigValue.name() == null && !dataSourceConfigValue.name().equals("")) {
            builder.withName(dataSourceConfigValue.name());
        }
        if (dataSourceConfigValue.compatibilityMode() == null) {
            builder.withMode(CompatibilityMode.REGULAR);
        } else {
            builder.withMode(dataSourceConfigValue.compatibilityMode());
        }
        ConfigurationProperty[] properties = dataSourceConfigValue.properties();
        if (properties != null) {
            Arrays.stream(properties).forEach(cp -> builder.withProperty(cp.name(), cp.value()));
        }
        if (!dataSourceConfigValue.autoCommit()) {
            builder.withoutAutoCommit();
        }
        if (dataSourceConfigValue.initialSqls() != null) {
            Arrays.asList(dataSourceConfigValue.initialSqls()).forEach(arg_0 -> ((Builder)builder).withInitialSql(arg_0));
        }
        if (dataSourceConfigValue.initialSqlResources() != null) {
            Arrays.asList(dataSourceConfigValue.initialSqlResources()).forEach(arg_0 -> ((Builder)builder).withInitialSqlFromResource(arg_0));
        }
        return Optional.of(builder.buildInternalEmbeddedDatabaseCreator());
    }

    private static <A extends Annotation> Optional<A> findAnnotation(Optional<? extends AnnotatedElement> element, Class<A> annotationType) {
        return element.flatMap(e -> EmbeddedDatabaseExtension.findAnnotationForElement(annotationType, e));
    }

    private static <A extends Annotation> Optional<A> findAnnotationForElement(Class<A> annotationType, AnnotatedElement e) {
        return AnnotationUtils.findAnnotation((AnnotatedElement)e, annotationType);
    }

    public static class Builder
    extends AbstractEmbeddedDatabaseCreatorBuilder<EmbeddedDatabaseExtension> {
        private Builder(Engine engine) {
            super(engine);
        }

        public static Builder h2() {
            return new Builder(Engine.H2);
        }

        public static Builder hsqldb() {
            return new Builder(Engine.HSQLDB);
        }

        InternalEmbeddedDatabaseCreator buildInternalEmbeddedDatabaseCreator() {
            return new InternalEmbeddedDatabaseCreator(this.autoCommit, this.name, this.propertiesMap(), this.initializationPlugins, this.createJdbcUrlFactory(), this.compatibilityMode);
        }

        public EmbeddedDatabaseExtension build() {
            return new EmbeddedDatabaseExtension(this.buildInternalEmbeddedDatabaseCreator());
        }
    }
}

