/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.h2.jdbc.JdbcSQLException;
import org.h2.util.StringUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zapodot.junit.db.internal.CloseSuppressedConnectionFactory;
import org.zapodot.junit.db.internal.EmbeddedDataSource;
import org.zapodot.junit.db.internal.H2JdbcUrlFactory;
import org.zapodot.junit.db.plugin.InitializationPlugin;

public class EmbeddedDatabaseRule
implements TestRule {
    public static final String PROP_INIT_SQL = "INIT";
    public static final String PROP_MODE = "MODE";
    private final boolean autoCommit;
    private final String _predefinedName;
    private String _testName;
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedDatabaseRule.class);
    private final Map<String, String> _jdbcUrlProperties;
    private final Map<Class<? extends InitializationPlugin>, InitializationPlugin> initializationPlugins;
    private Connection connection;

    public EmbeddedDatabaseRule() {
        this(true, null, null, null);
    }

    private EmbeddedDatabaseRule(boolean autoCommit, String name, Map<String, String> jdbcUrlProperties, Map<Class<? extends InitializationPlugin>, InitializationPlugin> initializationPlugins) {
        this.autoCommit = autoCommit;
        this._predefinedName = name;
        this._jdbcUrlProperties = jdbcUrlProperties == null ? Collections.emptyMap() : jdbcUrlProperties;
        this.initializationPlugins = initializationPlugins == null ? Collections.emptyMap() : initializationPlugins;
    }

    public static Builder builder() {
        return Builder.instance();
    }

    public Connection getConnection() {
        return CloseSuppressedConnectionFactory.createProxy(this.connection);
    }

    public DataSource getDataSource() {
        return EmbeddedDataSource.create(this.connection);
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public String getConnectionJdbcUrl() {
        return H2JdbcUrlFactory.buildFilteringInitProperties(this.getInMemoryDatabaseName(), this._jdbcUrlProperties);
    }

    private String generateJdbcUrl() {
        return H2JdbcUrlFactory.buildWithNameAndProperties(this.getInMemoryDatabaseName(), this._jdbcUrlProperties);
    }

    private String getInMemoryDatabaseName() {
        return this._predefinedName == null ? this._testName : this._predefinedName;
    }

    public Statement apply(Statement base, Description description) {
        this.warnIfNameIsPredifinedAndTheRuleIsMethodBased(description);
        return this.statement(base, this._predefinedName != null ? this._predefinedName : this.extractNameFromDescription(description));
    }

    private void warnIfNameIsPredifinedAndTheRuleIsMethodBased(Description description) {
        if (description.getMethodName() != null && this._predefinedName != null) {
            LOGGER.warn("You have set a name for your datasource and are running the EmbeddedDatabaseRule as a method @Rule. This may lead to the datasource not being reset between tests especially of your tests uses runs with multiple threads");
        }
    }

    private String extractNameFromDescription(Description description) {
        return description.getTestClass() == null ? description.getClassName() : description.getTestClass().getSimpleName();
    }

    private Statement statement(final Statement base, final String name) {
        return new Statement(){

            public void evaluate() throws Throwable {
                EmbeddedDatabaseRule.this.setupConnection(name);
                try {
                    base.evaluate();
                }
                finally {
                    EmbeddedDatabaseRule.this.takeDownConnection();
                }
            }
        };
    }

    private void takeDownConnection() throws SQLException {
        this.connection.close();
    }

    private void setupConnection(String name) throws SQLException {
        this._testName = name;
        String url = this.generateJdbcUrl();
        try {
            this.connection = DriverManager.getConnection(url);
        }
        catch (JdbcSQLException e) {
            if (url.contains("RUNSCRIPT")) {
                LOGGER.error("Failed to initialize the H2 database. Please check your init script for errors", (Throwable)e);
            }
            throw e;
        }
        this.connection.setAutoCommit(this.isAutoCommit());
        for (Map.Entry<Class<? extends InitializationPlugin>, InitializationPlugin> entry : this.initializationPlugins.entrySet()) {
            entry.getValue().connectionMade(name, this.getConnection());
        }
    }

    public static enum CompatibilityMode {
        REGULAR,
        DB2,
        Derby,
        HSQLDB,
        MSSQLServer,
        MySQL,
        Oracle,
        PostgreSQL;

    }

    public static class Builder {
        private final Map<String, String> properties = new LinkedHashMap<String, String>();
        private final Map<Class<? extends InitializationPlugin>, InitializationPlugin> initializationPlugins = new LinkedHashMap<Class<? extends InitializationPlugin>, InitializationPlugin>();
        private String name;
        private boolean autoCommit = true;

        public static Builder instance() {
            return new Builder();
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        private String normalizeString(String input) {
            if (input == null) {
                return null;
            }
            return input.replaceAll("\n", "").replaceAll(";", "\\\\;").trim();
        }

        public Builder withInitialSql(String sql) {
            if (sql == null) {
                throw new IllegalArgumentException("The value of the \"sql\" argument can not be null");
            }
            return this.withProperty(EmbeddedDatabaseRule.PROP_INIT_SQL, sql);
        }

        public Builder withInitialSqlFromResource(String resource) {
            if (resource == null) {
                throw new IllegalArgumentException("The value of the \"resource\" argument can not be null");
            }
            return this.withProperty(EmbeddedDatabaseRule.PROP_INIT_SQL, String.format("RUNSCRIPT FROM '%s';", this.escapeSpecialChars(resource)));
        }

        private String escapeSpecialChars(String absolutePath) {
            return StringUtils.replaceAll((String)absolutePath, (String)"\\", (String)"/");
        }

        public Builder withMode(String mode) {
            if (mode == null) {
                throw new IllegalArgumentException("The \"mode\" argument can not be null");
            }
            return this.withProperty(EmbeddedDatabaseRule.PROP_MODE, mode);
        }

        public Builder withMode(CompatibilityMode compatibilityMode) {
            if (compatibilityMode == null) {
                throw new IllegalArgumentException("The \"compatibilityMode\" argument can not be null");
            }
            return this.withMode(compatibilityMode.name());
        }

        public <P extends InitializationPlugin> Builder initializedByPlugin(P plugin) {
            if (plugin != null) {
                this.initializationPlugins.put(plugin.getClass(), plugin);
            }
            return this;
        }

        public Builder withProperty(String property, String value) {
            if (property != null && value != null) {
                this.properties.put(property, this.normalizeString(value));
            }
            return this;
        }

        public Builder withoutAutoCommit() {
            this.autoCommit = false;
            return this;
        }

        private Map<String, String> propertiesMap() {
            return new LinkedHashMap<String, String>(this.properties);
        }

        public EmbeddedDatabaseRule build() {
            return new EmbeddedDatabaseRule(this.autoCommit, this.name, this.propertiesMap(), this.initializationPlugins);
        }
    }
}

