/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.db.internal;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.zapodot.junit.db.internal.CloseSuppressedConnectionFactory;

public class EmbeddedDataSource
implements DataSource {
    private final Connection connection;

    private EmbeddedDataSource(Connection connection) {
        this.connection = connection;
    }

    public static EmbeddedDataSource create(Connection connection) {
        return new EmbeddedDataSource(connection);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return CloseSuppressedConnectionFactory.createProxy(this.connection);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return new PrintWriter(System.err);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getGlobal();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("unWrap(Class) is not supported for embedded datasource");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

