/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.db.internal;

import java.util.LinkedHashMap;
import java.util.Map;

public class H2JdbcUrlFactory {
    static final String H2_IN_MEMORY_JDBC_URL_PREFIX = "jdbc:h2:mem:";

    private H2JdbcUrlFactory() {
    }

    public static Map<String, String> filterInitProperties(Map<String, String> jdbcUrlProperties) {
        if (jdbcUrlProperties == null) {
            return null;
        }
        LinkedHashMap<String, String> propertiesCopy = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> property : jdbcUrlProperties.entrySet()) {
            if ("INIT".equalsIgnoreCase(property.getKey())) continue;
            propertiesCopy.put(property.getKey(), property.getValue());
        }
        return propertiesCopy;
    }

    private static String createJdbcUrlParameterString(Map<String, String> properties) {
        if (properties == null) {
            return "";
        }
        StringBuilder paramStringBuilder = new StringBuilder("");
        for (Map.Entry<String, String> property : properties.entrySet()) {
            if (property.getValue() == null) continue;
            paramStringBuilder.append(';').append(property.getKey()).append('=').append(property.getValue());
        }
        return paramStringBuilder.toString();
    }

    public static String buildWithNameAndProperties(String name, Map<String, String> properties) {
        if (name == null) {
            throw new NullPointerException("The value of the \"name\" parameter can not be null");
        }
        return H2_IN_MEMORY_JDBC_URL_PREFIX + name + H2JdbcUrlFactory.createJdbcUrlParameterString(properties);
    }

    public static String buildFilteringInitProperties(String name, Map<String, String> properties) {
        return H2JdbcUrlFactory.buildWithNameAndProperties(name, H2JdbcUrlFactory.filterInitProperties(properties));
    }
}

