/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.db;

import java.util.List;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zapodot.junit.db.common.CompatibilityMode;
import org.zapodot.junit.db.common.Engine;
import org.zapodot.junit.db.internal.AbstractEmbeddedDatabaseCreatorBuilder;
import org.zapodot.junit.db.internal.EmbeddedDatabaseCreatorImpl;
import org.zapodot.junit.db.internal.JdbcUrlFactory;
import org.zapodot.junit.db.plugin.InitializationPlugin;

public class EmbeddedDatabaseRule
extends EmbeddedDatabaseCreatorImpl
implements TestRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedDatabaseRule.class);

    public EmbeddedDatabaseRule() {
        this(true, null, null, null, null, CompatibilityMode.REGULAR);
    }

    private EmbeddedDatabaseRule(boolean autoCommit, String name, Map<String, String> jdbcUrlProperties, List<InitializationPlugin> initializationPlugins, JdbcUrlFactory jdbcUrlFactory, CompatibilityMode compatibilityMode) {
        super(autoCommit, name, jdbcUrlProperties, initializationPlugins, jdbcUrlFactory, compatibilityMode);
    }

    public static Builder builder() {
        return EmbeddedDatabaseRule.h2();
    }

    public static Builder h2() {
        return Builder.h2();
    }

    public static Builder hsqldb() {
        return Builder.hsqldb();
    }

    public Statement apply(Statement base, Description description) {
        this.warnIfNameIsPredifinedAndTheRuleIsMethodBased(description);
        return this.statement(base, this.predefinedName != null ? this.predefinedName : this.extractNameFromDescription(description));
    }

    private void warnIfNameIsPredifinedAndTheRuleIsMethodBased(Description description) {
        if (description.getMethodName() != null && this.predefinedName != null) {
            LOGGER.warn("You have set a name for your datasource and are running the EmbeddedDatabaseRule as a method @Rule. This may lead to the datasource not being reset between tests especially of your tests uses runs with multiple threads");
        }
    }

    private String extractNameFromDescription(Description description) {
        return description.getTestClass() == null ? description.getClassName() : description.getTestClass().getSimpleName();
    }

    private Statement statement(final Statement base, final String name) {
        return new Statement(){

            public void evaluate() throws Throwable {
                EmbeddedDatabaseRule.this.setupConnection(name);
                try {
                    base.evaluate();
                }
                finally {
                    EmbeddedDatabaseRule.this.takeDownConnection();
                }
            }
        };
    }

    public static class Builder
    extends AbstractEmbeddedDatabaseCreatorBuilder<EmbeddedDatabaseRule> {
        private Builder(Engine engine) {
            super(engine);
        }

        @Deprecated
        public static Builder instance() {
            return Builder.h2();
        }

        public static Builder h2() {
            return new Builder(Engine.H2);
        }

        public static Builder hsqldb() {
            return new Builder(Engine.HSQLDB);
        }

        public EmbeddedDatabaseRule build() {
            return new EmbeddedDatabaseRule(this.autoCommit, this.name, this.propertiesMap(), this.initializationPlugins, this.createJdbcUrlFactory(), this.compatibilityMode);
        }
    }
}

