/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit5.jms.internal;

import java.util.Objects;
import org.zapodot.junit5.jms.internal.BrokerConfigurationBuilder;

public class BrokerConfiguration {
    public static final BrokerConfiguration DEFAULT = BrokerConfigurationBuilder.instance().withMarshal(false).withPersistenceEnabled(false).build();
    private final String name;
    private final Boolean marshal;
    private final Boolean persistenceEnabled;

    public BrokerConfiguration(String name, Boolean marshal, Boolean persistenceEnabled) {
        this.name = name;
        this.marshal = marshal;
        this.persistenceEnabled = persistenceEnabled;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getMarshal() {
        return this.marshal;
    }

    public Boolean getPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerConfiguration that = (BrokerConfiguration)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.marshal, that.marshal) && Objects.equals(this.persistenceEnabled, that.persistenceEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.marshal, this.persistenceEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BrokerConfiguration{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", marshal=").append(this.marshal);
        sb.append(", persistenceEnabled=").append(this.persistenceEnabled);
        sb.append('}');
        return sb.toString();
    }
}

