/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.ldap;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.zapodot.junit.ldap.EmbeddedLdapRule;
import org.zapodot.junit.ldap.internal.AuthenticationConfiguration;
import org.zapodot.junit.ldap.internal.EmbeddedLdapRuleImpl;

public class EmbeddedLdapRuleBuilder {
    public static final String DEFAULT_DOMAIN = "dc=example,dc=com";
    public static final String DEFAULT_BIND_DSN = "cn=Directory manager";
    public static final String DEFAULT_BIND_CREDENTIALS = "password";
    public static final String LDAP_SERVER_LISTENER_NAME = "test-listener";
    public static final int MIN_PORT_EXCLUSIVE = 0;
    public static final int MAX_PORT_EXCLUSIVE = 65535;
    private List<String> domainDsn = new LinkedList<String>();
    private String bindDSN = "cn=Directory manager";
    private String bindCredentials = "password";
    private List<String> ldifsToImport = new LinkedList<String>();
    private List<String> schemaLdifs = new LinkedList<String>();
    private boolean addDefaultSchema = true;
    private Integer bindPort = 0;
    private InetAddress bindAddress = InetAddress.getLoopbackAddress();
    private AuthenticationConfiguration authenticationConfiguration;

    public static EmbeddedLdapRuleBuilder newInstance() {
        return new EmbeddedLdapRuleBuilder();
    }

    public EmbeddedLdapRuleBuilder usingDomainDsn(String domainDsn) {
        this.domainDsn.add(domainDsn);
        return this;
    }

    public EmbeddedLdapRuleBuilder usingBindDSN(String bindDSN) {
        this.bindDSN = bindDSN;
        return this;
    }

    public EmbeddedLdapRuleBuilder usingBindCredentials(String bindCredentials) {
        this.bindCredentials = bindCredentials;
        return this;
    }

    public EmbeddedLdapRuleBuilder bindingToPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException(String.format("Value \"%s\" is not a valid port number", port));
        }
        this.bindPort = port;
        return this;
    }

    public EmbeddedLdapRuleBuilder bindingToAddress(String address) {
        Objects.requireNonNull(address);
        try {
            InetAddress addressByName;
            this.bindAddress = addressByName = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Unknown host address \"%s\"", address), e);
        }
        return this;
    }

    public EmbeddedLdapRuleBuilder withoutDefaultSchema() {
        this.addDefaultSchema = false;
        return this;
    }

    public EmbeddedLdapRuleBuilder withSchema(String ... ldifSchemaFiles) {
        this.schemaLdifs.addAll(Arrays.asList(ldifSchemaFiles));
        return this;
    }

    public EmbeddedLdapRuleBuilder importingLdifs(String ... ldifFiles) {
        if (ldifFiles != null) {
            this.ldifsToImport.addAll(Arrays.asList(ldifFiles));
        }
        return this;
    }

    public EmbeddedLdapRule build() {
        Objects.requireNonNull(this.bindDSN, "\"bindDSN\" can not be null");
        return EmbeddedLdapRuleImpl.createForConfiguration(this.createInMemoryServerConfiguration(), this.authenticationConfiguration, this.ldifsToImport);
    }

    private InMemoryDirectoryServerConfig createInMemoryServerConfiguration() {
        try {
            InMemoryDirectoryServerConfig inMemoryDirectoryServerConfig = new InMemoryDirectoryServerConfig(this.domainDsnArray());
            if (this.bindCredentials != null) {
                this.authenticationConfiguration = new AuthenticationConfiguration(this.bindDSN, this.bindCredentials);
                inMemoryDirectoryServerConfig.addAdditionalBindCredentials(this.bindDSN, this.bindCredentials);
            }
            InMemoryListenerConfig listenerConfig = InMemoryListenerConfig.createLDAPConfig((String)LDAP_SERVER_LISTENER_NAME, (InetAddress)this.bindAddress, (int)this.bindPort, null);
            inMemoryDirectoryServerConfig.setListenerConfigs(new InMemoryListenerConfig[]{listenerConfig});
            inMemoryDirectoryServerConfig.setSchema(this.customSchema());
            return inMemoryDirectoryServerConfig;
        }
        catch (LDAPException e) {
            throw new IllegalStateException("Could not create configuration for the in-memory LDAP instance due to an exception", e);
        }
    }

    private String[] domainDsnArray() {
        if (this.domainDsn.size() == 0) {
            return new String[]{DEFAULT_DOMAIN};
        }
        return this.domainDsn.toArray(new String[0]);
    }

    private Schema customSchema() {
        List<File> schemaFiles = this.schemaFiles();
        try {
            Schema initialSchema;
            Object object = initialSchema = this.addDefaultSchema ? Schema.getDefaultStandardSchema() : null;
            if (!schemaFiles.isEmpty()) {
                Schema customSchema = initialSchema == null ? Schema.getSchema(schemaFiles) : Schema.mergeSchemas((Schema[])new Schema[]{initialSchema, Schema.getSchema(schemaFiles)});
                return customSchema;
            }
            return null;
        }
        catch (LDAPException | LDIFException | IOException e) {
            throw new IllegalArgumentException("Could not create custom LDAP schema due, probably caused by an incorrectly formatted schema", e);
        }
    }

    private List<File> schemaFiles() {
        return Lists.newArrayList((Iterable)Lists.transform(this.schemaLdifs, (Function)new Function<String, File>(){

            public File apply(String input) {
                try {
                    File file = new File(Resources.getResource((String)input).toURI());
                    if (!file.isFile()) {
                        throw new IllegalArgumentException(String.format("The resource named \"%s\" can not be found or is not a file", input));
                    }
                    return file;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(String.format("The resource named \"%s\" is not a valid file reference", input), e);
                }
            }
        }));
    }
}

