/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.gen;

import java.util.HashMap;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;

public class Network {
    private final ClientApi api;

    public Network(ClientApi api) {
        this.api = api;
    }

    public ApiResponse getRootCaCertValidity() throws ClientApiException {
        return this.api.callApi("network", "view", "getRootCaCertValidity", null);
    }

    public ApiResponse getServerCertValidity() throws ClientApiException {
        return this.api.callApi("network", "view", "getServerCertValidity", null);
    }

    public ApiResponse getAliases() throws ClientApiException {
        return this.api.callApi("network", "view", "getAliases", null);
    }

    public ApiResponse getLocalServers() throws ClientApiException {
        return this.api.callApi("network", "view", "getLocalServers", null);
    }

    public ApiResponse getPassThroughs() throws ClientApiException {
        return this.api.callApi("network", "view", "getPassThroughs", null);
    }

    public ApiResponse getConnectionTimeout() throws ClientApiException {
        return this.api.callApi("network", "view", "getConnectionTimeout", null);
    }

    public ApiResponse getDefaultUserAgent() throws ClientApiException {
        return this.api.callApi("network", "view", "getDefaultUserAgent", null);
    }

    public ApiResponse getDnsTtlSuccessfulQueries() throws ClientApiException {
        return this.api.callApi("network", "view", "getDnsTtlSuccessfulQueries", null);
    }

    public ApiResponse getHttpProxy() throws ClientApiException {
        return this.api.callApi("network", "view", "getHttpProxy", null);
    }

    public ApiResponse getHttpProxyExclusions() throws ClientApiException {
        return this.api.callApi("network", "view", "getHttpProxyExclusions", null);
    }

    public ApiResponse getSocksProxy() throws ClientApiException {
        return this.api.callApi("network", "view", "getSocksProxy", null);
    }

    public ApiResponse isHttpProxyAuthEnabled() throws ClientApiException {
        return this.api.callApi("network", "view", "isHttpProxyAuthEnabled", null);
    }

    public ApiResponse isHttpProxyEnabled() throws ClientApiException {
        return this.api.callApi("network", "view", "isHttpProxyEnabled", null);
    }

    public ApiResponse isSocksProxyEnabled() throws ClientApiException {
        return this.api.callApi("network", "view", "isSocksProxyEnabled", null);
    }

    public ApiResponse isUseGlobalHttpState() throws ClientApiException {
        return this.api.callApi("network", "view", "isUseGlobalHttpState", null);
    }

    public ApiResponse generateRootCaCert() throws ClientApiException {
        return this.api.callApi("network", "action", "generateRootCaCert", null);
    }

    public ApiResponse importRootCaCert(String filepath) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filePath", filepath);
        return this.api.callApi("network", "action", "importRootCaCert", map);
    }

    public ApiResponse setRootCaCertValidity(String validity) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("validity", validity);
        return this.api.callApi("network", "action", "setRootCaCertValidity", map);
    }

    public ApiResponse setServerCertValidity(String validity) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("validity", validity);
        return this.api.callApi("network", "action", "setServerCertValidity", map);
    }

    public ApiResponse addAlias(String name, String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        if (enabled != null) {
            map.put("enabled", enabled);
        }
        return this.api.callApi("network", "action", "addAlias", map);
    }

    public ApiResponse addLocalServer(String address, String port, String api, String proxy, String behindnat, String decoderesponse, String removeacceptencoding) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("address", address);
        map.put("port", port);
        if (api != null) {
            map.put("api", api);
        }
        if (proxy != null) {
            map.put("proxy", proxy);
        }
        if (behindnat != null) {
            map.put("behindNat", behindnat);
        }
        if (decoderesponse != null) {
            map.put("decodeResponse", decoderesponse);
        }
        if (removeacceptencoding != null) {
            map.put("removeAcceptEncoding", removeacceptencoding);
        }
        return this.api.callApi("network", "action", "addLocalServer", map);
    }

    public ApiResponse addPassThrough(String authority, String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("authority", authority);
        if (enabled != null) {
            map.put("enabled", enabled);
        }
        return this.api.callApi("network", "action", "addPassThrough", map);
    }

    public ApiResponse removeAlias(String name) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        return this.api.callApi("network", "action", "removeAlias", map);
    }

    public ApiResponse removeLocalServer(String address, String port) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("address", address);
        map.put("port", port);
        return this.api.callApi("network", "action", "removeLocalServer", map);
    }

    public ApiResponse removePassThrough(String authority) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("authority", authority);
        return this.api.callApi("network", "action", "removePassThrough", map);
    }

    public ApiResponse setAliasEnabled(String name, String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("enabled", enabled);
        return this.api.callApi("network", "action", "setAliasEnabled", map);
    }

    public ApiResponse setPassThroughEnabled(String authority, String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("authority", authority);
        map.put("enabled", enabled);
        return this.api.callApi("network", "action", "setPassThroughEnabled", map);
    }

    public ApiResponse setConnectionTimeout(String timeout) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("timeout", timeout);
        return this.api.callApi("network", "action", "setConnectionTimeout", map);
    }

    public ApiResponse setDefaultUserAgent(String useragent) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userAgent", useragent);
        return this.api.callApi("network", "action", "setDefaultUserAgent", map);
    }

    public ApiResponse setDnsTtlSuccessfulQueries(String ttl) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ttl", ttl);
        return this.api.callApi("network", "action", "setDnsTtlSuccessfulQueries", map);
    }

    public ApiResponse addHttpProxyExclusion(String host, String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", host);
        if (enabled != null) {
            map.put("enabled", enabled);
        }
        return this.api.callApi("network", "action", "addHttpProxyExclusion", map);
    }

    public ApiResponse removeHttpProxyExclusion(String host) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", host);
        return this.api.callApi("network", "action", "removeHttpProxyExclusion", map);
    }

    public ApiResponse setHttpProxy(String host, String port, String realm, String username, String password) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", host);
        map.put("port", port);
        if (realm != null) {
            map.put("realm", realm);
        }
        if (username != null) {
            map.put("username", username);
        }
        if (password != null) {
            map.put("password", password);
        }
        return this.api.callApi("network", "action", "setHttpProxy", map);
    }

    public ApiResponse setHttpProxyAuthEnabled(String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("enabled", enabled);
        return this.api.callApi("network", "action", "setHttpProxyAuthEnabled", map);
    }

    public ApiResponse setHttpProxyEnabled(String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("enabled", enabled);
        return this.api.callApi("network", "action", "setHttpProxyEnabled", map);
    }

    public ApiResponse setHttpProxyExclusionEnabled(String host, String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", host);
        map.put("enabled", enabled);
        return this.api.callApi("network", "action", "setHttpProxyExclusionEnabled", map);
    }

    public ApiResponse setSocksProxy(String host, String port, String version, String usedns, String username, String password) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", host);
        map.put("port", port);
        if (version != null) {
            map.put("version", version);
        }
        if (usedns != null) {
            map.put("useDns", usedns);
        }
        if (username != null) {
            map.put("username", username);
        }
        if (password != null) {
            map.put("password", password);
        }
        return this.api.callApi("network", "action", "setSocksProxy", map);
    }

    public ApiResponse setSocksProxyEnabled(String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("enabled", enabled);
        return this.api.callApi("network", "action", "setSocksProxyEnabled", map);
    }

    public ApiResponse setUseGlobalHttpState(String use) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("use", use);
        return this.api.callApi("network", "action", "setUseGlobalHttpState", map);
    }

    public ApiResponse addPkcs12ClientCertificate(String filepath, String password, String index) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filePath", filepath);
        map.put("password", password);
        if (index != null) {
            map.put("index", index);
        }
        return this.api.callApi("network", "action", "addPkcs12ClientCertificate", map);
    }

    public ApiResponse setUseClientCertificate(String use) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("use", use);
        return this.api.callApi("network", "action", "setUseClientCertificate", map);
    }

    public byte[] proxypac() throws ClientApiException {
        return this.api.callApiOther("network", "other", "proxy.pac", null);
    }

    public byte[] setProxy(String proxy) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proxy", proxy);
        return this.api.callApiOther("network", "other", "setProxy", map);
    }

    public byte[] rootCaCert() throws ClientApiException {
        return this.api.callApiOther("network", "other", "rootCaCert", null);
    }
}

