/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.zaproxy.clientapi.core.Alert;
import org.zaproxy.clientapi.core.AlertsFile;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ApiResponseElement;
import org.zaproxy.clientapi.core.ApiResponseFactory;
import org.zaproxy.clientapi.core.ApiResponseList;
import org.zaproxy.clientapi.core.ApiResponseSet;
import org.zaproxy.clientapi.core.ClientApiException;
import org.zaproxy.clientapi.gen.AccessControl;
import org.zaproxy.clientapi.gen.Acsrf;
import org.zaproxy.clientapi.gen.AjaxSpider;
import org.zaproxy.clientapi.gen.AlertFilter;
import org.zaproxy.clientapi.gen.Ascan;
import org.zaproxy.clientapi.gen.Authentication;
import org.zaproxy.clientapi.gen.Authorization;
import org.zaproxy.clientapi.gen.Automation;
import org.zaproxy.clientapi.gen.Autoupdate;
import org.zaproxy.clientapi.gen.Break;
import org.zaproxy.clientapi.gen.Context;
import org.zaproxy.clientapi.gen.Core;
import org.zaproxy.clientapi.gen.Exim;
import org.zaproxy.clientapi.gen.Exportreport;
import org.zaproxy.clientapi.gen.ForcedUser;
import org.zaproxy.clientapi.gen.Graphql;
import org.zaproxy.clientapi.gen.HttpSessions;
import org.zaproxy.clientapi.gen.ImportLogFiles;
import org.zaproxy.clientapi.gen.Importurls;
import org.zaproxy.clientapi.gen.LocalProxies;
import org.zaproxy.clientapi.gen.Network;
import org.zaproxy.clientapi.gen.Openapi;
import org.zaproxy.clientapi.gen.Params;
import org.zaproxy.clientapi.gen.Pnh;
import org.zaproxy.clientapi.gen.Pscan;
import org.zaproxy.clientapi.gen.Replacer;
import org.zaproxy.clientapi.gen.Reports;
import org.zaproxy.clientapi.gen.Retest;
import org.zaproxy.clientapi.gen.Reveal;
import org.zaproxy.clientapi.gen.Revisit;
import org.zaproxy.clientapi.gen.RuleConfig;
import org.zaproxy.clientapi.gen.Script;
import org.zaproxy.clientapi.gen.Search;
import org.zaproxy.clientapi.gen.Selenium;
import org.zaproxy.clientapi.gen.SessionManagement;
import org.zaproxy.clientapi.gen.Soap;
import org.zaproxy.clientapi.gen.Spider;
import org.zaproxy.clientapi.gen.Stats;
import org.zaproxy.clientapi.gen.Users;
import org.zaproxy.clientapi.gen.Wappalyzer;
import org.zaproxy.clientapi.gen.Websocket;

public class ClientApi {
    private static final int DEFAULT_CONNECTION_POOLING_IN_MS = 1000;
    private static final String ZAP_API_KEY_HEADER = "X-ZAP-API-Key";
    private static final String ZAP_API_KEY_PARAM = "apikey";
    private Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", 8090));
    private boolean debug = false;
    private PrintStream debugStream = System.out;
    private final String zapAddress;
    private final int zapPort;
    private final String apiKey;
    private DocumentBuilderFactory docBuilderFactory;
    public AccessControl accessControl = new AccessControl(this);
    public Acsrf acsrf = new Acsrf(this);
    public AjaxSpider ajaxSpider = new AjaxSpider(this);
    public AlertFilter alertFilter = new AlertFilter(this);
    public org.zaproxy.clientapi.gen.Alert alert = new org.zaproxy.clientapi.gen.Alert(this);
    public Ascan ascan = new Ascan(this);
    public Authentication authentication = new Authentication(this);
    public Authorization authorization = new Authorization(this);
    public Automation automation = new Automation(this);
    public Autoupdate autoupdate = new Autoupdate(this);
    public Break brk = new Break(this);
    public Context context = new Context(this);
    public Core core = new Core(this);
    public Exim exim = new Exim(this);
    public Exportreport exportreport = new Exportreport(this);
    public ForcedUser forcedUser = new ForcedUser(this);
    public Graphql graphql = new Graphql(this);
    public HttpSessions httpSessions = new HttpSessions(this);
    public ImportLogFiles logImportFiles = new ImportLogFiles(this);
    public Importurls importurls = new Importurls(this);
    public LocalProxies localProxies = new LocalProxies(this);
    public Network network = new Network(this);
    public Openapi openapi = new Openapi(this);
    public Params params = new Params(this);
    public Pnh pnh = new Pnh(this);
    public Pscan pscan = new Pscan(this);
    public Replacer replacer = new Replacer(this);
    public Reports reports = new Reports(this);
    public Retest retest = new Retest(this);
    public Reveal reveal = new Reveal(this);
    public Revisit revisit = new Revisit(this);
    public RuleConfig ruleConfig = new RuleConfig(this);
    public Search search = new Search(this);
    public Script script = new Script(this);
    public Selenium selenium = new Selenium(this);
    public SessionManagement sessionManagement = new SessionManagement(this);
    public Soap soap = new Soap(this);
    public Spider spider = new Spider(this);
    public Stats stats = new Stats(this);
    public Users users = new Users(this);
    public Wappalyzer wappalyzer = new Wappalyzer(this);
    public Websocket websocket = new Websocket(this);

    public ClientApi(String zapAddress, int zapPort) {
        this(zapAddress, zapPort, false);
    }

    public ClientApi(String zapAddress, int zapPort, String apiKey) {
        this(zapAddress, zapPort, apiKey, false);
    }

    public ClientApi(String zapAddress, int zapPort, boolean debug) {
        this(zapAddress, zapPort, null, debug);
    }

    public ClientApi(String zapAddress, int zapPort, String apiKey, boolean debug) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(zapAddress, zapPort));
        this.debug = debug;
        this.zapAddress = zapAddress;
        this.zapPort = zapPort;
        this.apiKey = apiKey;
    }

    public void setDebugStream(PrintStream debugStream) {
        this.debugStream = debugStream;
    }

    public void accessUrl(String url) throws ClientApiException {
        this.accessUrlViaProxy(this.proxy, url);
    }

    private int statusToInt(ApiResponse response) {
        return Integer.parseInt(((ApiResponseElement)response).getValue());
    }

    public void checkAlerts(List<Alert> ignoreAlerts, List<Alert> requireAlerts) throws ClientApiException {
        HashMap<String, List<Alert>> results = this.checkForAlerts(ignoreAlerts, requireAlerts);
        this.verifyAlerts(results.get("requireAlerts"), results.get("reportAlerts"));
    }

    private void verifyAlerts(List<Alert> requireAlerts, List<Alert> reportAlerts) throws ClientApiException {
        StringBuilder sb = new StringBuilder();
        if (reportAlerts.size() > 0) {
            sb.append("Found ").append(reportAlerts.size()).append(" alerts\n");
            for (Alert alert : reportAlerts) {
                sb.append('\t');
                sb.append(alert.toString());
                sb.append('\n');
            }
        }
        if (requireAlerts != null && requireAlerts.size() > 0) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append("Not found ").append(requireAlerts.size()).append(" alerts\n");
            for (Alert alert : requireAlerts) {
                sb.append('\t');
                sb.append(alert.toString());
                sb.append('\n');
            }
        }
        if (sb.length() > 0) {
            if (this.debug) {
                this.debugStream.println("Failed: " + sb.toString());
            }
            throw new ClientApiException(sb.toString());
        }
    }

    public void checkAlerts(List<Alert> ignoreAlerts, List<Alert> requireAlerts, File outputFile) throws ClientApiException {
        HashMap<String, List<Alert>> results = this.checkForAlerts(ignoreAlerts, requireAlerts);
        int alertsFound = results.get("reportAlerts").size();
        int alertsNotFound = results.get("requireAlerts").size();
        int alertsIgnored = results.get("ignoredAlerts").size();
        String resultsString = String.format("Alerts Found: %d, Alerts required but not found: %d, Alerts ignored: %d", alertsFound, alertsNotFound, alertsIgnored);
        try {
            AlertsFile.saveAlertsToFile(results.get("requireAlerts"), results.get("reportAlerts"), results.get("ignoredAlerts"), outputFile);
        }
        catch (Exception e) {
            throw new ClientApiException("Failed to save the alerts:", e);
        }
        if (alertsFound > 0 || alertsNotFound > 0) {
            throw new ClientApiException("Check Alerts Failed!\n" + resultsString);
        }
        if (this.debug) {
            this.debugStream.println("Check Alerts Passed!\n" + resultsString);
        }
    }

    public List<Alert> getAlerts(String baseUrl, int start, int count) throws ClientApiException {
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        ApiResponse response = this.alert.alerts(baseUrl, String.valueOf(start), String.valueOf(count), null);
        if (response != null && response instanceof ApiResponseList) {
            ApiResponseList alertList = (ApiResponseList)response;
            for (ApiResponse resp : alertList.getItems()) {
                alerts.add(new Alert((ApiResponseSet)resp));
            }
        }
        return alerts;
    }

    private HashMap<String, List<Alert>> checkForAlerts(List<Alert> ignoreAlerts, List<Alert> requireAlerts) throws ClientApiException {
        ArrayList<Alert> reportAlerts = new ArrayList<Alert>();
        ArrayList<Alert> ignoredAlerts = new ArrayList<Alert>();
        List<Alert> alerts = this.getAlerts(null, -1, -1);
        block0: for (Alert alert : alerts) {
            boolean ignore = false;
            if (ignoreAlerts != null) {
                for (Alert ignoreAlert : ignoreAlerts) {
                    if (!alert.matches(ignoreAlert)) continue;
                    if (this.debug) {
                        this.debugStream.println("Ignoring alert " + ignoreAlert);
                    }
                    ignoredAlerts.add(alert);
                    ignore = true;
                    break;
                }
            }
            if (!ignore) {
                reportAlerts.add(alert);
            }
            if (requireAlerts == null) continue;
            for (Alert requireAlert : requireAlerts) {
                if (!alert.matches(requireAlert)) continue;
                if (this.debug) {
                    this.debugStream.println("Found alert " + alert);
                }
                requireAlerts.remove(requireAlert);
                reportAlerts.remove(alert);
                continue block0;
            }
        }
        HashMap<String, List<Alert>> results = new HashMap<String, List<Alert>>();
        results.put("reportAlerts", reportAlerts);
        results.put("requireAlerts", requireAlerts);
        results.put("ignoredAlerts", ignoredAlerts);
        return results;
    }

    private void accessUrlViaProxy(Proxy proxy, String apiurl) throws ClientApiException {
        try {
            URL url = new URL(apiurl);
            if (this.debug) {
                this.debugStream.println("Open URL: " + apiurl);
            }
            HttpURLConnection uc = (HttpURLConnection)url.openConnection(proxy);
            uc.connect();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream(), StandardCharsets.UTF_8));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    if (!this.debug) continue;
                    this.debugStream.println(inputLine);
                }
            }
            catch (IOException e) {
                if (this.debug) {
                    this.debugStream.println("Ignoring exception " + e);
                }
            }
        }
        catch (Exception e) {
            throw new ClientApiException(e);
        }
    }

    public ApiResponse callApi(String component, String type, String method, Map<String, String> params) throws ClientApiException {
        Document dom = this.callApiDom(component, type, method, params);
        return ApiResponseFactory.getResponse(dom.getFirstChild());
    }

    private Document callApiDom(String component, String type, String method, Map<String, String> params) throws ClientApiException {
        try {
            HttpRequest request = this.buildZapRequest("xml", component, type, method, params);
            if (this.debug) {
                this.debugStream.println("Open URL: " + request.getRequestUri());
            }
            DocumentBuilder db = this.getDocumentBuilderFactory().newDocumentBuilder();
            return db.parse(this.getConnectionInputStream(request));
        }
        catch (Exception e) {
            throw new ClientApiException(e);
        }
    }

    private DocumentBuilderFactory getDocumentBuilderFactory() throws ParserConfigurationException {
        if (this.docBuilderFactory == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setExpandEntityReferences(false);
            this.docBuilderFactory = factory;
        }
        return this.docBuilderFactory;
    }

    private InputStream getConnectionInputStream(HttpRequest request) throws IOException {
        HttpURLConnection uc = (HttpURLConnection)request.getRequestUri().openConnection(this.proxy);
        uc.setUseCaches(false);
        for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
            uc.setRequestProperty(header.getKey(), header.getValue());
        }
        uc.connect();
        if (uc.getResponseCode() >= 400) {
            return uc.getErrorStream();
        }
        return uc.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] callApiOther(String component, String type, String method, Map<String, String> params) throws ClientApiException {
        try {
            HttpRequest request = this.buildZapRequest("other", component, type, method, params);
            if (this.debug) {
                this.debugStream.println("Open URL: " + request.getRequestUri());
            }
            InputStream in = this.getConnectionInputStream(request);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            try {
                int bytesRead;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                out.close();
                in.close();
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new ClientApiException(e);
        }
    }

    private HttpRequest buildZapRequest(String format, String component, String type, String method, Map<String, String> params) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append("http://zap/");
        sb.append(format);
        sb.append('/');
        sb.append(component);
        sb.append('/');
        sb.append(type);
        sb.append('/');
        sb.append(method);
        sb.append('/');
        if (params != null) {
            if (this.apiKey != null && !this.apiKey.isEmpty()) {
                params.put(ZAP_API_KEY_PARAM, this.apiKey);
            }
            sb.append('?');
            for (Map.Entry<String, String> p : params.entrySet()) {
                sb.append(ClientApi.encodeQueryParam(p.getKey()));
                sb.append('=');
                if (p.getValue() != null) {
                    sb.append(ClientApi.encodeQueryParam(p.getValue()));
                }
                sb.append('&');
            }
        } else if (this.apiKey != null && !this.apiKey.isEmpty()) {
            sb.append('?');
            sb.append(ClientApi.encodeQueryParam(ZAP_API_KEY_PARAM));
            sb.append('=');
            sb.append(ClientApi.encodeQueryParam(this.apiKey));
        }
        HttpRequest request = new HttpRequest(new URL(sb.toString()));
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            request.addHeader(ZAP_API_KEY_HEADER, this.apiKey);
        }
        return request;
    }

    private static String encodeQueryParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return param;
        }
    }

    @Deprecated
    public void addExcludeFromContext(String apiKey, String contextName, String regex) throws Exception {
        this.context.excludeFromContext(apiKey, contextName, regex);
    }

    @Deprecated
    public void addIncludeInContext(String apiKey, String contextName, String regex) throws Exception {
        this.context.includeInContext(apiKey, contextName, regex);
    }

    @Deprecated
    public void includeOneMatchingNodeInContext(String apiKey, String contextName, String regex) throws Exception {
        List<String> sessionUrls = this.getSessionUrls();
        boolean foundOneMatch = false;
        for (String sessionUrl : sessionUrls) {
            if (!sessionUrl.matches(regex)) continue;
            if (foundOneMatch) {
                this.addExcludeFromContext(apiKey, contextName, sessionUrl);
                continue;
            }
            foundOneMatch = true;
        }
        if (!foundOneMatch) {
            throw new Exception("Unexpected result: No url found in site tree matching regex " + regex);
        }
    }

    public void includeOneMatchingNodeInContext(String contextName, String regex) throws Exception {
        List<String> sessionUrls = this.getSessionUrls();
        boolean foundOneMatch = false;
        for (String sessionUrl : sessionUrls) {
            if (!sessionUrl.matches(regex)) continue;
            if (foundOneMatch) {
                this.context.excludeFromContext(contextName, regex);
                continue;
            }
            foundOneMatch = true;
        }
        if (!foundOneMatch) {
            throw new Exception("Unexpected result: No url found in site tree matching regex " + regex);
        }
    }

    private List<String> getSessionUrls() throws Exception {
        ArrayList<String> sessionUrls = new ArrayList<String>();
        ApiResponse response = this.core.urls();
        if (response != null && response instanceof ApiResponseList) {
            ApiResponseElement urlList = (ApiResponseElement)((ApiResponseList)response).getItems().get(0);
            for (ApiResponse element : ((ApiResponseList)response).getItems()) {
                URL url = new URL(((ApiResponseElement)element).getValue());
                sessionUrls.add(url.getProtocol() + "://" + url.getHost() + url.getPath());
            }
            System.out.println(urlList);
        }
        return sessionUrls;
    }

    @Deprecated
    public void activeScanSiteInScope(String apiKey, String url) throws Exception {
        this.ascan.scan(apiKey, url, "true", "true", "", "", "");
        this.waitForAScanToFinish(url);
    }

    public void activeScanSiteInScope(String url) throws Exception {
        this.ascan.scan(url, "true", "true", "", "", "");
        this.waitForAScanToFinish(url);
    }

    private void waitForAScanToFinish(String targetUrl) throws ClientApiException {
        int status = 0;
        while (status < 100) {
            status = this.statusToInt(this.ascan.status(""));
            if (this.debug) {
                String format = "Scanning %s Progress: %d%%";
                System.out.println(String.format(format, targetUrl, status));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitForSuccessfulConnectionToZap(int timeoutInSeconds) throws ClientApiException {
        this.waitForSuccessfulConnectionToZap(timeoutInSeconds, 1000);
    }

    public void waitForSuccessfulConnectionToZap(int timeoutInSeconds, int pollingIntervalInMs) throws ClientApiException {
        int timeoutInMs;
        int connectionTimeoutInMs = timeoutInMs = (int)TimeUnit.SECONDS.toMillis(timeoutInSeconds);
        boolean connectionSuccessful = false;
        long startTime = System.currentTimeMillis();
        do {
            try (Socket socket = new Socket();){
                try {
                    socket.connect(new InetSocketAddress(this.zapAddress, this.zapPort), connectionTimeoutInMs);
                    connectionSuccessful = true;
                }
                catch (SocketTimeoutException ignore) {
                    throw ClientApi.newTimeoutConnectionToZap(timeoutInSeconds);
                }
                catch (IOException ignore) {
                    try {
                        Thread.sleep(pollingIntervalInMs);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new ClientApiException("The ClientApi was interrupted while sleeping between connection polling.", e);
                    }
                    long ellapsedTime = System.currentTimeMillis() - startTime;
                    if (ellapsedTime >= (long)timeoutInMs) {
                        throw ClientApi.newTimeoutConnectionToZap(timeoutInSeconds);
                    }
                    connectionTimeoutInMs = (int)((long)timeoutInMs - ellapsedTime);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (!connectionSuccessful);
    }

    private static ClientApiException newTimeoutConnectionToZap(int timeoutInSeconds) {
        return new ClientApiException("Unable to connect to ZAP's proxy after " + timeoutInSeconds + " seconds.");
    }

    private static class HttpRequest {
        private final URL requestUri;
        private final Map<String, String> headers;

        public HttpRequest(URL url) {
            this.requestUri = url;
            this.headers = new HashMap<String, String>();
        }

        public URL getRequestUri() {
            return this.requestUri;
        }

        public void addHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(this.headers);
        }
    }
}

