/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.gen;

import java.util.HashMap;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;

public class AccessControl {
    private final ClientApi api;

    public AccessControl(ClientApi api) {
        this.api = api;
    }

    public ApiResponse getScanProgress(String contextid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        return this.api.callApi("accessControl", "view", "getScanProgress", map);
    }

    public ApiResponse getScanStatus(String contextid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        return this.api.callApi("accessControl", "view", "getScanStatus", map);
    }

    public ApiResponse scan(String contextid, String userid, String scanasunauthuser, String raisealert, String alertrisklevel) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        if (scanasunauthuser != null) {
            map.put("scanAsUnAuthUser", scanasunauthuser);
        }
        if (raisealert != null) {
            map.put("raiseAlert", raisealert);
        }
        if (alertrisklevel != null) {
            map.put("alertRiskLevel", alertrisklevel);
        }
        return this.api.callApi("accessControl", "action", "scan", map);
    }

    public ApiResponse writeHTMLreport(String contextid, String filename) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("fileName", filename);
        return this.api.callApi("accessControl", "action", "writeHTMLreport", map);
    }
}

