/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.gen;

import java.util.HashMap;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;

public class Alert {
    private final ClientApi api;

    public Alert(ClientApi api) {
        this.api = api;
    }

    public ApiResponse alert(String id) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        return this.api.callApi("alert", "view", "alert", map);
    }

    public ApiResponse alerts(String baseurl, String start, String count, String riskid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (baseurl != null) {
            map.put("baseurl", baseurl);
        }
        if (start != null) {
            map.put("start", start);
        }
        if (count != null) {
            map.put("count", count);
        }
        if (riskid != null) {
            map.put("riskId", riskid);
        }
        return this.api.callApi("alert", "view", "alerts", map);
    }

    public ApiResponse alertsSummary(String baseurl) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (baseurl != null) {
            map.put("baseurl", baseurl);
        }
        return this.api.callApi("alert", "view", "alertsSummary", map);
    }

    public ApiResponse numberOfAlerts(String baseurl, String riskid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (baseurl != null) {
            map.put("baseurl", baseurl);
        }
        if (riskid != null) {
            map.put("riskId", riskid);
        }
        return this.api.callApi("alert", "view", "numberOfAlerts", map);
    }

    public ApiResponse alertsByRisk(String url, String recurse) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (url != null) {
            map.put("url", url);
        }
        if (recurse != null) {
            map.put("recurse", recurse);
        }
        return this.api.callApi("alert", "view", "alertsByRisk", map);
    }

    public ApiResponse alertCountsByRisk(String url, String recurse) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (url != null) {
            map.put("url", url);
        }
        if (recurse != null) {
            map.put("recurse", recurse);
        }
        return this.api.callApi("alert", "view", "alertCountsByRisk", map);
    }

    public ApiResponse deleteAllAlerts() throws ClientApiException {
        return this.api.callApi("alert", "action", "deleteAllAlerts", null);
    }

    public ApiResponse deleteAlert(String id) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        return this.api.callApi("alert", "action", "deleteAlert", map);
    }

    public ApiResponse updateAlert(String id, String name, String riskid, String confidenceid, String description, String param, String attack, String otherinfo, String solution, String references, String evidence, String cweid, String wascid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("name", name);
        map.put("riskId", riskid);
        map.put("confidenceId", confidenceid);
        map.put("description", description);
        if (param != null) {
            map.put("param", param);
        }
        if (attack != null) {
            map.put("attack", attack);
        }
        if (otherinfo != null) {
            map.put("otherInfo", otherinfo);
        }
        if (solution != null) {
            map.put("solution", solution);
        }
        if (references != null) {
            map.put("references", references);
        }
        if (evidence != null) {
            map.put("evidence", evidence);
        }
        if (cweid != null) {
            map.put("cweId", cweid);
        }
        if (wascid != null) {
            map.put("wascId", wascid);
        }
        return this.api.callApi("alert", "action", "updateAlert", map);
    }

    public ApiResponse addAlert(String messageid, String name, String riskid, String confidenceid, String description, String param, String attack, String otherinfo, String solution, String references, String evidence, String cweid, String wascid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("messageId", messageid);
        map.put("name", name);
        map.put("riskId", riskid);
        map.put("confidenceId", confidenceid);
        map.put("description", description);
        if (param != null) {
            map.put("param", param);
        }
        if (attack != null) {
            map.put("attack", attack);
        }
        if (otherinfo != null) {
            map.put("otherInfo", otherinfo);
        }
        if (solution != null) {
            map.put("solution", solution);
        }
        if (references != null) {
            map.put("references", references);
        }
        if (evidence != null) {
            map.put("evidence", evidence);
        }
        if (cweid != null) {
            map.put("cweId", cweid);
        }
        if (wascid != null) {
            map.put("wascId", wascid);
        }
        return this.api.callApi("alert", "action", "addAlert", map);
    }
}

