/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.zaproxy.zap.db.RecordAlertTag;
import org.zaproxy.zap.db.TableAlertTag;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableAlertTag
extends SqlAbstractTable
implements TableAlertTag {
    private static final String TABLE_NAME = DbSQL.getSQL("alerttag.table_name");
    private static final String TAG_ID = DbSQL.getSQL("alerttag.field.tagid");
    private static final String ALERT_ID = DbSQL.getSQL("alerttag.field.alertid");
    private static final String KEY = DbSQL.getSQL("alerttag.field.key");
    private static final String VALUE = DbSQL.getSQL("alerttag.field.value");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, DbSQL.getSQL("alerttag.ps.createtable"));
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public RecordAlertTag read(long tagId) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public RecordAlertTag read(long alertId, String key) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public RecordAlertTag insertOrUpdate(long alertId, String key, String value) throws DatabaseException {
        SqlPreparedStatementWrapper psInsertOrUpdate = null;
        try {
            psInsertOrUpdate = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.insertorupdate");
            psInsertOrUpdate.getPs().setLong(1, alertId);
            psInsertOrUpdate.getPs().setString(2, key);
            psInsertOrUpdate.getPs().setString(3, value);
            psInsertOrUpdate.getPs().executeUpdate();
            RecordAlertTag recordAlertTag = this.read(alertId, key);
            return recordAlertTag;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsertOrUpdate);
        }
    }

    @Override
    public Map<String, String> getAllTags() throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllTags = null;
        try {
            psGetAllTags = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.getalltags");
            HashMap<String, String> result = new HashMap<String, String>();
            try (ResultSet rs = psGetAllTags.getPs().executeQuery();){
                while (rs.next()) {
                    result.put(rs.getString(KEY), rs.getString(VALUE));
                }
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllTags);
        }
    }

    @Override
    public List<RecordAlertTag> getAllRecords() throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllTags = null;
        try {
            psGetAllTags = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.getalltags");
            ArrayList<RecordAlertTag> result = new ArrayList<RecordAlertTag>();
            try (ResultSet rs = psGetAllTags.getPs().executeQuery();){
                RecordAlertTag rat;
                while ((rat = this.build(rs)) != null) {
                    result.add(rat);
                }
            }
            ArrayList<RecordAlertTag> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllTags);
        }
    }

    @Override
    public Map<String, String> getTagsByAlertId(long alertId) throws DatabaseException {
        SqlPreparedStatementWrapper psGetTagsByAlertId = null;
        try {
            psGetTagsByAlertId = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.gettagsbyalertid");
            HashMap<String, String> result = new HashMap<String, String>();
            psGetTagsByAlertId.getPs().setLong(1, alertId);
            try (ResultSet rs = psGetTagsByAlertId.getPs().executeQuery();){
                while (rs.next()) {
                    result.put(rs.getString("key"), rs.getString("value"));
                }
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetTagsByAlertId);
        }
    }

    @Override
    public void delete(long alertId, String key) throws DatabaseException {
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.deletebyalertidtagkey");
            psDelete.getPs().setLong(1, alertId);
            psDelete.getPs().setString(2, key);
            psDelete.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    @Override
    public void delete(long tagId) throws DatabaseException {
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.deletebytagid");
            psDelete.getPs().setLong(1, tagId);
            psDelete.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    @Override
    public void deleteAllTagsForAlert(long alertId) throws DatabaseException {
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.deletealltagsforalert");
            psDelete.getPs().setLong(1, alertId);
            psDelete.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    @Override
    public int deleteAllTags() throws DatabaseException {
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.deletealltags");
            int n = psDelete.getPs().executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    private RecordAlertTag build(ResultSet rs) throws SQLException {
        RecordAlertTag rat = null;
        if (rs.next()) {
            rat = new RecordAlertTag(rs.getLong(TAG_ID), rs.getLong(ALERT_ID), rs.getString(KEY), rs.getString(VALUE));
        }
        return rat;
    }
}

