/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableHistory
extends SqlAbstractTable
implements TableHistory {
    private static final String TABLE_NAME = DbSQL.getSQL("history.table_name");
    private static final String HISTORYID = DbSQL.getSQL("history.field.historyid");
    private static final String SESSIONID = DbSQL.getSQL("history.field.sessionid");
    private static final String HISTTYPE = DbSQL.getSQL("history.field.histtype");
    private static final String STATUSCODE = DbSQL.getSQL("history.field.statuscode");
    private static final String TIMESENTMILLIS = DbSQL.getSQL("history.field.timesentmillis");
    private static final String TIMEELAPSEDMILLIS = DbSQL.getSQL("history.field.timeelapsedmillis");
    private static final String REQHEADER = DbSQL.getSQL("history.field.reqheader");
    private static final String REQBODY = DbSQL.getSQL("history.field.reqbody");
    private static final String RESHEADER = DbSQL.getSQL("history.field.resheader");
    private static final String RESBODY = DbSQL.getSQL("history.field.resbody");
    private static final String TAG = DbSQL.getSQL("history.field.tag");
    private static final String NOTE = DbSQL.getSQL("history.field.note");
    private static final String RESPONSE_FROM_TARGET_HOST = DbSQL.getSQL("history.field.responsefromtargethost");
    private int lastInsertedIndex;
    private static boolean isExistStatusCode = false;
    private static final Logger log = LogManager.getLogger(SqlTableHistory.class);
    private boolean bodiesAsBytes;
    int configuredrequestbodysize = -1;
    int configuredresponsebodysize = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            DatabaseParam dbparams = new DatabaseParam();
            dbparams.load(Constant.getInstance().FILE_CONFIG);
            this.configuredrequestbodysize = dbparams.getRequestBodySize();
            this.configuredresponsebodysize = dbparams.getResponseBodySize();
            this.bodiesAsBytes = true;
            if (DbSQL.getDbType().equals("hsqldb")) {
                this.updateTable(conn);
            }
            isExistStatusCode = DbUtils.hasColumn(conn, TABLE_NAME, STATUSCODE);
            int currentIndex = 0;
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement(DbSQL.getSQL("history.ps.lastindex"));
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        currentIndex = rs.getInt(1);
                    }
                }
            }
            finally {
                block19: {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {
                            if (!log.isDebugEnabled()) break block19;
                            log.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            this.lastInsertedIndex = currentIndex;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private void updateTable(Connection connection) throws DatabaseException {
        block22: {
            try {
                if (!DbUtils.hasColumn(connection, TABLE_NAME, TAG)) {
                    DbUtils.execute(connection, DbSQL.getSQL("history.ps.addtag"));
                }
                if (!DbUtils.hasColumn(connection, TABLE_NAME, NOTE)) {
                    DbUtils.execute(connection, DbSQL.getSQL("history.ps.addnote"));
                }
                if (DbUtils.getColumnType(connection, TABLE_NAME, REQBODY) != 61) {
                    this.bodiesAsBytes = false;
                }
                if (!DbUtils.hasColumn(connection, TABLE_NAME, RESPONSE_FROM_TARGET_HOST)) {
                    DbUtils.execute(connection, DbSQL.getSQL("history.ps.addrespfromtarget"));
                    DbUtils.executeUpdate(connection, DbSQL.getSQL("history.ps.setrespfromtarget"));
                }
                int requestbodysizeindb = DbUtils.getColumnSize(connection, TABLE_NAME, REQBODY);
                int responsebodysizeindb = DbUtils.getColumnSize(connection, TABLE_NAME, RESBODY);
                try {
                    Throwable throwable;
                    PreparedStatement stmt;
                    if (requestbodysizeindb != this.configuredrequestbodysize && this.configuredrequestbodysize > 0) {
                        stmt = connection.prepareStatement(DbSQL.getSQL("history.ps.changereqsize"));
                        throwable = null;
                        try {
                            stmt.setInt(1, this.configuredrequestbodysize);
                            stmt.execute();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stmt != null) {
                                SqlTableHistory.$closeResource(throwable, stmt);
                            }
                        }
                    }
                    if (responsebodysizeindb == this.configuredresponsebodysize || this.configuredresponsebodysize <= 0) break block22;
                    stmt = connection.prepareStatement(DbSQL.getSQL("history.ps.changerespsize"));
                    throwable = null;
                    try {
                        stmt.setInt(1, this.configuredresponsebodysize);
                        stmt.execute();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (stmt != null) {
                            SqlTableHistory.$closeResource(throwable, stmt);
                        }
                    }
                }
                catch (SQLException e) {
                    log.error("An error occurred while modifying a column length on " + TABLE_NAME);
                    log.error("The 'Maximum Request Body Size' value in the Database Options needs to be set to at least " + requestbodysizeindb + " to avoid this error");
                    log.error("The 'Maximum Response Body Size' value in the Database Options needs to be set to at least " + responsebodysizeindb + " to avoid this error");
                    log.error("The SQL Exception was:", (Throwable)e);
                    throw e;
                }
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
        }
    }

    @Override
    public RecordHistory read(int historyId) throws HttpMalformedHeaderException, DatabaseException {
        SqlPreparedStatementWrapper psRead = null;
        try {
            psRead = DbSQL.getSingleton().getPreparedStatement("history.ps.read");
            psRead.getPs().setInt(1, historyId);
            psRead.getPs().execute();
            RecordHistory result = null;
            try (ResultSet rs = psRead.getPs().getResultSet();){
                result = this.build(rs);
            }
            RecordHistory recordHistory = result;
            return recordHistory;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psRead);
        }
    }

    @Override
    public RecordHistory write(long sessionId, int histType, HttpMessage msg) throws HttpMalformedHeaderException, DatabaseException {
        String reqHeader = "";
        byte[] reqBody = new byte[]{};
        String resHeader = "";
        byte[] resBody = reqBody;
        String method = "";
        String uri = "";
        int statusCode = 0;
        String note = msg.getNote();
        if (!msg.getRequestHeader().isEmpty()) {
            reqHeader = msg.getRequestHeader().toString();
            reqBody = msg.getRequestBody().getBytes();
            method = msg.getRequestHeader().getMethod();
            uri = msg.getRequestHeader().getURI().toString();
        }
        if (!msg.getResponseHeader().isEmpty()) {
            resHeader = msg.getResponseHeader().toString();
            resBody = msg.getResponseBody().getBytes();
            statusCode = msg.getResponseHeader().getStatusCode();
        }
        return this.write(sessionId, histType, msg.getTimeSentMillis(), msg.getTimeElapsedMillis(), method, uri, statusCode, reqHeader, reqBody, resHeader, resBody, null, note, msg.isResponseFromTargetHost());
    }

    /*
     * Exception decompiling
     */
    private RecordHistory write(long sessionId, int histType, long timeSentMillis, int timeElapsedMillis, String method, String uri, int statusCode, String reqHeader, byte[] reqBody, String resHeader, byte[] resBody, String tag, String note, boolean responseFromTargetHost) throws HttpMalformedHeaderException, DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordHistory build(ResultSet rs) throws HttpMalformedHeaderException, DatabaseException {
        try {
            RecordHistory history = null;
            try {
                if (rs.next()) {
                    byte[] resBody;
                    byte[] reqBody;
                    if (this.bodiesAsBytes) {
                        reqBody = rs.getBytes(REQBODY);
                        resBody = rs.getBytes(RESBODY);
                    } else {
                        reqBody = rs.getString(REQBODY).getBytes();
                        resBody = rs.getString(RESBODY).getBytes();
                    }
                    history = new RecordHistory(rs.getInt(HISTORYID), rs.getInt(HISTTYPE), rs.getLong(SESSIONID), rs.getLong(TIMESENTMILLIS), rs.getInt(TIMEELAPSEDMILLIS), rs.getString(REQHEADER), reqBody, rs.getString(RESHEADER), resBody, rs.getString(TAG), rs.getString(NOTE), rs.getBoolean(RESPONSE_FROM_TARGET_HOST));
                }
            }
            finally {
                rs.close();
            }
            return history;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public List<Integer> getHistoryIds(long sessionId) throws DatabaseException {
        return this.getHistoryIdsFromPreparedStatement(wrapper -> wrapper.getPs().setLong(1, sessionId), "history.ps.gethistoryids", null);
    }

    private List<Integer> getHistoryIdsFromPreparedStatement(PreparedStatementSetter preparedStatementSetter, String key, int ... params) throws DatabaseException {
        SqlPreparedStatementWrapper psGetHistoryIds = null;
        try {
            psGetHistoryIds = DbSQL.getSingleton().getPreparedStatement(key, params);
            preparedStatementSetter.setParameter(psGetHistoryIds);
            ArrayList<Integer> v = new ArrayList<Integer>();
            try (ResultSet rs = psGetHistoryIds.getPs().executeQuery();){
                while (rs.next()) {
                    v.add(rs.getInt(HISTORYID));
                }
            }
            ArrayList<Integer> arrayList = v;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetHistoryIds);
        }
    }

    @Override
    public List<Integer> getHistoryIdsStartingAt(long sessionId, int startAtHistoryId) throws DatabaseException {
        return this.getHistoryIdsFromPreparedStatement(wrapper -> {
            wrapper.getPs().setLong(1, sessionId);
            wrapper.getPs().setInt(2, startAtHistoryId);
        }, "history.ps.gethistoryidsstartingat", null);
    }

    @Override
    public List<Integer> getHistoryIdsOfHistType(long sessionId, int ... histTypes) throws DatabaseException {
        if (histTypes == null || histTypes.length == 0) {
            return this.getHistoryIds(sessionId);
        }
        return this.getHistoryIdsFromPreparedStatement(wrapper -> {
            wrapper.getPs().setLong(1, sessionId);
            DbSQL.setSetValues(wrapper.getPs(), 2, histTypes);
        }, "history.ps.gethistoryidsinctypes", histTypes.length);
    }

    @Override
    public List<Integer> getHistoryIdsOfHistTypeStartingAt(long sessionId, int startAtHistoryId, int ... histTypes) throws DatabaseException {
        if (histTypes == null || histTypes.length == 0) {
            return this.getHistoryIds(sessionId);
        }
        return this.getHistoryIdsFromPreparedStatement(wrapper -> {
            wrapper.getPs().setLong(1, sessionId);
            wrapper.getPs().setInt(2, startAtHistoryId);
            DbSQL.setSetValues(wrapper.getPs(), 3, histTypes);
        }, "history.ps.gethistoryidsinctypesstartingat", histTypes.length);
    }

    @Override
    public List<Integer> getHistoryIdsExceptOfHistType(long sessionId, int ... histTypes) throws DatabaseException {
        if (histTypes == null || histTypes.length == 0) {
            return this.getHistoryIds(sessionId);
        }
        return this.getHistoryIdsFromPreparedStatement(wrapper -> {
            wrapper.getPs().setLong(1, sessionId);
            DbSQL.setSetValues(wrapper.getPs(), 2, histTypes);
        }, "history.ps.gethistoryidsnottypes", histTypes.length);
    }

    @Override
    public List<Integer> getHistoryIdsExceptOfHistTypeStartingAt(long sessionId, int startAtHistoryId, int ... histTypes) throws DatabaseException {
        if (histTypes == null || histTypes.length == 0) {
            return this.getHistoryIds(sessionId);
        }
        return this.getHistoryIdsFromPreparedStatement(wrapper -> {
            wrapper.getPs().setLong(1, sessionId);
            wrapper.getPs().setInt(2, startAtHistoryId);
            DbSQL.setSetValues(wrapper.getPs(), 3, histTypes);
        }, "history.ps.gethistoryidsnottypesstartingat", histTypes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getHistoryList(long sessionId, int histType, String filter, boolean isRequest) throws DatabaseException {
        try {
            PreparedStatement psReadSearch = this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE " + SESSIONID + " = ? AND " + HISTTYPE + " = ? ORDER BY " + HISTORYID);
            ResultSet rs = null;
            Vector<Integer> v = new Vector<Integer>();
            try {
                Pattern pattern = Pattern.compile(filter, 10);
                Matcher matcher = null;
                psReadSearch.setLong(1, sessionId);
                psReadSearch.setInt(2, histType);
                rs = psReadSearch.executeQuery();
                while (rs.next()) {
                    if (isRequest) {
                        matcher = pattern.matcher(rs.getString(REQHEADER));
                        if (matcher.find()) {
                            v.add(rs.getInt(HISTORYID));
                            continue;
                        }
                        matcher = pattern.matcher(rs.getString(REQBODY));
                        if (!matcher.find()) continue;
                        v.add(rs.getInt(HISTORYID));
                        continue;
                    }
                    matcher = pattern.matcher(rs.getString(RESHEADER));
                    if (matcher.find()) {
                        v.add(rs.getInt(HISTORYID));
                        continue;
                    }
                    matcher = pattern.matcher(rs.getString(RESBODY));
                    if (!matcher.find()) continue;
                    v.add(rs.getInt(HISTORYID));
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                psReadSearch.close();
            }
            return v;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void deleteHistorySession(long sessionId) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteSession = null;
        try {
            psDeleteSession = DbSQL.getSingleton().getPreparedStatement("history.ps.deletesession");
            psDeleteSession.getPs().setLong(1, sessionId);
            psDeleteSession.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteSession);
        }
    }

    @Override
    public void deleteHistoryType(long sessionId, int historyType) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteType = null;
        try {
            psDeleteType = DbSQL.getSingleton().getPreparedStatement("history.ps.deletetype");
            psDeleteType.getPs().setLong(1, sessionId);
            psDeleteType.getPs().setInt(2, historyType);
            psDeleteType.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteType);
        }
    }

    @Override
    public void delete(int historyId) throws DatabaseException {
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("history.ps.delete");
            psDelete.getPs().setInt(1, historyId);
            psDelete.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    @Override
    public void delete(List<Integer> ids) throws DatabaseException {
        this.delete(ids, 1000);
    }

    @Override
    public void delete(List<Integer> ids, int batchSize) throws DatabaseException {
        if (ids == null) {
            throw new IllegalArgumentException("Parameter ids must not be null.");
        }
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Parameter batchSize must be greater than zero.");
        }
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("history.ps.delete");
            int count = 0;
            for (Integer id : ids) {
                psDelete.getPs().setInt(1, id);
                psDelete.getPs().addBatch();
                if (++count % batchSize != 0) continue;
                psDelete.getPs().executeBatch();
                count = 0;
            }
            if (count % batchSize != 0) {
                psDelete.getPs().executeBatch();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    @Deprecated
    public static void setHistoryTypeAsTemporary(int historyType) {
    }

    @Deprecated
    public static void unsetHistoryTypeAsTemporary(int historyType) {
        HistoryReference.removeTemporaryType(historyType);
    }

    @Override
    public void deleteTemporary() throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteTemp = null;
        try {
            psDeleteTemp = DbSQL.getSingleton().getPreparedStatement("history.ps.deletetemp");
            for (Integer type : HistoryReference.getTemporaryTypes()) {
                psDeleteTemp.getPs().setInt(1, type);
                psDeleteTemp.getPs().execute();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteTemp);
        }
    }

    @Override
    public boolean containsURI(long sessionId, int historyType, String method, String uri, byte[] body) throws DatabaseException {
        SqlPreparedStatementWrapper psContainsURI = null;
        try {
            psContainsURI = DbSQL.getSingleton().getPreparedStatement("history.ps.containsuri");
            psContainsURI.getPs().setString(1, uri);
            psContainsURI.getPs().setString(2, method);
            if (this.bodiesAsBytes) {
                psContainsURI.getPs().setBytes(3, body);
            } else {
                psContainsURI.getPs().setString(3, new String(body));
            }
            psContainsURI.getPs().setLong(4, sessionId);
            psContainsURI.getPs().setInt(5, historyType);
            try (ResultSet rs2 = psContainsURI.getPs().executeQuery();){
                if (rs2.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean rs2 = false;
            return rs2;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psContainsURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecordHistory getHistoryCache(HistoryReference ref, HttpMessage reqMsg) throws DatabaseException, HttpMalformedHeaderException {
        try {
            PreparedStatement psReadCache = null;
            psReadCache = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND " + HISTORYID + " >= ? AND " + HISTORYID + " <= ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND " + HISTORYID + " >= ? AND " + HISTORYID + " <= ? AND SESSIONID = ?)");
            psReadCache.setString(1, reqMsg.getRequestHeader().getURI().toString());
            psReadCache.setString(2, reqMsg.getRequestHeader().getMethod());
            if (this.bodiesAsBytes) {
                psReadCache.setBytes(3, reqMsg.getRequestBody().getBytes());
            } else {
                psReadCache.setString(3, new String(reqMsg.getRequestBody().getBytes()));
            }
            psReadCache.setInt(4, ref.getHistoryId());
            psReadCache.setInt(5, ref.getHistoryId() + 200);
            psReadCache.setLong(6, ref.getSessionId());
            ResultSet rs = psReadCache.executeQuery();
            RecordHistory rec = null;
            try {
                do {
                    if ((rec = this.build(rs)) == null || !rec.getHttpMessage().equals(reqMsg) || rec.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                    RecordHistory recordHistory = rec;
                    return recordHistory;
                } while (rec != null);
            }
            finally {
                try {
                    rs.close();
                    psReadCache.close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
            psReadCache = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ?");
            psReadCache.setString(1, reqMsg.getRequestHeader().getURI().toString());
            psReadCache.setString(2, reqMsg.getRequestHeader().getMethod());
            if (this.bodiesAsBytes) {
                psReadCache.setBytes(3, reqMsg.getRequestBody().getBytes());
            } else {
                psReadCache.setString(3, new String(reqMsg.getRequestBody().getBytes()));
            }
            psReadCache.setLong(4, ref.getSessionId());
            rs = psReadCache.executeQuery();
            rec = null;
            try {
                do {
                    if ((rec = this.build(rs)) == null || !rec.getHttpMessage().equals(reqMsg) || rec.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                    RecordHistory e = rec;
                    return e;
                } while (rec != null);
                return null;
            }
            finally {
                try {
                    rs.close();
                    psReadCache.close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void updateNote(int historyId, String note) throws DatabaseException {
        SqlPreparedStatementWrapper psUpdateNote = null;
        try {
            psUpdateNote = DbSQL.getSingleton().getPreparedStatement("history.ps.updatenote");
            psUpdateNote.getPs().setString(1, note);
            psUpdateNote.getPs().setInt(2, historyId);
            psUpdateNote.getPs().execute();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psUpdateNote);
        }
    }

    @Override
    public int lastIndex() {
        return this.lastInsertedIndex;
    }

    private static interface PreparedStatementSetter {
        public void setParameter(SqlPreparedStatementWrapper var1) throws SQLException;
    }
}

