/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbUtils {
    private static final Logger logger = LogManager.getLogger(DbUtils.class);

    private DbUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTable(Connection connection, String tableName) throws SQLException {
        boolean hasTable = false;
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getTables(null, null, tableName, null);
            if (rs.next()) {
                hasTable = true;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return hasTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasColumn(Connection connection, String tableName, String columnName) throws SQLException {
        boolean hasColumn = false;
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getColumns(null, null, tableName, columnName);
            if (rs.next()) {
                hasColumn = true;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return hasColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasIndex(Connection connection, String tableName, String indexName) throws SQLException {
        boolean hasIndex = false;
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getIndexInfo(null, null, tableName, false, false);
            while (rs.next()) {
                if (!indexName.equals(rs.getString("INDEX_NAME"))) continue;
                hasIndex = true;
                break;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return hasIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getColumnType(Connection connection, String tableName, String columnName) throws SQLException {
        int columnType = -1;
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getColumns(null, null, tableName, columnName);
            if (rs.next()) {
                columnType = rs.getInt("SQL_DATA_TYPE");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return columnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getColumnSize(Connection connection, String tableName, String columnName) throws SQLException {
        int columnSize = -1;
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getColumns(null, null, tableName, columnName);
            if (rs.next()) {
                columnSize = rs.getInt("COLUMN_SIZE");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return columnSize;
    }

    @Deprecated
    public static void executeAndClose(PreparedStatement preparedStatement) throws SQLException {
        try {
            preparedStatement.execute();
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void execute(Connection connection, String sql) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.execute();
        }
    }

    @Deprecated
    public static void executeUpdateAndClose(PreparedStatement preparedStatement) throws SQLException {
        try {
            preparedStatement.executeUpdate();
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void executeUpdate(Connection connection, String sql) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.executeUpdate();
        }
    }
}

