/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.manualrequest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.net.ssl.SSLException;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.manualrequest.MessageSender;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.InvalidMessageDataException;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ZapMenuItem;

@Deprecated
public abstract class ManualRequestEditorDialog
extends AbstractFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(ManualRequestEditorDialog.class);
    private boolean isSendEnabled = true;
    protected String configurationKey;
    private JPanel panelWindow = null;
    private JButton btnSend = null;
    private boolean sending = false;

    public ManualRequestEditorDialog(boolean isSendEnabled, String configurationKey) throws HeadlessException {
        this.isSendEnabled = isSendEnabled;
        this.configurationKey = "view." + configurationKey + ".";
        this.setPreferredSize(DisplayUtils.getScaledDimension(700, 800));
    }

    protected void initialize() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ManualRequestEditorDialog.this.getMessageSender().cleanup();
                ManualRequestEditorDialog.this.saveConfig();
            }
        });
        this.setContentPane(this.getWindowPanel());
    }

    public abstract Class<? extends Message> getMessageType();

    protected abstract MessageSender getMessageSender();

    public abstract ZapMenuItem getMenuItem();

    protected JPanel getWindowPanel() {
        if (this.panelWindow == null) {
            this.panelWindow = new JPanel();
            this.panelWindow.setLayout(new BorderLayout());
            this.panelWindow.add(this.getManualSendPanel());
        }
        return this.panelWindow;
    }

    protected abstract Component getManualSendPanel();

    @Override
    public void setVisible(boolean show) {
        if (!show && this.getMessageSender() != null) {
            this.getMessageSender().cleanup();
        }
        super.setVisible(show);
    }

    public abstract void setDefaultMessage();

    public abstract void setMessage(Message var1);

    public abstract Message getMessage();

    public void clear() {
        this.getRequestPanel().clearView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendButtonTriggered() {
        if (this.sending) {
            return;
        }
        this.sending = true;
        try {
            this.btnSend.setEnabled(false);
            try {
                this.getRequestPanel().saveData();
            }
            catch (InvalidMessageDataException e1) {
                StringBuilder warnMessage = new StringBuilder(150);
                warnMessage.append(Constant.messages.getString("manReq.warn.datainvalid"));
                String exceptionMessage = e1.getLocalizedMessage();
                if (exceptionMessage != null && !exceptionMessage.isEmpty()) {
                    warnMessage.append('\n').append(exceptionMessage);
                }
                View.getSingleton().showWarningDialog((Window)this, warnMessage.toString());
                this.btnSend.setEnabled(true);
                this.sending = false;
                return;
            }
            Control.Mode mode = Control.getSingleton().getMode();
            if (mode.equals((Object)Control.Mode.safe)) {
                View.getSingleton().showWarningDialog((Window)this, Constant.messages.getString("manReq.safe.warning"));
                this.btnSend.setEnabled(true);
                return;
            }
            if (mode.equals((Object)Control.Mode.protect) && !this.getMessage().isInScope()) {
                View.getSingleton().showWarningDialog((Window)this, Constant.messages.getString("manReq.outofscope.warning"));
                this.btnSend.setEnabled(true);
                return;
            }
            this.btnSendAction();
        }
        finally {
            this.sending = false;
        }
    }

    protected JButton getBtnSend() {
        if (this.btnSend == null) {
            this.btnSend = new JButton();
            this.btnSend.setText(Constant.messages.getString("manReq.button.send"));
            this.btnSend.setEnabled(this.isSendEnabled);
            this.btnSend.setMnemonic(10);
            this.btnSend.setToolTipText(ManualRequestEditorDialog.getBtnSendTooltip());
            this.btnSend.addActionListener(e -> this.sendButtonTriggered());
        }
        return this.btnSend;
    }

    protected static String getBtnSendTooltip() {
        return !Constant.isMacOsX() ? Constant.messages.getString("manReq.button.send.tooltip") : Constant.messages.getString("manReq.button.send.tooltip.mac");
    }

    protected abstract void btnSendAction();

    protected void send(final Message aMessage) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ManualRequestEditorDialog.this.getMessageSender().handleSendMessage(aMessage);
                    ManualRequestEditorDialog.this.postSend();
                }
                catch (SSLException sslEx) {
                    StringBuilder strBuilder = new StringBuilder();
                    strBuilder.append(Constant.messages.getString("network.ssl.error.connect"));
                    strBuilder.append(((HttpMessage)aMessage).getRequestHeader().getURI().toString()).append('\n');
                    strBuilder.append(Constant.messages.getString("network.ssl.error.exception")).append(sslEx.getMessage()).append('\n');
                    strBuilder.append(Constant.messages.getString("network.ssl.error.exception.rootcause")).append(ExceptionUtils.getRootCauseMessage((Throwable)sslEx)).append('\n');
                    strBuilder.append(Constant.messages.getString("network.ssl.error.help", Constant.messages.getString("network.ssl.error.help.url")));
                    logger.debug((Object)sslEx, (Throwable)sslEx);
                    View.getSingleton().showWarningDialog((Window)ManualRequestEditorDialog.this, strBuilder.toString());
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    View.getSingleton().showWarningDialog((Window)ManualRequestEditorDialog.this, e.getMessage());
                }
                finally {
                    ManualRequestEditorDialog.this.btnSend.setEnabled(true);
                }
            }
        });
        t.setPriority(5);
        t.start();
    }

    protected void postSend() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManualRequestEditorDialog.this.getRequestPanel().updateContent();
            }
        });
    }

    protected abstract void saveConfig();

    protected abstract HttpPanelRequest getRequestPanel();
}

