/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hsqldb.Server;
import org.parosproxy.paros.db.DatabaseServer;
import org.zaproxy.zap.db.sql.DbSQL;

public class SqlDatabaseServer
implements DatabaseServer {
    public static final int DEFAULT_SERVER_PORT = 9001;
    private static final Logger logger = LogManager.getLogger(SqlDatabaseServer.class);
    private String dbUrl = null;
    private String dbUser = null;
    private String dbPassword = null;
    private Server dbServer = null;
    private Connection dbConn = null;

    SqlDatabaseServer(String dbname) throws ClassNotFoundException, Exception {
        this.start(dbname);
    }

    private void start(String dbname) throws ClassNotFoundException, Exception {
        this.setDbUrl(DbSQL.getSingleton().getDbUrl());
        this.setDbUser(DbSQL.getSingleton().getDbUser());
        this.setDbPassword(DbSQL.getSingleton().getDbPassword());
    }

    void shutdown(boolean compact) throws SQLException {
        if (this.dbConn != null) {
            this.dbConn.close();
            this.dbConn = null;
        }
    }

    public Connection getNewConnection() throws SQLException {
        Connection conn = null;
        for (int i = 0; i < 5; ++i) {
            try {
                conn = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
                return conn;
            }
            catch (SQLException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                if (i == 4) {
                    throw e;
                }
                logger.warn("Recovering {} times", (Object)i);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    logger.debug(e2.getMessage(), (Throwable)e2);
                }
                continue;
            }
        }
        return conn;
    }

    public Connection getSingletonConnection() throws SQLException {
        if (this.dbConn == null) {
            this.dbConn = this.getNewConnection();
        }
        return this.dbConn;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public Server getDbServer() {
        return this.dbServer;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setDbServer(Server dbServer) {
        this.dbServer = dbServer;
    }
}

