/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.ScrollableSizeHint;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.alert.AlertTagsTableModel;
import org.zaproxy.zap.extension.alert.DialogAddAlertTag;
import org.zaproxy.zap.extension.alert.DialogModifyAlertTag;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.model.Vulnerabilities;
import org.zaproxy.zap.model.Vulnerability;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapLabel;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.ZapTable;

public class AlertViewPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(AlertViewPanel.class);
    private static final int UNDEFINED_ID = -1;
    private static final Insets DEFAULT_INSETS = new Insets(1, 1, 1, 1);
    private JScrollPane defaultPane = null;
    private JScrollPane alertPane = null;
    private ZapTextArea defaultOutput = null;
    private JXPanel alertDisplay = null;
    private CardLayout cardLayout = null;
    private ZapLabel alertUrl = null;
    private ZapLabel alertName = null;
    private JLabel alertRisk = null;
    private JLabel alertConfidence = null;
    private ZapLabel alertParam = null;
    private ZapLabel alertAttack = null;
    private ZapLabel alertEvidence = null;
    private ZapLabel alertInputVector;
    private ZapTextArea alertDescription = null;
    private ZapTextArea alertOtherInfo = null;
    private ZapTextArea alertSolution = null;
    private ZapTextArea alertReference = null;
    private ZapTable alertTagsTable = null;
    private AlertTagsTableModel alertTagsTableModel = null;
    private ZapLabel alertCweId = null;
    private ZapLabel alertWascId = null;
    private ZapLabel alertSource;
    private JComboBox<String> alertEditName = null;
    private JComboBox<String> alertEditRisk = null;
    private JComboBox<String> alertEditConfidence = null;
    private JComboBox<String> alertEditParam = null;
    private ZapTextField alertEditAttack = null;
    private ZapTextField alertEditEvidence = null;
    private DefaultComboBoxModel<String> nameListModel = null;
    private DefaultComboBoxModel<String> paramListModel = null;
    private ZapNumberSpinner alertEditCweId = null;
    private ZapNumberSpinner alertEditWascId = null;
    private JLabel attackLabel;
    private JLabel cweidLabel;
    private JLabel evidenceLabel;
    private JLabel inputVectorLabel;
    private JLabel otherLabel;
    private JLabel confidenceLabel;
    private JLabel riskLabel;
    private JLabel sourceLabel;
    private JLabel urlLabel;
    private JLabel wascidLabel;
    private DialogAddAlertTag dialogAddAlertTag;
    private DialogModifyAlertTag dialogModifyAlertTag;
    private boolean editable = false;
    private Alert originalAlert = null;
    private List<Vulnerability> vulnerabilities = null;
    private HistoryReference historyRef = null;
    private HttpMessage httpMessage;

    public AlertViewPanel() {
        this(false);
    }

    public AlertViewPanel(boolean editable) {
        this.editable = editable;
        this.initialize();
    }

    private void initialize() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.setName("AlertView");
        if (!this.editable) {
            this.add((Component)this.getDefaultPane(), this.getDefaultPane().getName());
        }
        this.add((Component)this.getAlertPane(), this.getAlertPane().getName());
    }

    private JScrollPane getAlertPane() {
        if (this.alertPane == null) {
            this.alertPane = new JScrollPane();
            this.alertPane.setHorizontalScrollBarPolicy(31);
            this.alertPane.setViewportView(this.getAlertDisplay());
            this.alertPane.setName("alertPane");
        }
        return this.alertPane;
    }

    private ZapTextArea createZapTextArea() {
        ZapTextArea ZapTextArea2 = new ZapTextArea(3, 30);
        ZapTextArea2.setLineWrap(true);
        ZapTextArea2.setWrapStyleWord(true);
        ZapTextArea2.setEditable(this.editable);
        return ZapTextArea2;
    }

    private JScrollPane createJScrollPane(String name) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(null, name, 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
        return jScrollPane;
    }

    private JPanel getAlertDisplay() {
        if (this.alertDisplay == null) {
            this.alertDisplay = new JXPanel();
            this.alertDisplay.setLayout((LayoutManager)new GridBagLayout());
            this.alertDisplay.setScrollableHeightHint(ScrollableSizeHint.NONE);
            this.alertDisplay.setName("alertDisplay");
            this.alertEditName = new JComboBox();
            this.alertEditName.setEditable(true);
            this.nameListModel = new DefaultComboBoxModel();
            List<String> allVulns = this.getAllVulnerabilityNames();
            this.nameListModel.addElement("");
            for (String vuln : allVulns) {
                this.nameListModel.addElement(vuln);
            }
            this.alertEditName.setModel(this.nameListModel);
            this.alertEditName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vulnerability v;
                    if ("comboBoxChanged".equals(e.getActionCommand()) && (v = AlertViewPanel.this.getVulnerability((String)AlertViewPanel.this.alertEditName.getSelectedItem())) != null) {
                        if (v.getDescription() != null && v.getDescription().length() > 0) {
                            AlertViewPanel.this.setAlertDescription(v.getDescription());
                        }
                        if (v.getSolution() != null && v.getSolution().length() > 0) {
                            AlertViewPanel.this.setAlertSolution(v.getSolution());
                        }
                        if (v.getReferences() != null) {
                            StringBuilder sb = new StringBuilder();
                            for (String ref : v.getReferences()) {
                                sb.append(ref);
                                sb.append('\n');
                            }
                            AlertViewPanel.this.setAlertReference(sb.toString());
                        }
                        AlertViewPanel.this.alertEditWascId.setValue(v.getWascId());
                    }
                }
            });
            this.alertEditRisk = new JComboBox<String>(Alert.MSG_RISK);
            this.alertEditConfidence = new JComboBox<String>(Alert.MSG_CONFIDENCE);
            this.alertEditConfidence.setSelectedItem(Alert.MSG_CONFIDENCE[2]);
            this.alertEditAttack = new ZapTextField();
            this.paramListModel = new DefaultComboBoxModel();
            this.paramListModel.addElement("");
            this.alertEditParam = new JComboBox();
            this.alertEditParam.setModel(this.paramListModel);
            this.alertEditParam.setEditable(true);
            this.alertEditEvidence = new ZapTextField();
            this.alertEditCweId = new ZapNumberSpinner();
            if (this.alertEditCweId.getEditor() instanceof JSpinner.DefaultEditor) {
                ((JSpinner.DefaultEditor)this.alertEditCweId.getEditor()).getTextField().setHorizontalAlignment(2);
            }
            this.alertEditWascId = new ZapNumberSpinner();
            if (this.alertEditWascId.getEditor() instanceof JSpinner.DefaultEditor) {
                ((JSpinner.DefaultEditor)this.alertEditWascId.getEditor()).getTextField().setHorizontalAlignment(2);
            }
            this.alertName = new ZapLabel();
            this.alertName.setFont(FontUtils.getFont(1));
            this.alertName.setLineWrap(true);
            this.alertRisk = new JLabel();
            this.alertConfidence = new JLabel();
            this.alertParam = new ZapLabel();
            this.alertParam.setLineWrap(true);
            this.alertAttack = new ZapLabel();
            this.alertAttack.setLineWrap(true);
            this.alertEvidence = new ZapLabel();
            this.alertEvidence.setLineWrap(true);
            this.alertInputVector = new ZapLabel();
            this.alertInputVector.setLineWrap(true);
            this.alertCweId = new ZapLabel();
            this.alertWascId = new ZapLabel();
            this.alertSource = new ZapLabel();
            this.alertSource.setLineWrap(true);
            this.alertUrl = new ZapLabel();
            this.alertUrl.setLineWrap(true);
            this.alertDescription = this.createZapTextArea();
            JScrollPane descSp = this.createJScrollPane(Constant.messages.getString("alert.label.desc"));
            descSp.setViewportView(this.alertDescription);
            this.alertDescription.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 9) {
                        AlertViewPanel.this.alertDescription.transferFocus();
                    }
                }
            });
            this.alertOtherInfo = this.createZapTextArea();
            JScrollPane otherSp = this.createJScrollPane(Constant.messages.getString("alert.label.other"));
            otherSp.setViewportView(this.alertOtherInfo);
            this.alertOtherInfo.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 9) {
                        AlertViewPanel.this.alertOtherInfo.transferFocus();
                    }
                }
            });
            this.alertSolution = this.createZapTextArea();
            JScrollPane solutionSp = this.createJScrollPane(Constant.messages.getString("alert.label.solution"));
            solutionSp.setViewportView(this.alertSolution);
            this.alertSolution.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 9) {
                        AlertViewPanel.this.alertSolution.transferFocus();
                    }
                }
            });
            this.alertReference = this.createZapTextArea();
            JScrollPane referenceSp = this.createJScrollPane(Constant.messages.getString("alert.label.ref"));
            referenceSp.setViewportView(this.alertReference);
            this.alertReference.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 9) {
                        AlertViewPanel.this.alertReference.transferFocus();
                    }
                }
            });
            int gbcRow = 0;
            this.alertDisplay.add(this.editable ? this.alertEditName : this.alertName, (Object)LayoutHelper.getGBC(0, gbcRow, 2, 0.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.getUrlLabel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.alertUrl, (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.getRiskLabel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, DEFAULT_INSETS));
            this.alertDisplay.add(this.editable ? this.alertEditRisk : this.alertRisk, (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.getConfidenceLabel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, DEFAULT_INSETS));
            this.alertDisplay.add(this.editable ? this.alertEditConfidence : this.alertConfidence, (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.getParameterLabel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, DEFAULT_INSETS));
            this.alertDisplay.add(this.editable ? this.alertEditParam : this.alertParam, (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.getAttackLabel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)(this.editable ? this.alertEditAttack : this.alertAttack), (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.getEvidenceLabel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)(this.editable ? this.alertEditEvidence : this.alertEvidence), (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.getCweidLabel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)(this.editable ? this.alertEditCweId : this.alertCweId), (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.getWascidLabel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, DEFAULT_INSETS));
            this.alertDisplay.add((Component)(this.editable ? this.alertEditWascId : this.alertWascId), (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
            ++gbcRow;
            if (!this.editable) {
                this.alertDisplay.add((Component)this.getSourceLabel(), (Object)LayoutHelper.getGBC(0, gbcRow, 1, 0.0, DEFAULT_INSETS));
                this.alertDisplay.add((Component)this.alertSource, (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
                this.alertDisplay.add((Component)this.getInputVectorLabel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 1, 0.0, DEFAULT_INSETS));
                this.alertDisplay.add((Component)this.alertInputVector, (Object)LayoutHelper.getGBC(1, gbcRow, 1, 1.0, DEFAULT_INSETS));
                ++gbcRow;
            }
            this.alertDisplay.add((Component)descSp, (Object)LayoutHelper.getGBC(0, gbcRow, 2, 1.0, 1.0, 1, DEFAULT_INSETS));
            this.alertDisplay.add((Component)otherSp, (Object)LayoutHelper.getGBC(0, ++gbcRow, 2, 1.0, 1.0, 1, DEFAULT_INSETS));
            this.alertDisplay.add((Component)solutionSp, (Object)LayoutHelper.getGBC(0, ++gbcRow, 2, 1.0, 1.0, 1, DEFAULT_INSETS));
            this.alertDisplay.add((Component)referenceSp, (Object)LayoutHelper.getGBC(0, ++gbcRow, 2, 1.0, 1.0, 1, DEFAULT_INSETS));
            this.alertDisplay.add((Component)this.createAlertTagsPanel(), (Object)LayoutHelper.getGBC(0, ++gbcRow, 2, 1.0, 1.0, 1, DEFAULT_INSETS));
        }
        return this.alertDisplay;
    }

    private JPanel createAlertTagsPanel() {
        JXPanel alertTagsPanel = new JXPanel((LayoutManager)new BorderLayout());
        alertTagsPanel.setName("Alert Tags Panel");
        alertTagsPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("alert.label.tags"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
        this.alertTagsTableModel = new AlertTagsTableModel();
        this.alertTagsTable = new ZapTable(this.alertTagsTableModel);
        this.alertTagsTable.setPreferredScrollableViewportSize(new Dimension(this.alertTagsTable.getPreferredSize().width, this.alertTagsTable.getRowHeight() * 5));
        if (!this.editable) {
            this.alertTagsTable.setCellSelectionEnabled(true);
        }
        JScrollPane alertTagsSp = new JScrollPane();
        alertTagsSp.setHorizontalScrollBarPolicy(31);
        alertTagsSp.setVerticalScrollBarPolicy(20);
        alertTagsSp.setViewportView((Component)((Object)this.alertTagsTable));
        alertTagsSp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9) {
                    AlertViewPanel.this.alertTagsTable.transferFocus();
                }
            }
        });
        if (this.editable) {
            JToolBar alertTagsToolBar = new JToolBar();
            alertTagsToolBar.setEnabled(true);
            alertTagsToolBar.setFloatable(false);
            alertTagsToolBar.setRollover(true);
            alertTagsToolBar.setName("Alert Tags Editing Toolbar");
            JButton addTagButton = new JButton();
            addTagButton.setToolTipText(Constant.messages.getString("alert.tags.button.add"));
            addTagButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(AlertViewPanel.class.getResource("/resource/icon/16/103.png"))));
            addTagButton.addActionListener(e -> this.showAddAlertTagDialogue());
            alertTagsToolBar.add(addTagButton);
            JButton deleteTagButton = new JButton();
            deleteTagButton.setToolTipText(Constant.messages.getString("alert.tags.button.delete"));
            deleteTagButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(AlertViewPanel.class.getResource("/resource/icon/16/104.png"))));
            deleteTagButton.addActionListener(e -> this.alertTagsTableModel.deleteTags(this.alertTagsTable.getSelectedRows()));
            deleteTagButton.setEnabled(false);
            alertTagsToolBar.add(deleteTagButton);
            JButton editTagButton = new JButton();
            editTagButton.setToolTipText(Constant.messages.getString("alert.tags.button.modify"));
            editTagButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(AlertViewPanel.class.getResource("/resource/icon/16/018.png"))));
            editTagButton.addActionListener(e -> this.showModifyAlertTagDialogue());
            editTagButton.setEnabled(false);
            alertTagsToolBar.add(editTagButton);
            this.alertTagsTable.getSelectionModel().addListSelectionListener(e -> {
                if (this.alertTagsTable.getSelectedRow() == -1) {
                    deleteTagButton.setEnabled(false);
                    editTagButton.setEnabled(false);
                    return;
                }
                if (!deleteTagButton.isEnabled()) {
                    deleteTagButton.setEnabled(true);
                }
                if (!editTagButton.isEnabled()) {
                    editTagButton.setEnabled(true);
                }
            });
            this.alertTagsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JTable table = (JTable)e.getSource();
                    if (e.getClickCount() == 2 && table.getSelectedRow() != -1) {
                        AlertViewPanel.this.showModifyAlertTagDialogue();
                    }
                }
            });
            alertTagsPanel.add((Component)alertTagsToolBar, "First");
        }
        alertTagsPanel.add((Component)alertTagsSp, "Center");
        return alertTagsPanel;
    }

    public void displayAlert(Alert alert) {
        this.originalAlert = alert;
        this.alertUrl.setText(alert.getUri());
        if (this.editable) {
            this.nameListModel.addElement(alert.getName());
            this.alertEditName.setSelectedItem(alert.getName());
            this.alertEditRisk.setSelectedItem(Alert.MSG_RISK[alert.getRisk()]);
            this.alertEditConfidence.setSelectedItem(Alert.MSG_CONFIDENCE[alert.getConfidence()]);
            this.alertEditParam.setSelectedItem(alert.getParam());
            this.alertEditAttack.setText(alert.getAttack());
            this.alertEditAttack.discardAllEdits();
            this.alertEditEvidence.setText(alert.getEvidence());
            this.alertEditEvidence.discardAllEdits();
            this.alertEditCweId.setValue(alert.getCweId());
            this.alertEditWascId.setValue(alert.getWascId());
        } else {
            this.alertName.setText(alert.getName());
            this.alertRisk.setText(Alert.MSG_RISK[alert.getRisk()]);
            this.alertRisk.setIcon(alert.getIcon());
            this.alertConfidence.setText(Alert.MSG_CONFIDENCE[alert.getConfidence()]);
            this.alertParam.setText(alert.getParam());
            this.alertAttack.setText(alert.getAttack());
            this.alertEvidence.setText(alert.getEvidence());
            this.alertInputVector.setText(AlertViewPanel.getInputVectorName(alert));
            this.alertCweId.setText(AlertViewPanel.normalisedId(alert.getCweId()));
            this.alertWascId.setText(AlertViewPanel.normalisedId(alert.getWascId()));
            this.alertSource.setText(this.getSourceData(alert));
        }
        this.setAlertDescription(alert.getDescription());
        this.setAlertOtherInfo(alert.getOtherInfo());
        this.setAlertSolution(alert.getSolution());
        this.setAlertReference(alert.getReference());
        this.setAlertTags(alert.getTags());
        this.cardLayout.show(this, this.getAlertPane().getName());
    }

    private static String normalisedId(int id) {
        return id != -1 ? Integer.toString(id) : "";
    }

    private String getSourceData(Alert alert) {
        PluginPassiveScanner scanner;
        ExtensionPassiveScan ext;
        String source = Constant.messages.getString(alert.getSource().getI18nKey());
        if (alert.getPluginId() == -1) {
            return source;
        }
        StringBuilder strBuilder = new StringBuilder(source);
        strBuilder.append(" (").append(alert.getPluginId());
        if (alert.getSource() == Alert.Source.ACTIVE) {
            Plugin plugin = PluginFactory.getLoadedPlugin(alert.getPluginId());
            if (plugin != null) {
                strBuilder.append(" - ").append(plugin.getName());
            }
        } else if (alert.getSource() == Alert.Source.PASSIVE && (ext = Control.getSingleton().getExtensionLoader().getExtension(ExtensionPassiveScan.class)) != null && (scanner = ext.getPluginPassiveScanner(alert.getPluginId())) != null) {
            strBuilder.append(" - ").append(scanner.getName());
        }
        strBuilder.append(')');
        return strBuilder.toString();
    }

    private static String getInputVectorName(Alert alert) {
        String inputVector = alert.getInputVector();
        if (inputVector.isEmpty()) {
            return "";
        }
        String key = "variant.shortname." + inputVector;
        if (Constant.messages.containsKey(key)) {
            return Constant.messages.getString(key);
        }
        return inputVector;
    }

    public void clearAlert() {
        this.cardLayout.show(this, this.getDefaultPane().getName());
        this.originalAlert = null;
        this.historyRef = null;
        this.httpMessage = null;
        this.alertName.setText("");
        this.alertRisk.setText("");
        this.alertConfidence.setText("");
        this.alertParam.setText("");
        this.alertAttack.setText("");
        this.alertDescription.setText("");
        this.alertOtherInfo.setText("");
        this.alertSolution.setText("");
        this.alertReference.setText("");
        this.alertSource.setText("");
        this.alertInputVector.setText("");
        this.setAlertTags(Collections.emptyMap());
        if (this.editable) {
            this.alertEditAttack.setText("");
            this.alertEditAttack.discardAllEdits();
            this.alertEditEvidence.setText("");
            this.alertEditEvidence.discardAllEdits();
            this.alertDescription.discardAllEdits();
            this.alertOtherInfo.discardAllEdits();
            this.alertSolution.discardAllEdits();
            this.alertReference.discardAllEdits();
        }
    }

    private JScrollPane getDefaultPane() {
        if (this.defaultPane == null) {
            this.defaultPane = new JScrollPane();
            this.defaultPane.setViewportView(this.getDefaultOutput());
            this.defaultPane.setName("defaultPane");
            this.defaultPane.setHorizontalScrollBarPolicy(31);
        }
        return this.defaultPane;
    }

    private ZapTextArea getDefaultOutput() {
        if (this.defaultOutput == null) {
            this.defaultOutput = new ZapTextArea();
            this.defaultOutput.setEditable(false);
            this.defaultOutput.setLineWrap(true);
            this.defaultOutput.setName("");
            this.defaultOutput.append(Constant.messages.getString("alerts.label.defaultMessage"));
        }
        return this.defaultOutput;
    }

    public void append(final String msg) {
        if (EventQueue.isDispatchThread()) {
            this.getDefaultOutput().append(msg);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AlertViewPanel.this.getDefaultOutput().append(msg);
                }
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void clear() {
        this.getDefaultOutput().setText("");
    }

    public void setParamNames(String[] paramNames) {
        for (String param : paramNames) {
            this.paramListModel.addElement(param);
        }
    }

    public Alert getAlert() {
        if (!this.editable && this.originalAlert != null) {
            Alert alert = this.originalAlert.newInstance();
            alert.setAlertId(this.originalAlert.getAlertId());
            alert.setName((String)this.alertEditName.getSelectedItem());
            alert.setParam((String)this.alertEditParam.getSelectedItem());
            alert.setRiskConfidence(this.alertEditRisk.getSelectedIndex(), this.alertEditConfidence.getSelectedIndex());
            alert.setDescription(this.alertDescription.getText());
            alert.setOtherInfo(this.alertOtherInfo.getText());
            alert.setSolution(this.alertSolution.getText());
            alert.setReference(this.alertReference.getText());
            alert.setEvidence(this.alertEvidence.getText());
            alert.setInputVector(this.originalAlert.getInputVector());
            alert.setCweId(this.alertEditCweId.getValue());
            alert.setWascId(this.alertEditWascId.getValue());
            alert.setHistoryRef(this.historyRef);
            alert.setTags(this.getAlertTags());
            return alert;
        }
        Alert alert = new Alert(-1, this.alertEditRisk.getSelectedIndex(), this.alertEditConfidence.getSelectedIndex(), (String)this.alertEditName.getSelectedItem());
        alert.setHistoryRef(this.historyRef);
        if (this.originalAlert != null) {
            alert.setAlertId(this.originalAlert.getAlertId());
            alert.setSource(this.originalAlert.getSource());
            alert.setInputVector(this.originalAlert.getInputVector());
        }
        String uri = null;
        HttpMessage msg = null;
        if (this.httpMessage != null) {
            uri = this.httpMessage.getRequestHeader().getURI().toString();
            msg = this.httpMessage;
        } else if (this.historyRef != null) {
            try {
                uri = this.historyRef.getURI().toString();
                msg = this.historyRef.getHttpMessage();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (this.originalAlert != null) {
            uri = this.originalAlert.getUri();
            msg = this.originalAlert.getMessage();
        }
        alert.setDetail(this.alertDescription.getText(), uri, (String)this.alertEditParam.getSelectedItem(), this.alertEditAttack.getText(), this.alertOtherInfo.getText(), this.alertSolution.getText(), this.alertReference.getText(), this.alertEditEvidence.getText(), this.alertEditCweId.getValue(), this.alertEditWascId.getValue(), msg);
        alert.setTags(this.getAlertTags());
        return alert;
    }

    public Alert getOriginalAlert() {
        return this.originalAlert;
    }

    public void setHistoryRef(HistoryReference historyRef) {
        this.historyRef = historyRef;
        this.httpMessage = null;
        try {
            if (historyRef != null) {
                HttpMessage msg = historyRef.getHttpMessage();
                this.setParamNames(msg.getParamNames());
                this.alertUrl.setText(msg.getRequestHeader().getURI().toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setHttpMessage(HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.setParamNames(httpMessage.getParamNames());
        this.alertUrl.setText(httpMessage.getRequestHeader().getURI().toString());
        this.historyRef = null;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private List<Vulnerability> getAllVulnerabilities() {
        if (this.vulnerabilities == null) {
            this.vulnerabilities = Vulnerabilities.getAllVulnerabilities();
        }
        return this.vulnerabilities;
    }

    private Vulnerability getVulnerability(String alert) {
        if (alert == null) {
            return null;
        }
        List<Vulnerability> vulns = this.getAllVulnerabilities();
        for (Vulnerability v : vulns) {
            if (!alert.equals(v.getAlert())) continue;
            return v;
        }
        return null;
    }

    private List<String> getAllVulnerabilityNames() {
        List<Vulnerability> vulns = this.getAllVulnerabilities();
        ArrayList<String> names = new ArrayList<String>(vulns.size());
        for (Vulnerability v : vulns) {
            names.add(v.getAlert());
        }
        Collections.sort(names);
        return names;
    }

    private void setAlertDescription(String description) {
        AlertViewPanel.setTextDiscardEditsAndInitCaretPosition(this.alertDescription, description);
    }

    private void setAlertOtherInfo(String otherInfo) {
        AlertViewPanel.setTextDiscardEditsAndInitCaretPosition(this.alertOtherInfo, otherInfo);
    }

    private void setAlertSolution(String solution) {
        AlertViewPanel.setTextDiscardEditsAndInitCaretPosition(this.alertSolution, solution);
    }

    private void setAlertReference(String reference) {
        AlertViewPanel.setTextDiscardEditsAndInitCaretPosition(this.alertReference, reference);
    }

    private static void setTextDiscardEditsAndInitCaretPosition(ZapTextArea textArea, String text) {
        textArea.setText(text);
        textArea.discardAllEdits();
        textArea.setCaretPosition(0);
    }

    private void setAlertTags(Map<String, String> tags) {
        this.alertTagsTableModel.setTags(tags);
    }

    private Map<String, String> getAlertTags() {
        return this.alertTagsTableModel.getTags();
    }

    private JLabel getAttackLabel() {
        if (this.attackLabel == null) {
            this.attackLabel = new JLabel(Constant.messages.getString("alert.label.attack"));
        }
        return this.attackLabel;
    }

    private JLabel getCweidLabel() {
        if (this.cweidLabel == null) {
            this.cweidLabel = new JLabel(Constant.messages.getString("alert.label.cweid"));
        }
        return this.cweidLabel;
    }

    private JLabel getEvidenceLabel() {
        if (this.evidenceLabel == null) {
            this.evidenceLabel = new JLabel(Constant.messages.getString("alert.label.evidence"));
        }
        return this.evidenceLabel;
    }

    private JLabel getInputVectorLabel() {
        if (this.inputVectorLabel == null) {
            this.inputVectorLabel = new JLabel(Constant.messages.getString("alert.label.inputvector"));
        }
        return this.inputVectorLabel;
    }

    private JLabel getParameterLabel() {
        if (this.otherLabel == null) {
            this.otherLabel = new JLabel(Constant.messages.getString("alert.label.parameter"));
        }
        return this.otherLabel;
    }

    private JLabel getConfidenceLabel() {
        if (this.confidenceLabel == null) {
            this.confidenceLabel = new JLabel(Constant.messages.getString("alert.label.confidence"));
        }
        return this.confidenceLabel;
    }

    private JLabel getRiskLabel() {
        if (this.riskLabel == null) {
            this.riskLabel = new JLabel(Constant.messages.getString("alert.label.risk"));
        }
        return this.riskLabel;
    }

    private JLabel getSourceLabel() {
        if (this.sourceLabel == null) {
            this.sourceLabel = new JLabel(Constant.messages.getString("alert.label.source"));
        }
        return this.sourceLabel;
    }

    private JLabel getUrlLabel() {
        if (this.urlLabel == null) {
            this.urlLabel = new JLabel(Constant.messages.getString("alert.label.url"));
        }
        return this.urlLabel;
    }

    private JLabel getWascidLabel() {
        if (this.wascidLabel == null) {
            this.wascidLabel = new JLabel(Constant.messages.getString("alert.label.wascid"));
        }
        return this.wascidLabel;
    }

    private void showAddAlertTagDialogue() {
        if (this.dialogAddAlertTag == null) {
            this.dialogAddAlertTag = new DialogAddAlertTag((Dialog)Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class).getDialogAlertAdd(), this.alertTagsTableModel);
            this.dialogAddAlertTag.pack();
        }
        this.dialogAddAlertTag.clearFields();
        this.dialogAddAlertTag.setVisible(true);
    }

    private void showModifyAlertTagDialogue() {
        int selectedRow;
        if (this.dialogModifyAlertTag == null) {
            this.dialogModifyAlertTag = new DialogModifyAlertTag((Dialog)Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class).getDialogAlertAdd(), this.alertTagsTableModel);
            this.dialogModifyAlertTag.pack();
        }
        if ((selectedRow = this.alertTagsTable.getSelectedRow()) != -1) {
            this.dialogModifyAlertTag.setTagRowInAlertTagsTable(selectedRow);
            this.dialogModifyAlertTag.setVisible(true);
        }
    }
}

