/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiParameter;
import org.zaproxy.zap.extension.api.ApiPersistentConnection;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.OptionsParamApi;

public class WebUI {
    private API api;
    private boolean isDevTestNonce = false;

    public WebUI(API api) {
        this.api = api;
    }

    private ApiElement getElement(ApiImplementor impl, String name, API.RequestType reqType) throws ApiException {
        if (API.RequestType.action.equals((Object)reqType) && name != null) {
            List<ApiAction> actionList = impl.getApiActions();
            ApiAction action = null;
            for (ApiAction act : actionList) {
                if (!name.equals(act.getName())) continue;
                action = act;
                break;
            }
            if (action == null) {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
            return action;
        }
        if (API.RequestType.other.equals((Object)reqType) && name != null) {
            List<ApiOther> otherList = impl.getApiOthers();
            ApiOther other = null;
            for (ApiOther oth : otherList) {
                if (!name.equals(oth.getName())) continue;
                other = oth;
                break;
            }
            if (other == null) {
                throw new ApiException(ApiException.Type.BAD_OTHER);
            }
            return other;
        }
        if (API.RequestType.view.equals((Object)reqType) && name != null) {
            List<ApiView> viewList = impl.getApiViews();
            ApiView view = null;
            for (ApiView v : viewList) {
                if (!name.equals(v.getName())) continue;
                view = v;
                break;
            }
            if (view == null) {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
            return view;
        }
        if (API.RequestType.pconn.equals((Object)reqType) && name != null) {
            List<ApiPersistentConnection> pconnList = impl.getApiPersistentConnections();
            ApiPersistentConnection pconn = null;
            for (ApiPersistentConnection pc : pconnList) {
                if (!name.equals(pc.getName())) continue;
                pconn = pc;
                break;
            }
            if (pconn == null) {
                throw new ApiException(ApiException.Type.BAD_PCONN);
            }
            return pconn;
        }
        throw new ApiException(ApiException.Type.BAD_TYPE);
    }

    private void appendElements(StringBuilder sb, String component, String type, List<ApiElement> elementList) {
        Collections.sort(elementList, new Comparator<ApiElement>(){

            @Override
            public int compare(ApiElement ae1, ApiElement ae2) {
                return ae1.getName().compareTo(ae2.getName());
            }
        });
        sb.append("\n<table>\n");
        for (ApiElement element : elementList) {
            String descTag;
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("<a href=\"/");
            sb.append(API.Format.UI.name());
            sb.append('/');
            sb.append(component);
            sb.append('/');
            sb.append(type);
            sb.append('/');
            sb.append(element.getName());
            sb.append("/\">");
            sb.append(element.getName());
            if (!element.getParameters().isEmpty()) {
                sb.append(" (");
                for (ApiParameter parameter : element.getParameters()) {
                    sb.append(parameter.getName());
                    if (parameter.isRequired()) {
                        sb.append('*');
                    }
                    sb.append(' ');
                }
                sb.append(") ");
            }
            sb.append("</a>");
            sb.append("</td><td>");
            if (element.isDeprecated()) {
                sb.append(Constant.messages.getString("api.html.deprecated.endpoint"));
                sb.append("<br />");
                String text = element.getDeprecatedDescription();
                if (text != null && !text.isEmpty()) {
                    sb.append(text);
                    sb.append("<br />");
                }
            }
            if (Constant.messages.containsKey(descTag = element.getDescriptionTag())) {
                sb.append(Constant.messages.getString(descTag));
            }
            sb.append("</td>");
            sb.append("</tr>\n");
        }
        sb.append("</table>\n");
    }

    private void appendShortcuts(StringBuilder sb, String component, List<String> shortcutList) {
        Collections.sort(shortcutList);
        sb.append("\n<table>\n");
        for (String shortcut : shortcutList) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("<a href=\"/");
            sb.append(shortcut);
            sb.append("/?");
            sb.append("apinonce");
            sb.append("=");
            sb.append(this.api.getOneTimeNonce("/" + shortcut + "/"));
            sb.append("\">");
            sb.append(shortcut);
            sb.append("</a>");
            sb.append("</td><td>");
            sb.append("</td>");
            sb.append("</tr>\n");
        }
        sb.append("</table>\n");
    }

    public String handleRequest(String component, ApiImplementor impl, API.RequestType reqType, String name) throws ApiException {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>\n");
        sb.append("<head>\n");
        sb.append("<title>");
        sb.append(Constant.messages.getString("api.html.title"));
        sb.append("</title>\n");
        sb.append("<script src=\"/script.js/?v=2&apinonce=" + this.api.getOneTimeNonce("/script.js/") + "\" type=\"text/javascript\"></script>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("<h1>");
        sb.append("<a href=\"/");
        sb.append(API.Format.UI.name());
        sb.append("/\">");
        sb.append(Constant.messages.getString("api.html.title"));
        sb.append("</a>");
        sb.append("</h1>\n");
        if (impl != null) {
            sb.append("<h2>");
            sb.append("<a href=\"/");
            sb.append(API.Format.UI.name());
            sb.append("/");
            sb.append(component);
            sb.append("/\">");
            sb.append(Constant.messages.getString("api.html.component"));
            sb.append(component);
            sb.append("</a>");
            sb.append("</h2>\n");
            if (name != null) {
                ApiElement element = this.getElement(impl, name, reqType);
                sb.append("<h3>");
                sb.append(Constant.messages.getString("api.html." + reqType.name()));
                sb.append(element.getName());
                sb.append("</h3>\n");
                String descTag = element.getDescriptionTag();
                if (Constant.messages.containsKey(descTag)) {
                    sb.append(Constant.messages.getString(descTag));
                }
                sb.append("\n<form id=\"zapform\" name=\"zapform\" action=\"override\">");
                sb.append("<table>\n");
                if (!API.RequestType.other.equals((Object)reqType)) {
                    sb.append("<tr><td>");
                    sb.append(Constant.messages.getString("api.html.format"));
                    sb.append("</td><td>\n");
                    sb.append("<select id=\"zapapiformat\">\n");
                    sb.append("<option value=\"JSON\">JSON</option>\n");
                    if (this.getOptionsParamApi().isEnableJSONP()) {
                        sb.append("<option value=\"JSONP\">JSONP</option>\n");
                    } else {
                        sb.append("<option value=\"JSONP\" disabled>JSONP</option>\n");
                    }
                    sb.append("<option value=\"HTML\">HTML</option>\n");
                    sb.append("<option value=\"XML\">XML</option>\n");
                    sb.append("</select>\n");
                    sb.append("</td>");
                    sb.append("<td></td>");
                    sb.append("</tr>\n");
                }
                if (API.RequestType.action.equals((Object)reqType) || API.RequestType.other.equals((Object)reqType) || !this.getOptionsParamApi().isNoKeyForSafeOps()) {
                    String keyType = "apikey";
                    if (this.isDevTestNonce && API.RequestType.other.equals((Object)reqType)) {
                        keyType = "apinonce";
                    }
                    if (!this.getOptionsParamApi().isDisableKey()) {
                        sb.append("<tr>");
                        sb.append("<td>");
                        sb.append(keyType);
                        sb.append("*</td>");
                        sb.append("<td>");
                        sb.append("<input id=\"");
                        sb.append(keyType);
                        sb.append("\" name=\"");
                        sb.append(keyType);
                        sb.append("\" value=\"");
                        if (this.isDevTestNonce && API.RequestType.other.equals((Object)reqType)) {
                            sb.append(this.api.getOneTimeNonce("/" + reqType.name().toUpperCase(Locale.ROOT) + "/" + impl.getPrefix() + "/" + reqType.name() + "/" + element.getName() + "/"));
                        } else if (this.getOptionsParamApi().isAutofillKey()) {
                            sb.append(this.getOptionsParamApi().getKey());
                        }
                        sb.append("\"/>");
                        sb.append("</td>");
                        sb.append("<td></td>");
                        sb.append("</tr>\n");
                    }
                    sb.append("<tr>");
                    sb.append("<td>");
                    sb.append(Constant.messages.getString("api.html.formMethod"));
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append("<select id=\"formMethod\">\n");
                    sb.append("<option value=\"GET\" selected>GET</option>\n");
                    sb.append("<option value=\"POST\">POST</option>\n");
                    sb.append("</select>\n");
                    sb.append("</td>");
                    sb.append("<td></td>");
                    sb.append("</tr>\n");
                }
                WebUI.appendParams(sb, element.getParameters());
                sb.append("<tr>");
                sb.append("<td>");
                sb.append("</td>");
                sb.append("<td>");
                sb.append("<input id=\"button\" value=\"");
                sb.append(element.getName());
                sb.append("\" type=\"submit\" zap-component=\"" + component + "\" zap-type=\"" + reqType + "\" zap-name=\"" + name + "\"/>\n");
                sb.append("</td>");
                sb.append("<td></td>");
                sb.append("</tr>\n");
                sb.append("</table>\n");
                sb.append("</form>\n");
            } else {
                List<String> shortcutList;
                List<ApiPersistentConnection> pconnList;
                List<ApiOther> otherList;
                List<ApiAction> actionList;
                if (Constant.messages.containsKey(impl.getDescriptionKey())) {
                    sb.append("<p>\n");
                    sb.append(Constant.messages.getString(impl.getDescriptionKey()));
                    sb.append("\n</p>\n");
                }
                ArrayList<ApiElement> elementList = new ArrayList<ApiElement>();
                List<ApiView> viewList = impl.getApiViews();
                if (viewList != null && viewList.size() > 0) {
                    sb.append("<h3>");
                    sb.append(Constant.messages.getString("api.html.views"));
                    sb.append("</h3>\n");
                    elementList.addAll(viewList);
                    this.appendElements(sb, component, API.RequestType.view.name(), elementList);
                }
                if ((actionList = impl.getApiActions()) != null && actionList.size() > 0) {
                    sb.append("<h3>");
                    sb.append(Constant.messages.getString("api.html.actions"));
                    sb.append("</h3>\n");
                    elementList = new ArrayList();
                    elementList.addAll(actionList);
                    this.appendElements(sb, component, API.RequestType.action.name(), elementList);
                }
                if ((otherList = impl.getApiOthers()) != null && otherList.size() > 0) {
                    sb.append("<h3>");
                    sb.append(Constant.messages.getString("api.html.others"));
                    sb.append("</h3>\n");
                    elementList = new ArrayList();
                    elementList.addAll(otherList);
                    this.appendElements(sb, component, API.RequestType.other.name(), elementList);
                }
                if ((pconnList = impl.getApiPersistentConnections()) != null && pconnList.size() > 0) {
                    sb.append("<h3>");
                    sb.append(Constant.messages.getString("api.html.pconns"));
                    sb.append("</h3>\n");
                    elementList = new ArrayList();
                    elementList.addAll(pconnList);
                    this.appendElements(sb, component, API.RequestType.pconn.name(), elementList);
                }
                if ((this.getOptionsParamApi().isDisableKey() || this.getOptionsParamApi().isAutofillKey() || this.isDevTestNonce) && (shortcutList = impl.getApiShortcuts()) != null && shortcutList.size() > 0) {
                    sb.append("<h3>");
                    sb.append(Constant.messages.getString("api.html.shortcuts"));
                    sb.append("</h3>\n");
                    elementList = new ArrayList();
                    elementList.addAll(otherList);
                    this.appendShortcuts(sb, component, shortcutList);
                }
            }
        } else {
            sb.append("<h3>");
            sb.append(Constant.messages.getString("api.html.components"));
            sb.append("</h3>\n");
            ArrayList<ApiImplementor> components = new ArrayList<ApiImplementor>(this.api.getImplementors().values());
            Collections.sort(components, Comparator.comparing(ApiImplementor::getPrefix));
            sb.append("<table>\n");
            for (ApiImplementor cmp : components) {
                sb.append("<tr>");
                sb.append("<td>");
                sb.append("<a href=\"/");
                sb.append(API.Format.UI.name());
                sb.append('/');
                sb.append(cmp.getPrefix());
                sb.append("/\">");
                sb.append(cmp.getPrefix());
                sb.append("</a>");
                sb.append("</td>");
                sb.append("<td>");
                if (Constant.messages.containsKey(cmp.getDescriptionKey())) {
                    sb.append(Constant.messages.getString(cmp.getDescriptionKey()));
                }
                sb.append("</td>");
                sb.append("</tr>\n");
            }
            sb.append("</table>\n");
        }
        sb.append("</body>\n");
        return sb.toString();
    }

    private static void appendParams(StringBuilder sb, List<ApiParameter> params) {
        for (ApiParameter param : params) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append(param.getName());
            if (param.isRequired()) {
                sb.append('*');
            }
            sb.append("</td>");
            sb.append("<td>");
            sb.append("<input id=\"");
            sb.append(param.getName());
            sb.append("\" name=\"");
            sb.append(param.getName());
            sb.append("\"/>");
            sb.append("</td><td>");
            String descKey = param.getDescriptionKey();
            if (Constant.messages.containsKey(descKey)) {
                sb.append(Constant.messages.getString(descKey));
            }
            sb.append("</td>");
            sb.append("</tr>\n");
        }
    }

    public String handleRequest(URI uri, boolean apiEnabled) {
        StringBuilder sb = new StringBuilder();
        sb.append("<head>\n");
        sb.append("<title>");
        sb.append(Constant.messages.getString("api.html.title"));
        sb.append("</title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append(Constant.messages.getString("api.home.topmsg"));
        sb.append(Constant.messages.getString("api.home.proxypac", "/?apinonce=" + API.getInstance().getLongLivedNonce("/OTHER/core/other/proxy.pac/")));
        sb.append(Constant.messages.getString("api.home.cacert", "/?apinonce=" + API.getInstance().getLongLivedNonce("/OTHER/network/other/rootCaCert/")));
        sb.append(Constant.messages.getString("api.home.links.header"));
        if (apiEnabled) {
            sb.append(Constant.messages.getString("api.home.links.api.enabled"));
        } else {
            sb.append(Constant.messages.getString("api.home.links.api.disabled"));
        }
        sb.append(Constant.messages.getString("api.home.links.online"));
        sb.append("</body>\n");
        return sb.toString();
    }

    private OptionsParamApi getOptionsParamApi() {
        return Model.getSingleton().getOptionsParam().getApiParam();
    }
}

